<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountEncumbranceDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об арестах и обременениях
 * @subpackage Structs
 */
class AccountEncumbranceDatumType extends AccountDatumType
{
    /**
     * The EncumbranceOrg
     * Meta informations extracted from the WSDL
     * - documentation: Организация
     * @var string
     */
    public $EncumbranceOrg;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма ареста/обременения | Поле обязательное к заполнению, может не заполняться если в поле «Организация» указано значение ФНС
     * России | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - documentation: Дата ареста | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $Date;
    /**
     * The Priority
     * Meta informations extracted from the WSDL
     * - documentation: Очерёдность | Очередность
     * - minOccurs: 0
     * - maxInclusive: 5
     * - minInclusive: 1
     * @var int
     */
    public $Priority;
    /**
     * The IPNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNumber;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер Постановления | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The OSPCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OSPCode;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность СПИ | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The SPITel
     * Meta informations extracted from the WSDL
     * - documentation: Телефон СПИ | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $SPITel;
    /**
     * Constructor method for AccountEncumbranceDatumType
     * @uses AccountEncumbranceDatumType::setEncumbranceOrg()
     * @uses AccountEncumbranceDatumType::setAmount()
     * @uses AccountEncumbranceDatumType::setDate()
     * @uses AccountEncumbranceDatumType::setPriority()
     * @uses AccountEncumbranceDatumType::setIPNumber()
     * @uses AccountEncumbranceDatumType::setDocNumber()
     * @uses AccountEncumbranceDatumType::setOSPCode()
     * @uses AccountEncumbranceDatumType::setSPIFio()
     * @uses AccountEncumbranceDatumType::setSPIPost()
     * @uses AccountEncumbranceDatumType::setSPITel()
     * @param string $encumbranceOrg
     * @param float $amount
     * @param string $date
     * @param int $priority
     * @param string $iPNumber
     * @param string $docNumber
     * @param string $oSPCode
     * @param string $sPIFio
     * @param string $sPIPost
     * @param string $sPITel
     */
    public function __construct($encumbranceOrg = null, $amount = null, $date = null, $priority = null, $iPNumber = null, $docNumber = null, $oSPCode = null, $sPIFio = null, $sPIPost = null, $sPITel = null)
    {
        $this
            ->setEncumbranceOrg($encumbranceOrg)
            ->setAmount($amount)
            ->setDate($date)
            ->setPriority($priority)
            ->setIPNumber($iPNumber)
            ->setDocNumber($docNumber)
            ->setOSPCode($oSPCode)
            ->setSPIFio($sPIFio)
            ->setSPIPost($sPIPost)
            ->setSPITel($sPITel);
    }
    /**
     * Get EncumbranceOrg value
     * @return string|null
     */
    public function getEncumbranceOrg()
    {
        return $this->EncumbranceOrg;
    }
    /**
     * Set EncumbranceOrg value
     * @uses \EnumType\EncumbranceOrgType::valueIsValid()
     * @uses \EnumType\EncumbranceOrgType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $encumbranceOrg
     * @return \StructType\AccountEncumbranceDatumType
     */
    public function setEncumbranceOrg($encumbranceOrg = null)
    {
        $this->EncumbranceOrg = $encumbranceOrg;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\AccountEncumbranceDatumType
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\AccountEncumbranceDatumType
     */
    public function setDate($date = null)
    {
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Priority value
     * @return int|null
     */
    public function getPriority()
    {
        return $this->Priority;
    }
    /**
     * Set Priority value
     * @param int $priority
     * @return \StructType\AccountEncumbranceDatumType
     */
    public function setPriority($priority = null)
    {
        $this->Priority = $priority;
        return $this;
    }
    /**
     * Get IPNumber value
     * @return string|null
     */
    public function getIPNumber()
    {
        return $this->IPNumber;
    }
    /**
     * Set IPNumber value
     * @param string $iPNumber
     * @return \StructType\AccountEncumbranceDatumType
     */
    public function setIPNumber($iPNumber = null)
    {
        $this->IPNumber = $iPNumber;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \StructType\AccountEncumbranceDatumType
     */
    public function setDocNumber($docNumber = null)
    {
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get OSPCode value
     * @return string|null
     */
    public function getOSPCode()
    {
        return $this->OSPCode;
    }
    /**
     * Set OSPCode value
     * @param string $oSPCode
     * @return \StructType\AccountEncumbranceDatumType
     */
    public function setOSPCode($oSPCode = null)
    {
        $this->OSPCode = $oSPCode;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \StructType\AccountEncumbranceDatumType
     */
    public function setSPIFio($sPIFio = null)
    {
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \StructType\AccountEncumbranceDatumType
     */
    public function setSPIPost($sPIPost = null)
    {
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get SPITel value
     * @return string|null
     */
    public function getSPITel()
    {
        return $this->SPITel;
    }
    /**
     * Set SPITel value
     * @param string $sPITel
     * @return \StructType\AccountEncumbranceDatumType
     */
    public function setSPITel($sPITel = null)
    {
        $this->SPITel = $sPITel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountEncumbranceDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
