<?php

namespace EnumType;

/**
 * This class stands for ValidationStepType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип этапа проверки
 * @subpackage Enumerations
 */
class ValidationStepType
{
    /**
     * Constant for value 'Flp'
     * @return string 'Flp'
     */
    const VALUE_FLP = 'Flp';
    /**
     * Constant for value 'Notary'
     * @return string 'Notary'
     */
    const VALUE_NOTARY = 'Notary';
    /**
     * Constant for value 'Assistant'
     * @return string 'Assistant'
     */
    const VALUE_ASSISTANT = 'Assistant';
    /**
     * Constant for value 'Blank'
     * @return string 'Blank'
     */
    const VALUE_BLANK = 'Blank';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FLP
     * @uses self::VALUE_NOTARY
     * @uses self::VALUE_ASSISTANT
     * @uses self::VALUE_BLANK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FLP,
            self::VALUE_NOTARY,
            self::VALUE_ASSISTANT,
            self::VALUE_BLANK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
