<?php

namespace EnumType;

/**
 * This class stands for TreatmentStatusCode EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Статусы электронных обращений, передаваемые в реестре вопросов обращений граждан
 * @subpackage Enumerations
 */
class TreatmentStatusCode
{
    /**
     * Constant for value '4'
     * @return string '4'
     */
    const VALUE_4 = '4';
    /**
     * Constant for value '7'
     * @return string '7'
     */
    const VALUE_7 = '7';
    /**
     * Constant for value '61'
     * @return string '61'
     */
    const VALUE_61 = '61';
    /**
     * Constant for value '62'
     * @return string '62'
     */
    const VALUE_62 = '62';
    /**
     * Constant for value '63'
     * @return string '63'
     */
    const VALUE_63 = '63';
    /**
     * Constant for value 'NotReceived'
     * @return string 'NotReceived'
     */
    const VALUE_NOT_RECEIVED = 'NotReceived';
    /**
     * Constant for value 'NotRegistered'
     * @return string 'NotRegistered'
     */
    const VALUE_NOT_REGISTERED = 'NotRegistered';
    /**
     * Constant for value 'InWork'
     * @return string 'InWork'
     */
    const VALUE_IN_WORK = 'InWork';
    /**
     * Constant for value 'Explained'
     * @return string 'Explained'
     */
    const VALUE_EXPLAINED = 'Explained';
    /**
     * Constant for value 'Supported'
     * @return string 'Supported'
     */
    const VALUE_SUPPORTED = 'Supported';
    /**
     * Constant for value 'NotSupported'
     * @return string 'NotSupported'
     */
    const VALUE_NOT_SUPPORTED = 'NotSupported';
    /**
     * Constant for value 'Transferred'
     * @return string 'Transferred'
     */
    const VALUE_TRANSFERRED = 'Transferred';
    /**
     * Constant for value 'Answered'
     * @return string 'Answered'
     */
    const VALUE_ANSWERED = 'Answered';
    /**
     * Constant for value 'LeftWithoutAnswer'
     * @return string 'LeftWithoutAnswer'
     */
    const VALUE_LEFT_WITHOUT_ANSWER = 'LeftWithoutAnswer';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_4
     * @uses self::VALUE_7
     * @uses self::VALUE_61
     * @uses self::VALUE_62
     * @uses self::VALUE_63
     * @uses self::VALUE_NOT_RECEIVED
     * @uses self::VALUE_NOT_REGISTERED
     * @uses self::VALUE_IN_WORK
     * @uses self::VALUE_EXPLAINED
     * @uses self::VALUE_SUPPORTED
     * @uses self::VALUE_NOT_SUPPORTED
     * @uses self::VALUE_TRANSFERRED
     * @uses self::VALUE_ANSWERED
     * @uses self::VALUE_LEFT_WITHOUT_ANSWER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_4,
            self::VALUE_7,
            self::VALUE_61,
            self::VALUE_62,
            self::VALUE_63,
            self::VALUE_NOT_RECEIVED,
            self::VALUE_NOT_REGISTERED,
            self::VALUE_IN_WORK,
            self::VALUE_EXPLAINED,
            self::VALUE_SUPPORTED,
            self::VALUE_NOT_SUPPORTED,
            self::VALUE_TRANSFERRED,
            self::VALUE_ANSWERED,
            self::VALUE_LEFT_WITHOUT_ANSWER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
