<?php

namespace EnumType;

/**
 * This class stands for SPIManagementTypeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Должностное лицо, на имя которого подается жалоба
 * @subpackage Enumerations
 */
class SPIManagementTypeType
{
    /**
     * Constant for value 'SSP'
     * @return string 'SSP'
     */
    const VALUE_SSP = 'SSP';
    /**
     * Constant for value 'SSP_SUBJECT_RF'
     * @return string 'SSP_SUBJECT_RF'
     */
    const VALUE_SSP_SUBJECT_RF = 'SSP_SUBJECT_RF';
    /**
     * Constant for value 'SSP_RF'
     * @return string 'SSP_RF'
     */
    const VALUE_SSP_RF = 'SSP_RF';
    /**
     * Constant for value 'SSP_SUBJECT_RFZ'
     * @return string 'SSP_SUBJECT_RFZ'
     */
    const VALUE_SSP_SUBJECT_RFZ = 'SSP_SUBJECT_RFZ';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SSP
     * @uses self::VALUE_SSP_SUBJECT_RF
     * @uses self::VALUE_SSP_RF
     * @uses self::VALUE_SSP_SUBJECT_RFZ
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SSP,
            self::VALUE_SSP_SUBJECT_RF,
            self::VALUE_SSP_RF,
            self::VALUE_SSP_SUBJECT_RFZ,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
