<?php

namespace EnumType;

/**
 * This class stands for MailStateType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Статус почтового отправления
 * @subpackage Enumerations
 */
class MailStateType
{
    /**
     * Constant for value 'DELIVERED'
     * @return string 'DELIVERED'
     */
    const VALUE_DELIVERED = 'DELIVERED';
    /**
     * Constant for value 'RETURNED'
     * @return string 'RETURNED'
     */
    const VALUE_RETURNED = 'RETURNED';
    /**
     * Constant for value 'DELIVERED_ADK'
     * @return string 'DELIVERED_ADK'
     */
    const VALUE_DELIVERED_ADK = 'DELIVERED_ADK';
    /**
     * Constant for value 'RETURNED_ADK'
     * @return string 'RETURNED_ADK'
     */
    const VALUE_RETURNED_ADK = 'RETURNED_ADK';
    /**
     * Constant for value 'ERASED'
     * @return string 'ERASED'
     */
    const VALUE_ERASED = 'ERASED';
    /**
     * Constant for value 'ERROR'
     * @return string 'ERROR'
     */
    const VALUE_ERROR = 'ERROR';
    /**
     * Constant for value 'TRAN_TO_STORAGE'
     * @return string 'TRAN_TO_STORAGE'
     */
    const VALUE_TRAN_TO_STORAGE = 'TRAN_TO_STORAGE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DELIVERED
     * @uses self::VALUE_RETURNED
     * @uses self::VALUE_DELIVERED_ADK
     * @uses self::VALUE_RETURNED_ADK
     * @uses self::VALUE_ERASED
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_TRAN_TO_STORAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DELIVERED,
            self::VALUE_RETURNED,
            self::VALUE_DELIVERED_ADK,
            self::VALUE_RETURNED_ADK,
            self::VALUE_ERASED,
            self::VALUE_ERROR,
            self::VALUE_TRAN_TO_STORAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
