<?php

namespace EnumType;

/**
 * This class stands for ApplicationStatus EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Код смены статуса заявления в отделе
 * @subpackage Enumerations
 */
class ApplicationStatus
{
    /**
     * Constant for value 'NEW'
     * @return string 'NEW'
     */
    const VALUE_NEW = 'NEW';
    /**
     * Constant for value 'REGISTERED'
     * @return string 'REGISTERED'
     */
    const VALUE_REGISTERED = 'REGISTERED';
    /**
     * Constant for value 'ASSIGNED'
     * @return string 'ASSIGNED'
     */
    const VALUE_ASSIGNED = 'ASSIGNED';
    /**
     * Constant for value 'COMPLETED'
     * @return string 'COMPLETED'
     */
    const VALUE_COMPLETED = 'COMPLETED';
    /**
     * Constant for value 'REJECTED'
     * @return string 'REJECTED'
     */
    const VALUE_REJECTED = 'REJECTED';
    /**
     * Constant for value 'TRANSFERRED'
     * @return string 'TRANSFERRED'
     */
    const VALUE_TRANSFERRED = 'TRANSFERRED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NEW
     * @uses self::VALUE_REGISTERED
     * @uses self::VALUE_ASSIGNED
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_REJECTED
     * @uses self::VALUE_TRANSFERRED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NEW,
            self::VALUE_REGISTERED,
            self::VALUE_ASSIGNED,
            self::VALUE_COMPLETED,
            self::VALUE_REJECTED,
            self::VALUE_TRANSFERRED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
