<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransportDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений TransportDataType "Транспортное средство" | Этот тип данных используется для передачи данных о транспортных средствах,
 * имеющих государственный регистрационный знак
 * @subpackage Structs
 */
class TransportDataType extends InformationType
{
    /**
     * The AutomType
     * Meta informations extracted from the WSDL
     * - documentation: Категория транспортного средства (грузовой, автобус и др.) | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $AutomType;
    /**
     * The AutomTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Наименование типа ТС
     * - minOccurs: 0
     * @var string
     */
    public $AutomTypeCode;
    /**
     * The RegNo
     * Meta informations extracted from the WSDL
     * - documentation: Государственный регистрационный знак | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $RegNo;
    /**
     * The PreviousRegNo
     * Meta informations extracted from the WSDL
     * - documentation: Прежний регистрационный знак | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $PreviousRegNo;
    /**
     * The Producer
     * Meta informations extracted from the WSDL
     * - documentation: Марка | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Producer;
    /**
     * The Model
     * Meta informations extracted from the WSDL
     * - documentation: Модель | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Model;
    /**
     * The SpecialPurposeCode
     * Meta informations extracted from the WSDL
     * - documentation: Код специального назначения ТС | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $SpecialPurposeCode;
    /**
     * The VIN
     * Meta informations extracted from the WSDL
     * - documentation: VIN | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $VIN;
    /**
     * The Engine
     * Meta informations extracted from the WSDL
     * - documentation: Номер двигателя | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Engine;
    /**
     * The EngineVolume
     * Meta informations extracted from the WSDL
     * - documentation: Объём двигателя, см куб. | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EngineVolume;
    /**
     * The EnginePowerKWh
     * Meta informations extracted from the WSDL
     * - documentation: Мощность двигателя, кВт | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerKWh;
    /**
     * The EnginePowerHp
     * Meta informations extracted from the WSDL
     * - documentation: Мощность двигателя, л.с. | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerHp;
    /**
     * The ChassisNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер шасси (рамы) | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $ChassisNumber;
    /**
     * The BodyNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер кузова (прицепа) | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $BodyNumber;
    /**
     * The Color
     * Meta informations extracted from the WSDL
     * - documentation: Цвет | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Color;
    /**
     * The MadeYear
     * Meta informations extracted from the WSDL
     * - documentation: Год выпуска автотранспортного средства | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $MadeYear;
    /**
     * The DeptCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $DeptCode;
    /**
     * The DeptName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование подразделения ГИБДД | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DeptName;
    /**
     * The RegisterDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegisterDate;
    /**
     * The UnregisterDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата отчуждения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $UnregisterDate;
    /**
     * The PrimaryPTS
     * Meta informations extracted from the WSDL
     * - documentation: Первичный ПТС (уникальный номер регистрации) | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $PrimaryPTS;
    /**
     * The OperationName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование технологической операции | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $OperationName;
    /**
     * The RegDocName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование регистрационного документа | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $RegDocName;
    /**
     * The RegDocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Серия и номер регистрационного документа | Строка длиной от 1 до 18 символов
     * - minOccurs: 0
     * - maxLength: 18
     * - minLength: 1
     * @var string
     */
    public $RegDocNumber;
    /**
     * The RegDocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи регистрационного документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegDocDate;
    /**
     * Constructor method for TransportDataType
     * @uses TransportDataType::setAutomType()
     * @uses TransportDataType::setAutomTypeCode()
     * @uses TransportDataType::setRegNo()
     * @uses TransportDataType::setPreviousRegNo()
     * @uses TransportDataType::setProducer()
     * @uses TransportDataType::setModel()
     * @uses TransportDataType::setSpecialPurposeCode()
     * @uses TransportDataType::setVIN()
     * @uses TransportDataType::setEngine()
     * @uses TransportDataType::setEngineVolume()
     * @uses TransportDataType::setEnginePowerKWh()
     * @uses TransportDataType::setEnginePowerHp()
     * @uses TransportDataType::setChassisNumber()
     * @uses TransportDataType::setBodyNumber()
     * @uses TransportDataType::setColor()
     * @uses TransportDataType::setMadeYear()
     * @uses TransportDataType::setDeptCode()
     * @uses TransportDataType::setDeptName()
     * @uses TransportDataType::setRegisterDate()
     * @uses TransportDataType::setUnregisterDate()
     * @uses TransportDataType::setPrimaryPTS()
     * @uses TransportDataType::setOperationName()
     * @uses TransportDataType::setRegDocName()
     * @uses TransportDataType::setRegDocNumber()
     * @uses TransportDataType::setRegDocDate()
     * @param string $automType
     * @param string $automTypeCode
     * @param string $regNo
     * @param string $previousRegNo
     * @param string $producer
     * @param string $model
     * @param string $specialPurposeCode
     * @param string $vIN
     * @param string $engine
     * @param float $engineVolume
     * @param float $enginePowerKWh
     * @param float $enginePowerHp
     * @param string $chassisNumber
     * @param string $bodyNumber
     * @param string $color
     * @param string $madeYear
     * @param string $deptCode
     * @param string $deptName
     * @param string $registerDate
     * @param string $unregisterDate
     * @param string $primaryPTS
     * @param string $operationName
     * @param string $regDocName
     * @param string $regDocNumber
     * @param string $regDocDate
     */
    public function __construct($automType = null, $automTypeCode = null, $regNo = null, $previousRegNo = null, $producer = null, $model = null, $specialPurposeCode = null, $vIN = null, $engine = null, $engineVolume = null, $enginePowerKWh = null, $enginePowerHp = null, $chassisNumber = null, $bodyNumber = null, $color = null, $madeYear = null, $deptCode = null, $deptName = null, $registerDate = null, $unregisterDate = null, $primaryPTS = null, $operationName = null, $regDocName = null, $regDocNumber = null, $regDocDate = null)
    {
        $this
            ->setAutomType($automType)
            ->setAutomTypeCode($automTypeCode)
            ->setRegNo($regNo)
            ->setPreviousRegNo($previousRegNo)
            ->setProducer($producer)
            ->setModel($model)
            ->setSpecialPurposeCode($specialPurposeCode)
            ->setVIN($vIN)
            ->setEngine($engine)
            ->setEngineVolume($engineVolume)
            ->setEnginePowerKWh($enginePowerKWh)
            ->setEnginePowerHp($enginePowerHp)
            ->setChassisNumber($chassisNumber)
            ->setBodyNumber($bodyNumber)
            ->setColor($color)
            ->setMadeYear($madeYear)
            ->setDeptCode($deptCode)
            ->setDeptName($deptName)
            ->setRegisterDate($registerDate)
            ->setUnregisterDate($unregisterDate)
            ->setPrimaryPTS($primaryPTS)
            ->setOperationName($operationName)
            ->setRegDocName($regDocName)
            ->setRegDocNumber($regDocNumber)
            ->setRegDocDate($regDocDate);
    }
    /**
     * Get AutomType value
     * @return string|null
     */
    public function getAutomType()
    {
        return $this->AutomType;
    }
    /**
     * Set AutomType value
     * @param string $automType
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setAutomType($automType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($automType) && strlen($automType) > 50) || (is_array($automType) && count($automType) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($automType) ? strlen($automType) : count($automType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($automType) && strlen($automType) < 1) || (is_array($automType) && count($automType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($automType) && !is_string($automType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($automType)), __LINE__);
        }
        $this->AutomType = $automType;
        return $this;
    }
    /**
     * Get AutomTypeCode value
     * @return string|null
     */
    public function getAutomTypeCode()
    {
        return $this->AutomTypeCode;
    }
    /**
     * Set AutomTypeCode value
     * @uses \AisFssp\EnumType\TransportCategoryCodeType::valueIsValid()
     * @uses \AisFssp\EnumType\TransportCategoryCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $automTypeCode
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setAutomTypeCode($automTypeCode = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\TransportCategoryCodeType::valueIsValid($automTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $automTypeCode, implode(', ', \AisFssp\EnumType\TransportCategoryCodeType::getValidValues())), __LINE__);
        }
        $this->AutomTypeCode = $automTypeCode;
        return $this;
    }
    /**
     * Get RegNo value
     * @return string|null
     */
    public function getRegNo()
    {
        return $this->RegNo;
    }
    /**
     * Set RegNo value
     * @param string $regNo
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setRegNo($regNo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regNo) && strlen($regNo) > 20) || (is_array($regNo) && count($regNo) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($regNo) ? strlen($regNo) : count($regNo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($regNo) && strlen($regNo) < 1) || (is_array($regNo) && count($regNo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regNo) && !is_string($regNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regNo)), __LINE__);
        }
        $this->RegNo = $regNo;
        return $this;
    }
    /**
     * Get PreviousRegNo value
     * @return string|null
     */
    public function getPreviousRegNo()
    {
        return $this->PreviousRegNo;
    }
    /**
     * Set PreviousRegNo value
     * @param string $previousRegNo
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setPreviousRegNo($previousRegNo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($previousRegNo) && strlen($previousRegNo) > 20) || (is_array($previousRegNo) && count($previousRegNo) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($previousRegNo) ? strlen($previousRegNo) : count($previousRegNo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($previousRegNo) && strlen($previousRegNo) < 1) || (is_array($previousRegNo) && count($previousRegNo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($previousRegNo) && !is_string($previousRegNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($previousRegNo)), __LINE__);
        }
        $this->PreviousRegNo = $previousRegNo;
        return $this;
    }
    /**
     * Get Producer value
     * @return string|null
     */
    public function getProducer()
    {
        return $this->Producer;
    }
    /**
     * Set Producer value
     * @param string $producer
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setProducer($producer = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($producer) && strlen($producer) > 50) || (is_array($producer) && count($producer) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($producer) ? strlen($producer) : count($producer)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($producer) && strlen($producer) < 1) || (is_array($producer) && count($producer) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($producer) && !is_string($producer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($producer)), __LINE__);
        }
        $this->Producer = $producer;
        return $this;
    }
    /**
     * Get Model value
     * @return string|null
     */
    public function getModel()
    {
        return $this->Model;
    }
    /**
     * Set Model value
     * @param string $model
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setModel($model = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($model) && strlen($model) > 50) || (is_array($model) && count($model) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($model) ? strlen($model) : count($model)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($model) && strlen($model) < 1) || (is_array($model) && count($model) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($model) && !is_string($model)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($model)), __LINE__);
        }
        $this->Model = $model;
        return $this;
    }
    /**
     * Get SpecialPurposeCode value
     * @return string|null
     */
    public function getSpecialPurposeCode()
    {
        return $this->SpecialPurposeCode;
    }
    /**
     * Set SpecialPurposeCode value
     * @param string $specialPurposeCode
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setSpecialPurposeCode($specialPurposeCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($specialPurposeCode) && strlen($specialPurposeCode) > 50) || (is_array($specialPurposeCode) && count($specialPurposeCode) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($specialPurposeCode) ? strlen($specialPurposeCode) : count($specialPurposeCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($specialPurposeCode) && strlen($specialPurposeCode) < 1) || (is_array($specialPurposeCode) && count($specialPurposeCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($specialPurposeCode) && !is_string($specialPurposeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($specialPurposeCode)), __LINE__);
        }
        $this->SpecialPurposeCode = $specialPurposeCode;
        return $this;
    }
    /**
     * Get VIN value
     * @return string|null
     */
    public function getVIN()
    {
        return $this->VIN;
    }
    /**
     * Set VIN value
     * @param string $vIN
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setVIN($vIN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vIN) && strlen($vIN) > 20) || (is_array($vIN) && count($vIN) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($vIN) ? strlen($vIN) : count($vIN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($vIN) && strlen($vIN) < 1) || (is_array($vIN) && count($vIN) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vIN) && !is_string($vIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vIN)), __LINE__);
        }
        $this->VIN = $vIN;
        return $this;
    }
    /**
     * Get Engine value
     * @return string|null
     */
    public function getEngine()
    {
        return $this->Engine;
    }
    /**
     * Set Engine value
     * @param string $engine
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setEngine($engine = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($engine) && strlen($engine) > 50) || (is_array($engine) && count($engine) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($engine) ? strlen($engine) : count($engine)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($engine) && strlen($engine) < 1) || (is_array($engine) && count($engine) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($engine) && !is_string($engine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($engine)), __LINE__);
        }
        $this->Engine = $engine;
        return $this;
    }
    /**
     * Get EngineVolume value
     * @return float|null
     */
    public function getEngineVolume()
    {
        return $this->EngineVolume;
    }
    /**
     * Set EngineVolume value
     * @param float $engineVolume
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setEngineVolume($engineVolume = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($engineVolume) && strlen(substr($engineVolume, strpos($engineVolume, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($engineVolume, strpos($engineVolume, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($engineVolume) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $engineVolume)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($engineVolume, strpos($engineVolume, '.')))), __LINE__);
        }
        $this->EngineVolume = $engineVolume;
        return $this;
    }
    /**
     * Get EnginePowerKWh value
     * @return float|null
     */
    public function getEnginePowerKWh()
    {
        return $this->EnginePowerKWh;
    }
    /**
     * Set EnginePowerKWh value
     * @param float $enginePowerKWh
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setEnginePowerKWh($enginePowerKWh = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($enginePowerKWh) && strlen(substr($enginePowerKWh, strpos($enginePowerKWh, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($enginePowerKWh, strpos($enginePowerKWh, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($enginePowerKWh) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $enginePowerKWh)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($enginePowerKWh, strpos($enginePowerKWh, '.')))), __LINE__);
        }
        $this->EnginePowerKWh = $enginePowerKWh;
        return $this;
    }
    /**
     * Get EnginePowerHp value
     * @return float|null
     */
    public function getEnginePowerHp()
    {
        return $this->EnginePowerHp;
    }
    /**
     * Set EnginePowerHp value
     * @param float $enginePowerHp
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setEnginePowerHp($enginePowerHp = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($enginePowerHp) && strlen(substr($enginePowerHp, strpos($enginePowerHp, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($enginePowerHp, strpos($enginePowerHp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($enginePowerHp) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $enginePowerHp)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($enginePowerHp, strpos($enginePowerHp, '.')))), __LINE__);
        }
        $this->EnginePowerHp = $enginePowerHp;
        return $this;
    }
    /**
     * Get ChassisNumber value
     * @return string|null
     */
    public function getChassisNumber()
    {
        return $this->ChassisNumber;
    }
    /**
     * Set ChassisNumber value
     * @param string $chassisNumber
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setChassisNumber($chassisNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($chassisNumber) && strlen($chassisNumber) > 20) || (is_array($chassisNumber) && count($chassisNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($chassisNumber) ? strlen($chassisNumber) : count($chassisNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($chassisNumber) && strlen($chassisNumber) < 1) || (is_array($chassisNumber) && count($chassisNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($chassisNumber) && !is_string($chassisNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chassisNumber)), __LINE__);
        }
        $this->ChassisNumber = $chassisNumber;
        return $this;
    }
    /**
     * Get BodyNumber value
     * @return string|null
     */
    public function getBodyNumber()
    {
        return $this->BodyNumber;
    }
    /**
     * Set BodyNumber value
     * @param string $bodyNumber
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setBodyNumber($bodyNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bodyNumber) && strlen($bodyNumber) > 20) || (is_array($bodyNumber) && count($bodyNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($bodyNumber) ? strlen($bodyNumber) : count($bodyNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($bodyNumber) && strlen($bodyNumber) < 1) || (is_array($bodyNumber) && count($bodyNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bodyNumber) && !is_string($bodyNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bodyNumber)), __LINE__);
        }
        $this->BodyNumber = $bodyNumber;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setColor($color = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($color) && strlen($color) > 20) || (is_array($color) && count($color) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($color) ? strlen($color) : count($color)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($color) && strlen($color) < 1) || (is_array($color) && count($color) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Get MadeYear value
     * @return string|null
     */
    public function getMadeYear()
    {
        return $this->MadeYear;
    }
    /**
     * Set MadeYear value
     * @param string $madeYear
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setMadeYear($madeYear = null)
    {
        // validation for constraint: maxInclusive
        if ($madeYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $madeYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($madeYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $madeYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($madeYear) && !is_string($madeYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($madeYear)), __LINE__);
        }
        $this->MadeYear = $madeYear;
        return $this;
    }
    /**
     * Get DeptCode value
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->DeptCode;
    }
    /**
     * Set DeptCode value
     * @param string $deptCode
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setDeptCode($deptCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($deptCode) && strlen($deptCode) > 10) || (is_array($deptCode) && count($deptCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($deptCode) ? strlen($deptCode) : count($deptCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($deptCode) && strlen($deptCode) < 1) || (is_array($deptCode) && count($deptCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deptCode) && !is_string($deptCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deptCode)), __LINE__);
        }
        $this->DeptCode = $deptCode;
        return $this;
    }
    /**
     * Get DeptName value
     * @return string|null
     */
    public function getDeptName()
    {
        return $this->DeptName;
    }
    /**
     * Set DeptName value
     * @param string $deptName
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setDeptName($deptName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($deptName) && strlen($deptName) > 1000) || (is_array($deptName) && count($deptName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($deptName) ? strlen($deptName) : count($deptName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($deptName) && strlen($deptName) < 1) || (is_array($deptName) && count($deptName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deptName) && !is_string($deptName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deptName)), __LINE__);
        }
        $this->DeptName = $deptName;
        return $this;
    }
    /**
     * Get RegisterDate value
     * @return string|null
     */
    public function getRegisterDate()
    {
        return $this->RegisterDate;
    }
    /**
     * Set RegisterDate value
     * @param string $registerDate
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setRegisterDate($registerDate = null)
    {
        // validation for constraint: maxExclusive
        if ($registerDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $registerDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($registerDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $registerDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registerDate) && !is_string($registerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registerDate)), __LINE__);
        }
        $this->RegisterDate = $registerDate;
        return $this;
    }
    /**
     * Get UnregisterDate value
     * @return string|null
     */
    public function getUnregisterDate()
    {
        return $this->UnregisterDate;
    }
    /**
     * Set UnregisterDate value
     * @param string $unregisterDate
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setUnregisterDate($unregisterDate = null)
    {
        // validation for constraint: maxExclusive
        if ($unregisterDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $unregisterDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($unregisterDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $unregisterDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unregisterDate) && !is_string($unregisterDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unregisterDate)), __LINE__);
        }
        $this->UnregisterDate = $unregisterDate;
        return $this;
    }
    /**
     * Get PrimaryPTS value
     * @return string|null
     */
    public function getPrimaryPTS()
    {
        return $this->PrimaryPTS;
    }
    /**
     * Set PrimaryPTS value
     * @param string $primaryPTS
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setPrimaryPTS($primaryPTS = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($primaryPTS) && strlen($primaryPTS) > 20) || (is_array($primaryPTS) && count($primaryPTS) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($primaryPTS) ? strlen($primaryPTS) : count($primaryPTS)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($primaryPTS) && strlen($primaryPTS) < 1) || (is_array($primaryPTS) && count($primaryPTS) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($primaryPTS) && !is_string($primaryPTS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($primaryPTS)), __LINE__);
        }
        $this->PrimaryPTS = $primaryPTS;
        return $this;
    }
    /**
     * Get OperationName value
     * @return string|null
     */
    public function getOperationName()
    {
        return $this->OperationName;
    }
    /**
     * Set OperationName value
     * @param string $operationName
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setOperationName($operationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($operationName) && strlen($operationName) > 1000) || (is_array($operationName) && count($operationName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($operationName) ? strlen($operationName) : count($operationName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($operationName) && strlen($operationName) < 1) || (is_array($operationName) && count($operationName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($operationName) && !is_string($operationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operationName)), __LINE__);
        }
        $this->OperationName = $operationName;
        return $this;
    }
    /**
     * Get RegDocName value
     * @return string|null
     */
    public function getRegDocName()
    {
        return $this->RegDocName;
    }
    /**
     * Set RegDocName value
     * @param string $regDocName
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setRegDocName($regDocName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regDocName) && strlen($regDocName) > 1000) || (is_array($regDocName) && count($regDocName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($regDocName) ? strlen($regDocName) : count($regDocName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($regDocName) && strlen($regDocName) < 1) || (is_array($regDocName) && count($regDocName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regDocName) && !is_string($regDocName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDocName)), __LINE__);
        }
        $this->RegDocName = $regDocName;
        return $this;
    }
    /**
     * Get RegDocNumber value
     * @return string|null
     */
    public function getRegDocNumber()
    {
        return $this->RegDocNumber;
    }
    /**
     * Set RegDocNumber value
     * @param string $regDocNumber
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setRegDocNumber($regDocNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regDocNumber) && strlen($regDocNumber) > 18) || (is_array($regDocNumber) && count($regDocNumber) > 18)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 18 element(s) or a scalar of 18 character(s) at most, "%d" length given', is_scalar($regDocNumber) ? strlen($regDocNumber) : count($regDocNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($regDocNumber) && strlen($regDocNumber) < 1) || (is_array($regDocNumber) && count($regDocNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regDocNumber) && !is_string($regDocNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDocNumber)), __LINE__);
        }
        $this->RegDocNumber = $regDocNumber;
        return $this;
    }
    /**
     * Get RegDocDate value
     * @return string|null
     */
    public function getRegDocDate()
    {
        return $this->RegDocDate;
    }
    /**
     * Set RegDocDate value
     * @param string $regDocDate
     * @return \AisFssp\StructType\TransportDataType
     */
    public function setRegDocDate($regDocDate = null)
    {
        // validation for constraint: maxExclusive
        if ($regDocDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $regDocDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($regDocDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $regDocDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regDocDate) && !is_string($regDocDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDocDate)), __LINE__);
        }
        $this->RegDocDate = $regDocDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\TransportDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
