<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о финансовой операции
 * @subpackage Structs
 */
class TransactionDatumType extends InformationType
{
    /**
     * The transactKindCode
     * Meta informations extracted from the WSDL
     * - documentation: Код типа операции | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $transactKindCode;
    /**
     * The transactKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование типа операции | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $transactKindName;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $amount;
    /**
     * The ground
     * Meta informations extracted from the WSDL
     * - documentation: Основание | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $ground;
    /**
     * The sides
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о сторонах операции
     * - maxOccurs: unbounded
     * @var \AisFssp\StructType\TransactionSideType[]
     */
    public $sides;
    /**
     * Constructor method for TransactionDatumType
     * @uses TransactionDatumType::setTransactKindCode()
     * @uses TransactionDatumType::setTransactKindName()
     * @uses TransactionDatumType::setAmount()
     * @uses TransactionDatumType::setGround()
     * @uses TransactionDatumType::setSides()
     * @param string $transactKindCode
     * @param string $transactKindName
     * @param float $amount
     * @param string $ground
     * @param \AisFssp\StructType\TransactionSideType[] $sides
     */
    public function __construct($transactKindCode = null, $transactKindName = null, $amount = null, $ground = null, array $sides = array())
    {
        $this
            ->setTransactKindCode($transactKindCode)
            ->setTransactKindName($transactKindName)
            ->setAmount($amount)
            ->setGround($ground)
            ->setSides($sides);
    }
    /**
     * Get transactKindCode value
     * @return string|null
     */
    public function getTransactKindCode()
    {
        return $this->transactKindCode;
    }
    /**
     * Set transactKindCode value
     * @param string $transactKindCode
     * @return \AisFssp\StructType\TransactionDatumType
     */
    public function setTransactKindCode($transactKindCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($transactKindCode) && strlen($transactKindCode) > 10) || (is_array($transactKindCode) && count($transactKindCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($transactKindCode) ? strlen($transactKindCode) : count($transactKindCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($transactKindCode) && strlen($transactKindCode) < 1) || (is_array($transactKindCode) && count($transactKindCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transactKindCode) && !is_string($transactKindCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactKindCode)), __LINE__);
        }
        $this->transactKindCode = $transactKindCode;
        return $this;
    }
    /**
     * Get transactKindName value
     * @return string|null
     */
    public function getTransactKindName()
    {
        return $this->transactKindName;
    }
    /**
     * Set transactKindName value
     * @param string $transactKindName
     * @return \AisFssp\StructType\TransactionDatumType
     */
    public function setTransactKindName($transactKindName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($transactKindName) && strlen($transactKindName) > 100) || (is_array($transactKindName) && count($transactKindName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($transactKindName) ? strlen($transactKindName) : count($transactKindName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($transactKindName) && strlen($transactKindName) < 1) || (is_array($transactKindName) && count($transactKindName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($transactKindName) && !is_string($transactKindName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactKindName)), __LINE__);
        }
        $this->transactKindName = $transactKindName;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \AisFssp\StructType\TransactionDatumType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($amount, strpos($amount, '.')))), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get ground value
     * @return string|null
     */
    public function getGround()
    {
        return $this->ground;
    }
    /**
     * Set ground value
     * @param string $ground
     * @return \AisFssp\StructType\TransactionDatumType
     */
    public function setGround($ground = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ground) && strlen($ground) > 300) || (is_array($ground) && count($ground) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($ground) ? strlen($ground) : count($ground)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ground) && strlen($ground) < 1) || (is_array($ground) && count($ground) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ground) && !is_string($ground)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ground)), __LINE__);
        }
        $this->ground = $ground;
        return $this;
    }
    /**
     * Get sides value
     * @return \AisFssp\StructType\TransactionSideType[]|null
     */
    public function getSides()
    {
        return $this->sides;
    }
    /**
     * Set sides value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\TransactionSideType[] $sides
     * @return \AisFssp\StructType\TransactionDatumType
     */
    public function setSides(array $sides = array())
    {
        foreach ($sides as $transactionDatumTypeSidesItem) {
            // validation for constraint: itemType
            if (!$transactionDatumTypeSidesItem instanceof \AisFssp\StructType\TransactionSideType) {
                throw new \InvalidArgumentException(sprintf('The sides property can only contain items of \AisFssp\StructType\TransactionSideType, "%s" given', is_object($transactionDatumTypeSidesItem) ? get_class($transactionDatumTypeSidesItem) : gettype($transactionDatumTypeSidesItem)), __LINE__);
            }
        }
        $this->sides = $sides;
        return $this;
    }
    /**
     * Add item to sides value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\TransactionSideType $item
     * @return \AisFssp\StructType\TransactionDatumType
     */
    public function addToSides(\AisFssp\StructType\TransactionSideType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\TransactionSideType) {
            throw new \InvalidArgumentException(sprintf('The sides property can only contain items of \AisFssp\StructType\TransactionSideType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->sides[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\TransactionDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
