<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedRabDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений SvedRabDataType "Место получения дохода"
 * @subpackage Structs
 */
class SvedRabDataType extends InformationType
{
    /**
     * The NaimOrg
     * Meta informations extracted from the WSDL
     * - documentation: Наименование организации/ФИО индивидуального предпринимателя | Полное наименование организации/индивидуального
     * предпринимателя | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $NaimOrg;
    /**
     * The AdresJ
     * Meta informations extracted from the WSDL
     * - documentation: Юридический адрес | Юридический адрес организации/индивидуального предпринимателя | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $AdresJ;
    /**
     * The AdresF
     * Meta informations extracted from the WSDL
     * - documentation: Фактический адрес | Фактический адрес организации/индивидуального предпринимателя | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $AdresF;
    /**
     * Constructor method for SvedRabDataType
     * @uses SvedRabDataType::setNaimOrg()
     * @uses SvedRabDataType::setAdresJ()
     * @uses SvedRabDataType::setAdresF()
     * @param string $naimOrg
     * @param string $adresJ
     * @param string $adresF
     */
    public function __construct($naimOrg = null, $adresJ = null, $adresF = null)
    {
        $this
            ->setNaimOrg($naimOrg)
            ->setAdresJ($adresJ)
            ->setAdresF($adresF);
    }
    /**
     * Get NaimOrg value
     * @return string|null
     */
    public function getNaimOrg()
    {
        return $this->NaimOrg;
    }
    /**
     * Set NaimOrg value
     * @param string $naimOrg
     * @return \AisFssp\StructType\SvedRabDataType
     */
    public function setNaimOrg($naimOrg = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($naimOrg) && strlen($naimOrg) > 1000) || (is_array($naimOrg) && count($naimOrg) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($naimOrg) ? strlen($naimOrg) : count($naimOrg)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($naimOrg) && strlen($naimOrg) < 1) || (is_array($naimOrg) && count($naimOrg) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($naimOrg) && !is_string($naimOrg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($naimOrg)), __LINE__);
        }
        $this->NaimOrg = $naimOrg;
        return $this;
    }
    /**
     * Get AdresJ value
     * @return string|null
     */
    public function getAdresJ()
    {
        return $this->AdresJ;
    }
    /**
     * Set AdresJ value
     * @param string $adresJ
     * @return \AisFssp\StructType\SvedRabDataType
     */
    public function setAdresJ($adresJ = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($adresJ) && strlen($adresJ) > 300) || (is_array($adresJ) && count($adresJ) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($adresJ) ? strlen($adresJ) : count($adresJ)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($adresJ) && strlen($adresJ) < 1) || (is_array($adresJ) && count($adresJ) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($adresJ) && !is_string($adresJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adresJ)), __LINE__);
        }
        $this->AdresJ = $adresJ;
        return $this;
    }
    /**
     * Get AdresF value
     * @return string|null
     */
    public function getAdresF()
    {
        return $this->AdresF;
    }
    /**
     * Set AdresF value
     * @param string $adresF
     * @return \AisFssp\StructType\SvedRabDataType
     */
    public function setAdresF($adresF = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($adresF) && strlen($adresF) > 300) || (is_array($adresF) && count($adresF) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($adresF) ? strlen($adresF) : count($adresF)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($adresF) && strlen($adresF) < 1) || (is_array($adresF) && count($adresF) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($adresF) && !is_string($adresF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($adresF)), __LINE__);
        }
        $this->AdresF = $adresF;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SvedRabDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
