<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SvedNedvRightType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о правах на недвижимость
 * @subpackage Structs
 */
class SvedNedvRightType extends InformationType
{
    /**
     * The rightCode
     * Meta informations extracted from the WSDL
     * - documentation: Код права | Строка длиной от 1 до 12 символов
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $rightCode;
    /**
     * The rightName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование права | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $rightName;
    /**
     * The rightText
     * Meta informations extracted from the WSDL
     * - documentation: Вид права | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $rightText;
    /**
     * The shareValue
     * Meta informations extracted from the WSDL
     * - documentation: Доля (значение)
     * - minOccurs: 0
     * @var \AisFssp\StructType\ShareType
     */
    public $shareValue;
    /**
     * The shareText
     * Meta informations extracted from the WSDL
     * - documentation: Доля (текст) | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $shareText;
    /**
     * The regNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер государствеенной регистрации | Строка длиной от 1 до 45 символов
     * - maxLength: 45
     * - minLength: 1
     * @var string
     */
    public $regNumber;
    /**
     * The regDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата государственной регистрации | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $regDate;
    /**
     * Constructor method for SvedNedvRightType
     * @uses SvedNedvRightType::setRightCode()
     * @uses SvedNedvRightType::setRightName()
     * @uses SvedNedvRightType::setRightText()
     * @uses SvedNedvRightType::setShareValue()
     * @uses SvedNedvRightType::setShareText()
     * @uses SvedNedvRightType::setRegNumber()
     * @uses SvedNedvRightType::setRegDate()
     * @param string $rightCode
     * @param string $rightName
     * @param string $rightText
     * @param \AisFssp\StructType\ShareType $shareValue
     * @param string $shareText
     * @param string $regNumber
     * @param string $regDate
     */
    public function __construct($rightCode = null, $rightName = null, $rightText = null, \AisFssp\StructType\ShareType $shareValue = null, $shareText = null, $regNumber = null, $regDate = null)
    {
        $this
            ->setRightCode($rightCode)
            ->setRightName($rightName)
            ->setRightText($rightText)
            ->setShareValue($shareValue)
            ->setShareText($shareText)
            ->setRegNumber($regNumber)
            ->setRegDate($regDate);
    }
    /**
     * Get rightCode value
     * @return string|null
     */
    public function getRightCode()
    {
        return $this->rightCode;
    }
    /**
     * Set rightCode value
     * @param string $rightCode
     * @return \AisFssp\StructType\SvedNedvRightType
     */
    public function setRightCode($rightCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rightCode) && strlen($rightCode) > 12) || (is_array($rightCode) && count($rightCode) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($rightCode) ? strlen($rightCode) : count($rightCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($rightCode) && strlen($rightCode) < 1) || (is_array($rightCode) && count($rightCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rightCode) && !is_string($rightCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rightCode)), __LINE__);
        }
        $this->rightCode = $rightCode;
        return $this;
    }
    /**
     * Get rightName value
     * @return string|null
     */
    public function getRightName()
    {
        return $this->rightName;
    }
    /**
     * Set rightName value
     * @param string $rightName
     * @return \AisFssp\StructType\SvedNedvRightType
     */
    public function setRightName($rightName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rightName) && strlen($rightName) > 255) || (is_array($rightName) && count($rightName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($rightName) ? strlen($rightName) : count($rightName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($rightName) && strlen($rightName) < 1) || (is_array($rightName) && count($rightName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rightName) && !is_string($rightName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rightName)), __LINE__);
        }
        $this->rightName = $rightName;
        return $this;
    }
    /**
     * Get rightText value
     * @return string|null
     */
    public function getRightText()
    {
        return $this->rightText;
    }
    /**
     * Set rightText value
     * @param string $rightText
     * @return \AisFssp\StructType\SvedNedvRightType
     */
    public function setRightText($rightText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($rightText) && strlen($rightText) > 255) || (is_array($rightText) && count($rightText) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($rightText) ? strlen($rightText) : count($rightText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($rightText) && strlen($rightText) < 1) || (is_array($rightText) && count($rightText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($rightText) && !is_string($rightText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rightText)), __LINE__);
        }
        $this->rightText = $rightText;
        return $this;
    }
    /**
     * Get shareValue value
     * @return \AisFssp\StructType\ShareType|null
     */
    public function getShareValue()
    {
        return $this->shareValue;
    }
    /**
     * Set shareValue value
     * @param \AisFssp\StructType\ShareType $shareValue
     * @return \AisFssp\StructType\SvedNedvRightType
     */
    public function setShareValue(\AisFssp\StructType\ShareType $shareValue = null)
    {
        $this->shareValue = $shareValue;
        return $this;
    }
    /**
     * Get shareText value
     * @return string|null
     */
    public function getShareText()
    {
        return $this->shareText;
    }
    /**
     * Set shareText value
     * @param string $shareText
     * @return \AisFssp\StructType\SvedNedvRightType
     */
    public function setShareText($shareText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shareText) && strlen($shareText) > 255) || (is_array($shareText) && count($shareText) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($shareText) ? strlen($shareText) : count($shareText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($shareText) && strlen($shareText) < 1) || (is_array($shareText) && count($shareText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shareText) && !is_string($shareText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareText)), __LINE__);
        }
        $this->shareText = $shareText;
        return $this;
    }
    /**
     * Get regNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \AisFssp\StructType\SvedNedvRightType
     */
    public function setRegNumber($regNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regNumber) && strlen($regNumber) > 45) || (is_array($regNumber) && count($regNumber) > 45)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 45 element(s) or a scalar of 45 character(s) at most, "%d" length given', is_scalar($regNumber) ? strlen($regNumber) : count($regNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($regNumber) && strlen($regNumber) < 1) || (is_array($regNumber) && count($regNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regNumber) && !is_string($regNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regNumber)), __LINE__);
        }
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Get regDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->regDate;
    }
    /**
     * Set regDate value
     * @param string $regDate
     * @return \AisFssp\StructType\SvedNedvRightType
     */
    public function setRegDate($regDate = null)
    {
        // validation for constraint: maxExclusive
        if ($regDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($regDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regDate) && !is_string($regDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDate)), __LINE__);
        }
        $this->regDate = $regDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SvedNedvRightType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
