<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureType StructType
 * @subpackage Structs
 */
class SignatureType extends AbstractStructBase
{
    /**
     * The SignedInfo
     * Meta informations extracted from the WSDL
     * - ref: ds:SignedInfo
     * @var \AisFssp\StructType\SignedInfoType
     */
    public $SignedInfo;
    /**
     * The SignatureValue
     * Meta informations extracted from the WSDL
     * - ref: ds:SignatureValue
     * @var \AisFssp\StructType\SignatureValueType
     */
    public $SignatureValue;
    /**
     * The KeyInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ds:KeyInfo
     * @var \AisFssp\StructType\KeyInfoType
     */
    public $KeyInfo;
    /**
     * The Object
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Object
     * @var \AisFssp\StructType\ObjectType[]
     */
    public $Object;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for SignatureType
     * @uses SignatureType::setSignedInfo()
     * @uses SignatureType::setSignatureValue()
     * @uses SignatureType::setKeyInfo()
     * @uses SignatureType::setObject()
     * @uses SignatureType::setId()
     * @param \AisFssp\StructType\SignedInfoType $signedInfo
     * @param \AisFssp\StructType\SignatureValueType $signatureValue
     * @param \AisFssp\StructType\KeyInfoType $keyInfo
     * @param \AisFssp\StructType\ObjectType[] $object
     * @param string $id
     */
    public function __construct(\AisFssp\StructType\SignedInfoType $signedInfo = null, \AisFssp\StructType\SignatureValueType $signatureValue = null, \AisFssp\StructType\KeyInfoType $keyInfo = null, array $object = array(), $id = null)
    {
        $this
            ->setSignedInfo($signedInfo)
            ->setSignatureValue($signatureValue)
            ->setKeyInfo($keyInfo)
            ->setObject($object)
            ->setId($id);
    }
    /**
     * Get SignedInfo value
     * @return \AisFssp\StructType\SignedInfoType|null
     */
    public function getSignedInfo()
    {
        return $this->SignedInfo;
    }
    /**
     * Set SignedInfo value
     * @param \AisFssp\StructType\SignedInfoType $signedInfo
     * @return \AisFssp\StructType\SignatureType
     */
    public function setSignedInfo(\AisFssp\StructType\SignedInfoType $signedInfo = null)
    {
        $this->SignedInfo = $signedInfo;
        return $this;
    }
    /**
     * Get SignatureValue value
     * @return \AisFssp\StructType\SignatureValueType|null
     */
    public function getSignatureValue()
    {
        return $this->SignatureValue;
    }
    /**
     * Set SignatureValue value
     * @param \AisFssp\StructType\SignatureValueType $signatureValue
     * @return \AisFssp\StructType\SignatureType
     */
    public function setSignatureValue(\AisFssp\StructType\SignatureValueType $signatureValue = null)
    {
        $this->SignatureValue = $signatureValue;
        return $this;
    }
    /**
     * Get KeyInfo value
     * @return \AisFssp\StructType\KeyInfoType|null
     */
    public function getKeyInfo()
    {
        return $this->KeyInfo;
    }
    /**
     * Set KeyInfo value
     * @param \AisFssp\StructType\KeyInfoType $keyInfo
     * @return \AisFssp\StructType\SignatureType
     */
    public function setKeyInfo(\AisFssp\StructType\KeyInfoType $keyInfo = null)
    {
        $this->KeyInfo = $keyInfo;
        return $this;
    }
    /**
     * Get Object value
     * @return \AisFssp\StructType\ObjectType[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * Set Object value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ObjectType[] $object
     * @return \AisFssp\StructType\SignatureType
     */
    public function setObject(array $object = array())
    {
        foreach ($object as $signatureTypeObjectItem) {
            // validation for constraint: itemType
            if (!$signatureTypeObjectItem instanceof \AisFssp\StructType\ObjectType) {
                throw new \InvalidArgumentException(sprintf('The Object property can only contain items of \AisFssp\StructType\ObjectType, "%s" given', is_object($signatureTypeObjectItem) ? get_class($signatureTypeObjectItem) : gettype($signatureTypeObjectItem)), __LINE__);
            }
        }
        $this->Object = $object;
        return $this;
    }
    /**
     * Add item to Object value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ObjectType $item
     * @return \AisFssp\StructType\SignatureType
     */
    public function addToObject(\AisFssp\StructType\ObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ObjectType) {
            throw new \InvalidArgumentException(sprintf('The Object property can only contain items of \AisFssp\StructType\ObjectType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Object[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\SignatureType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SignatureType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
