<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Судно
 * @subpackage Structs
 */
class ShipDatumType extends InformationType
{
    /**
     * The CategoryCode
     * Meta informations extracted from the WSDL
     * - documentation: Тип судна (плавсредства)
     * @var string
     */
    public $CategoryCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование судна | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Name;
    /**
     * The RegNumber
     * Meta informations extracted from the WSDL
     * - documentation: Государственный (бортовой) регистрационный знак | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $RegNumber;
    /**
     * The HIN
     * Meta informations extracted from the WSDL
     * - documentation: Серийный номер судна | CIN/HIN
     * - minOccurs: 0
     * - maxLength: 14
     * - minLength: 12
     * - pattern: ([0-9]{12})|([0-9]{14})
     * @var string
     */
    public $HIN;
    /**
     * The BrandName
     * Meta informations extracted from the WSDL
     * - documentation: Марка | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $BrandName;
    /**
     * The ModelName
     * Meta informations extracted from the WSDL
     * - documentation: Модель | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $ModelName;
    /**
     * The Color
     * Meta informations extracted from the WSDL
     * - documentation: Цвет | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $Color;
    /**
     * The MadeYear
     * Meta informations extracted from the WSDL
     * - documentation: Год выпуска | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $MadeYear;
    /**
     * The Shipyard
     * Meta informations extracted from the WSDL
     * - documentation: Место постройки | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Shipyard;
    /**
     * The HullMaterial
     * Meta informations extracted from the WSDL
     * - documentation: Материал корпуса | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $HullMaterial;
    /**
     * The MaxOccupancy
     * Meta informations extracted from the WSDL
     * - documentation: Максимальное количество людей на борту | Положительное короткое целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The Moorings
     * Meta informations extracted from the WSDL
     * - documentation: Место стоянки | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Moorings;
    /**
     * The EngineCount
     * Meta informations extracted from the WSDL
     * - documentation: Количество двигателей | Положительное короткое целое
     * - minOccurs: 0
     * - minInclusive: 1
     * @var int
     */
    public $EngineCount;
    /**
     * The EnginePowerKWh
     * Meta informations extracted from the WSDL
     * - documentation: Суммарная мощность двигателей, кВт | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerKWh;
    /**
     * The EnginePowerHp
     * Meta informations extracted from the WSDL
     * - documentation: Суммарная мощность двигателей, л. с. | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $EnginePowerHp;
    /**
     * The Engines
     * Meta informations extracted from the WSDL
     * - documentation: Двигатели
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ShipEngineType[]
     */
    public $Engines;
    /**
     * The ClassFormula
     * Meta informations extracted from the WSDL
     * - documentation: Формула класса | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $ClassFormula;
    /**
     * The Length
     * Meta informations extracted from the WSDL
     * - documentation: Длина (м) | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $Length;
    /**
     * The Width
     * Meta informations extracted from the WSDL
     * - documentation: Высота (м) | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $Width;
    /**
     * The SideHeight
     * Meta informations extracted from the WSDL
     * - documentation: Высота борта (м) | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $SideHeight;
    /**
     * The SailSquare
     * Meta informations extracted from the WSDL
     * - documentation: Площадь паруса (м2) | Количество
     * - minOccurs: 0
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $SailSquare;
    /**
     * The OwnershipDocument
     * Meta informations extracted from the WSDL
     * - documentation: Документы о приобретении | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $OwnershipDocument;
    /**
     * The OwnershipDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата приобретения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $OwnershipDate;
    /**
     * The NavigationPermitNumber
     * Meta informations extracted from the WSDL
     * - documentation: Судовой билет | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $NavigationPermitNumber;
    /**
     * The NavigationPermitDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи судового билета | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $NavigationPermitDate;
    /**
     * The MortgageCertNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер свидетельства о залоге | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $MortgageCertNumber;
    /**
     * The MortgageCertDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи свидетельства | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $MortgageCertDate;
    /**
     * The Hijacking
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об угоне
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\HijackingType[]
     */
    public $Hijacking;
    /**
     * The ShareValue
     * Meta informations extracted from the WSDL
     * - documentation: Доля (значение)
     * - minOccurs: 0
     * @var \AisFssp\StructType\ShareType
     */
    public $ShareValue;
    /**
     * The ShareText
     * Meta informations extracted from the WSDL
     * - documentation: Доля (текст) | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $ShareText;
    /**
     * The DeptCode
     * Meta informations extracted from the WSDL
     * - documentation: Код подразделения | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $DeptCode;
    /**
     * The RegisterDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $RegisterDate;
    /**
     * The UnregisterDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата отчуждения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $UnregisterDate;
    /**
     * Constructor method for ShipDatumType
     * @uses ShipDatumType::setCategoryCode()
     * @uses ShipDatumType::setName()
     * @uses ShipDatumType::setRegNumber()
     * @uses ShipDatumType::setHIN()
     * @uses ShipDatumType::setBrandName()
     * @uses ShipDatumType::setModelName()
     * @uses ShipDatumType::setColor()
     * @uses ShipDatumType::setMadeYear()
     * @uses ShipDatumType::setShipyard()
     * @uses ShipDatumType::setHullMaterial()
     * @uses ShipDatumType::setMaxOccupancy()
     * @uses ShipDatumType::setMoorings()
     * @uses ShipDatumType::setEngineCount()
     * @uses ShipDatumType::setEnginePowerKWh()
     * @uses ShipDatumType::setEnginePowerHp()
     * @uses ShipDatumType::setEngines()
     * @uses ShipDatumType::setClassFormula()
     * @uses ShipDatumType::setLength()
     * @uses ShipDatumType::setWidth()
     * @uses ShipDatumType::setSideHeight()
     * @uses ShipDatumType::setSailSquare()
     * @uses ShipDatumType::setOwnershipDocument()
     * @uses ShipDatumType::setOwnershipDate()
     * @uses ShipDatumType::setNavigationPermitNumber()
     * @uses ShipDatumType::setNavigationPermitDate()
     * @uses ShipDatumType::setMortgageCertNumber()
     * @uses ShipDatumType::setMortgageCertDate()
     * @uses ShipDatumType::setHijacking()
     * @uses ShipDatumType::setShareValue()
     * @uses ShipDatumType::setShareText()
     * @uses ShipDatumType::setDeptCode()
     * @uses ShipDatumType::setRegisterDate()
     * @uses ShipDatumType::setUnregisterDate()
     * @param string $categoryCode
     * @param string $name
     * @param string $regNumber
     * @param string $hIN
     * @param string $brandName
     * @param string $modelName
     * @param string $color
     * @param string $madeYear
     * @param string $shipyard
     * @param string $hullMaterial
     * @param int $maxOccupancy
     * @param string $moorings
     * @param int $engineCount
     * @param float $enginePowerKWh
     * @param float $enginePowerHp
     * @param \AisFssp\StructType\ShipEngineType[] $engines
     * @param string $classFormula
     * @param float $length
     * @param float $width
     * @param float $sideHeight
     * @param float $sailSquare
     * @param string $ownershipDocument
     * @param string $ownershipDate
     * @param string $navigationPermitNumber
     * @param string $navigationPermitDate
     * @param string $mortgageCertNumber
     * @param string $mortgageCertDate
     * @param \AisFssp\StructType\HijackingType[] $hijacking
     * @param \AisFssp\StructType\ShareType $shareValue
     * @param string $shareText
     * @param string $deptCode
     * @param string $registerDate
     * @param string $unregisterDate
     */
    public function __construct($categoryCode = null, $name = null, $regNumber = null, $hIN = null, $brandName = null, $modelName = null, $color = null, $madeYear = null, $shipyard = null, $hullMaterial = null, $maxOccupancy = null, $moorings = null, $engineCount = null, $enginePowerKWh = null, $enginePowerHp = null, array $engines = array(), $classFormula = null, $length = null, $width = null, $sideHeight = null, $sailSquare = null, $ownershipDocument = null, $ownershipDate = null, $navigationPermitNumber = null, $navigationPermitDate = null, $mortgageCertNumber = null, $mortgageCertDate = null, array $hijacking = array(), \AisFssp\StructType\ShareType $shareValue = null, $shareText = null, $deptCode = null, $registerDate = null, $unregisterDate = null)
    {
        $this
            ->setCategoryCode($categoryCode)
            ->setName($name)
            ->setRegNumber($regNumber)
            ->setHIN($hIN)
            ->setBrandName($brandName)
            ->setModelName($modelName)
            ->setColor($color)
            ->setMadeYear($madeYear)
            ->setShipyard($shipyard)
            ->setHullMaterial($hullMaterial)
            ->setMaxOccupancy($maxOccupancy)
            ->setMoorings($moorings)
            ->setEngineCount($engineCount)
            ->setEnginePowerKWh($enginePowerKWh)
            ->setEnginePowerHp($enginePowerHp)
            ->setEngines($engines)
            ->setClassFormula($classFormula)
            ->setLength($length)
            ->setWidth($width)
            ->setSideHeight($sideHeight)
            ->setSailSquare($sailSquare)
            ->setOwnershipDocument($ownershipDocument)
            ->setOwnershipDate($ownershipDate)
            ->setNavigationPermitNumber($navigationPermitNumber)
            ->setNavigationPermitDate($navigationPermitDate)
            ->setMortgageCertNumber($mortgageCertNumber)
            ->setMortgageCertDate($mortgageCertDate)
            ->setHijacking($hijacking)
            ->setShareValue($shareValue)
            ->setShareText($shareText)
            ->setDeptCode($deptCode)
            ->setRegisterDate($registerDate)
            ->setUnregisterDate($unregisterDate);
    }
    /**
     * Get CategoryCode value
     * @return string|null
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @uses \AisFssp\EnumType\ShipCategoryType::valueIsValid()
     * @uses \AisFssp\EnumType\ShipCategoryType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $categoryCode
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ShipCategoryType::valueIsValid($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $categoryCode, implode(', ', \AisFssp\EnumType\ShipCategoryType::getValidValues())), __LINE__);
        }
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 300) || (is_array($name) && count($name) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get RegNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->RegNumber;
    }
    /**
     * Set RegNumber value
     * @param string $regNumber
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setRegNumber($regNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regNumber) && strlen($regNumber) > 20) || (is_array($regNumber) && count($regNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($regNumber) ? strlen($regNumber) : count($regNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($regNumber) && strlen($regNumber) < 1) || (is_array($regNumber) && count($regNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regNumber) && !is_string($regNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regNumber)), __LINE__);
        }
        $this->RegNumber = $regNumber;
        return $this;
    }
    /**
     * Get HIN value
     * @return string|null
     */
    public function getHIN()
    {
        return $this->HIN;
    }
    /**
     * Set HIN value
     * @param string $hIN
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setHIN($hIN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($hIN) && strlen($hIN) > 14) || (is_array($hIN) && count($hIN) > 14)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 14 element(s) or a scalar of 14 character(s) at most, "%d" length given', is_scalar($hIN) ? strlen($hIN) : count($hIN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($hIN) && strlen($hIN) < 12) || (is_array($hIN) && count($hIN) < 12)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($hIN) && !preg_match('/([0-9]{12})|([0-9]{14})/', $hIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{12})|([0-9]{14})", "%s" given', var_export($hIN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hIN) && !is_string($hIN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hIN)), __LINE__);
        }
        $this->HIN = $hIN;
        return $this;
    }
    /**
     * Get BrandName value
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->BrandName;
    }
    /**
     * Set BrandName value
     * @param string $brandName
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($brandName) && strlen($brandName) > 50) || (is_array($brandName) && count($brandName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($brandName) ? strlen($brandName) : count($brandName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($brandName) && strlen($brandName) < 1) || (is_array($brandName) && count($brandName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($brandName)), __LINE__);
        }
        $this->BrandName = $brandName;
        return $this;
    }
    /**
     * Get ModelName value
     * @return string|null
     */
    public function getModelName()
    {
        return $this->ModelName;
    }
    /**
     * Set ModelName value
     * @param string $modelName
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setModelName($modelName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($modelName) && strlen($modelName) > 50) || (is_array($modelName) && count($modelName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($modelName) ? strlen($modelName) : count($modelName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($modelName) && strlen($modelName) < 1) || (is_array($modelName) && count($modelName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($modelName) && !is_string($modelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelName)), __LINE__);
        }
        $this->ModelName = $modelName;
        return $this;
    }
    /**
     * Get Color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->Color;
    }
    /**
     * Set Color value
     * @param string $color
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setColor($color = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($color) && strlen($color) > 20) || (is_array($color) && count($color) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($color) ? strlen($color) : count($color)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($color) && strlen($color) < 1) || (is_array($color) && count($color) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($color)), __LINE__);
        }
        $this->Color = $color;
        return $this;
    }
    /**
     * Get MadeYear value
     * @return string|null
     */
    public function getMadeYear()
    {
        return $this->MadeYear;
    }
    /**
     * Set MadeYear value
     * @param string $madeYear
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setMadeYear($madeYear = null)
    {
        // validation for constraint: maxInclusive
        if ($madeYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $madeYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($madeYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $madeYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($madeYear) && !is_string($madeYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($madeYear)), __LINE__);
        }
        $this->MadeYear = $madeYear;
        return $this;
    }
    /**
     * Get Shipyard value
     * @return string|null
     */
    public function getShipyard()
    {
        return $this->Shipyard;
    }
    /**
     * Set Shipyard value
     * @param string $shipyard
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setShipyard($shipyard = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shipyard) && strlen($shipyard) > 50) || (is_array($shipyard) && count($shipyard) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($shipyard) ? strlen($shipyard) : count($shipyard)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($shipyard) && strlen($shipyard) < 1) || (is_array($shipyard) && count($shipyard) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shipyard) && !is_string($shipyard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shipyard)), __LINE__);
        }
        $this->Shipyard = $shipyard;
        return $this;
    }
    /**
     * Get HullMaterial value
     * @return string|null
     */
    public function getHullMaterial()
    {
        return $this->HullMaterial;
    }
    /**
     * Set HullMaterial value
     * @param string $hullMaterial
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setHullMaterial($hullMaterial = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($hullMaterial) && strlen($hullMaterial) > 20) || (is_array($hullMaterial) && count($hullMaterial) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($hullMaterial) ? strlen($hullMaterial) : count($hullMaterial)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($hullMaterial) && strlen($hullMaterial) < 1) || (is_array($hullMaterial) && count($hullMaterial) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hullMaterial) && !is_string($hullMaterial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hullMaterial)), __LINE__);
        }
        $this->HullMaterial = $hullMaterial;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: minInclusive
        if ($maxOccupancy < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $maxOccupancy), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !is_numeric($maxOccupancy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get Moorings value
     * @return string|null
     */
    public function getMoorings()
    {
        return $this->Moorings;
    }
    /**
     * Set Moorings value
     * @param string $moorings
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setMoorings($moorings = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($moorings) && strlen($moorings) > 300) || (is_array($moorings) && count($moorings) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($moorings) ? strlen($moorings) : count($moorings)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($moorings) && strlen($moorings) < 1) || (is_array($moorings) && count($moorings) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($moorings) && !is_string($moorings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moorings)), __LINE__);
        }
        $this->Moorings = $moorings;
        return $this;
    }
    /**
     * Get EngineCount value
     * @return int|null
     */
    public function getEngineCount()
    {
        return $this->EngineCount;
    }
    /**
     * Set EngineCount value
     * @param int $engineCount
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setEngineCount($engineCount = null)
    {
        // validation for constraint: minInclusive
        if ($engineCount < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $engineCount), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($engineCount) && !is_numeric($engineCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($engineCount)), __LINE__);
        }
        $this->EngineCount = $engineCount;
        return $this;
    }
    /**
     * Get EnginePowerKWh value
     * @return float|null
     */
    public function getEnginePowerKWh()
    {
        return $this->EnginePowerKWh;
    }
    /**
     * Set EnginePowerKWh value
     * @param float $enginePowerKWh
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setEnginePowerKWh($enginePowerKWh = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($enginePowerKWh) && strlen(substr($enginePowerKWh, strpos($enginePowerKWh, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($enginePowerKWh, strpos($enginePowerKWh, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($enginePowerKWh) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $enginePowerKWh)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($enginePowerKWh, strpos($enginePowerKWh, '.')))), __LINE__);
        }
        $this->EnginePowerKWh = $enginePowerKWh;
        return $this;
    }
    /**
     * Get EnginePowerHp value
     * @return float|null
     */
    public function getEnginePowerHp()
    {
        return $this->EnginePowerHp;
    }
    /**
     * Set EnginePowerHp value
     * @param float $enginePowerHp
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setEnginePowerHp($enginePowerHp = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($enginePowerHp) && strlen(substr($enginePowerHp, strpos($enginePowerHp, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($enginePowerHp, strpos($enginePowerHp, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($enginePowerHp) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $enginePowerHp)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($enginePowerHp, strpos($enginePowerHp, '.')))), __LINE__);
        }
        $this->EnginePowerHp = $enginePowerHp;
        return $this;
    }
    /**
     * Get Engines value
     * @return \AisFssp\StructType\ShipEngineType[]|null
     */
    public function getEngines()
    {
        return $this->Engines;
    }
    /**
     * Set Engines value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ShipEngineType[] $engines
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setEngines(array $engines = array())
    {
        foreach ($engines as $shipDatumTypeEnginesItem) {
            // validation for constraint: itemType
            if (!$shipDatumTypeEnginesItem instanceof \AisFssp\StructType\ShipEngineType) {
                throw new \InvalidArgumentException(sprintf('The Engines property can only contain items of \AisFssp\StructType\ShipEngineType, "%s" given', is_object($shipDatumTypeEnginesItem) ? get_class($shipDatumTypeEnginesItem) : gettype($shipDatumTypeEnginesItem)), __LINE__);
            }
        }
        $this->Engines = $engines;
        return $this;
    }
    /**
     * Add item to Engines value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ShipEngineType $item
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function addToEngines(\AisFssp\StructType\ShipEngineType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ShipEngineType) {
            throw new \InvalidArgumentException(sprintf('The Engines property can only contain items of \AisFssp\StructType\ShipEngineType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Engines[] = $item;
        return $this;
    }
    /**
     * Get ClassFormula value
     * @return string|null
     */
    public function getClassFormula()
    {
        return $this->ClassFormula;
    }
    /**
     * Set ClassFormula value
     * @param string $classFormula
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setClassFormula($classFormula = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($classFormula) && strlen($classFormula) > 20) || (is_array($classFormula) && count($classFormula) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($classFormula) ? strlen($classFormula) : count($classFormula)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($classFormula) && strlen($classFormula) < 1) || (is_array($classFormula) && count($classFormula) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($classFormula) && !is_string($classFormula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($classFormula)), __LINE__);
        }
        $this->ClassFormula = $classFormula;
        return $this;
    }
    /**
     * Get Length value
     * @return float|null
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param float $length
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setLength($length = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($length) && strlen(substr($length, strpos($length, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($length, strpos($length, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($length) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $length)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($length, strpos($length, '.')))), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get Width value
     * @return float|null
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setWidth($width = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($width) && strlen(substr($width, strpos($width, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($width, strpos($width, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($width) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $width)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($width, strpos($width, '.')))), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get SideHeight value
     * @return float|null
     */
    public function getSideHeight()
    {
        return $this->SideHeight;
    }
    /**
     * Set SideHeight value
     * @param float $sideHeight
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setSideHeight($sideHeight = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($sideHeight) && strlen(substr($sideHeight, strpos($sideHeight, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($sideHeight, strpos($sideHeight, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($sideHeight) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $sideHeight)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($sideHeight, strpos($sideHeight, '.')))), __LINE__);
        }
        $this->SideHeight = $sideHeight;
        return $this;
    }
    /**
     * Get SailSquare value
     * @return float|null
     */
    public function getSailSquare()
    {
        return $this->SailSquare;
    }
    /**
     * Set SailSquare value
     * @param float $sailSquare
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setSailSquare($sailSquare = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($sailSquare) && strlen(substr($sailSquare, strpos($sailSquare, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($sailSquare, strpos($sailSquare, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($sailSquare) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $sailSquare)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($sailSquare, strpos($sailSquare, '.')))), __LINE__);
        }
        $this->SailSquare = $sailSquare;
        return $this;
    }
    /**
     * Get OwnershipDocument value
     * @return string|null
     */
    public function getOwnershipDocument()
    {
        return $this->OwnershipDocument;
    }
    /**
     * Set OwnershipDocument value
     * @param string $ownershipDocument
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setOwnershipDocument($ownershipDocument = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ownershipDocument) && strlen($ownershipDocument) > 300) || (is_array($ownershipDocument) && count($ownershipDocument) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($ownershipDocument) ? strlen($ownershipDocument) : count($ownershipDocument)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ownershipDocument) && strlen($ownershipDocument) < 1) || (is_array($ownershipDocument) && count($ownershipDocument) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ownershipDocument) && !is_string($ownershipDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ownershipDocument)), __LINE__);
        }
        $this->OwnershipDocument = $ownershipDocument;
        return $this;
    }
    /**
     * Get OwnershipDate value
     * @return string|null
     */
    public function getOwnershipDate()
    {
        return $this->OwnershipDate;
    }
    /**
     * Set OwnershipDate value
     * @param string $ownershipDate
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setOwnershipDate($ownershipDate = null)
    {
        // validation for constraint: maxExclusive
        if ($ownershipDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $ownershipDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ownershipDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $ownershipDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ownershipDate) && !is_string($ownershipDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ownershipDate)), __LINE__);
        }
        $this->OwnershipDate = $ownershipDate;
        return $this;
    }
    /**
     * Get NavigationPermitNumber value
     * @return string|null
     */
    public function getNavigationPermitNumber()
    {
        return $this->NavigationPermitNumber;
    }
    /**
     * Set NavigationPermitNumber value
     * @param string $navigationPermitNumber
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setNavigationPermitNumber($navigationPermitNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($navigationPermitNumber) && strlen($navigationPermitNumber) > 20) || (is_array($navigationPermitNumber) && count($navigationPermitNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($navigationPermitNumber) ? strlen($navigationPermitNumber) : count($navigationPermitNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($navigationPermitNumber) && strlen($navigationPermitNumber) < 1) || (is_array($navigationPermitNumber) && count($navigationPermitNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($navigationPermitNumber) && !is_string($navigationPermitNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navigationPermitNumber)), __LINE__);
        }
        $this->NavigationPermitNumber = $navigationPermitNumber;
        return $this;
    }
    /**
     * Get NavigationPermitDate value
     * @return string|null
     */
    public function getNavigationPermitDate()
    {
        return $this->NavigationPermitDate;
    }
    /**
     * Set NavigationPermitDate value
     * @param string $navigationPermitDate
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setNavigationPermitDate($navigationPermitDate = null)
    {
        // validation for constraint: maxExclusive
        if ($navigationPermitDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $navigationPermitDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($navigationPermitDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $navigationPermitDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($navigationPermitDate) && !is_string($navigationPermitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($navigationPermitDate)), __LINE__);
        }
        $this->NavigationPermitDate = $navigationPermitDate;
        return $this;
    }
    /**
     * Get MortgageCertNumber value
     * @return string|null
     */
    public function getMortgageCertNumber()
    {
        return $this->MortgageCertNumber;
    }
    /**
     * Set MortgageCertNumber value
     * @param string $mortgageCertNumber
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setMortgageCertNumber($mortgageCertNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($mortgageCertNumber) && strlen($mortgageCertNumber) > 20) || (is_array($mortgageCertNumber) && count($mortgageCertNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($mortgageCertNumber) ? strlen($mortgageCertNumber) : count($mortgageCertNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($mortgageCertNumber) && strlen($mortgageCertNumber) < 1) || (is_array($mortgageCertNumber) && count($mortgageCertNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mortgageCertNumber) && !is_string($mortgageCertNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mortgageCertNumber)), __LINE__);
        }
        $this->MortgageCertNumber = $mortgageCertNumber;
        return $this;
    }
    /**
     * Get MortgageCertDate value
     * @return string|null
     */
    public function getMortgageCertDate()
    {
        return $this->MortgageCertDate;
    }
    /**
     * Set MortgageCertDate value
     * @param string $mortgageCertDate
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setMortgageCertDate($mortgageCertDate = null)
    {
        // validation for constraint: maxExclusive
        if ($mortgageCertDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $mortgageCertDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($mortgageCertDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $mortgageCertDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($mortgageCertDate) && !is_string($mortgageCertDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mortgageCertDate)), __LINE__);
        }
        $this->MortgageCertDate = $mortgageCertDate;
        return $this;
    }
    /**
     * Get Hijacking value
     * @return \AisFssp\StructType\HijackingType[]|null
     */
    public function getHijacking()
    {
        return $this->Hijacking;
    }
    /**
     * Set Hijacking value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\HijackingType[] $hijacking
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setHijacking(array $hijacking = array())
    {
        foreach ($hijacking as $shipDatumTypeHijackingItem) {
            // validation for constraint: itemType
            if (!$shipDatumTypeHijackingItem instanceof \AisFssp\StructType\HijackingType) {
                throw new \InvalidArgumentException(sprintf('The Hijacking property can only contain items of \AisFssp\StructType\HijackingType, "%s" given', is_object($shipDatumTypeHijackingItem) ? get_class($shipDatumTypeHijackingItem) : gettype($shipDatumTypeHijackingItem)), __LINE__);
            }
        }
        $this->Hijacking = $hijacking;
        return $this;
    }
    /**
     * Add item to Hijacking value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\HijackingType $item
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function addToHijacking(\AisFssp\StructType\HijackingType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\HijackingType) {
            throw new \InvalidArgumentException(sprintf('The Hijacking property can only contain items of \AisFssp\StructType\HijackingType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Hijacking[] = $item;
        return $this;
    }
    /**
     * Get ShareValue value
     * @return \AisFssp\StructType\ShareType|null
     */
    public function getShareValue()
    {
        return $this->ShareValue;
    }
    /**
     * Set ShareValue value
     * @param \AisFssp\StructType\ShareType $shareValue
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setShareValue(\AisFssp\StructType\ShareType $shareValue = null)
    {
        $this->ShareValue = $shareValue;
        return $this;
    }
    /**
     * Get ShareText value
     * @return string|null
     */
    public function getShareText()
    {
        return $this->ShareText;
    }
    /**
     * Set ShareText value
     * @param string $shareText
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setShareText($shareText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shareText) && strlen($shareText) > 255) || (is_array($shareText) && count($shareText) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($shareText) ? strlen($shareText) : count($shareText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($shareText) && strlen($shareText) < 1) || (is_array($shareText) && count($shareText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shareText) && !is_string($shareText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shareText)), __LINE__);
        }
        $this->ShareText = $shareText;
        return $this;
    }
    /**
     * Get DeptCode value
     * @return string|null
     */
    public function getDeptCode()
    {
        return $this->DeptCode;
    }
    /**
     * Set DeptCode value
     * @param string $deptCode
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setDeptCode($deptCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($deptCode) && strlen($deptCode) > 10) || (is_array($deptCode) && count($deptCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($deptCode) ? strlen($deptCode) : count($deptCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($deptCode) && strlen($deptCode) < 1) || (is_array($deptCode) && count($deptCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deptCode) && !is_string($deptCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deptCode)), __LINE__);
        }
        $this->DeptCode = $deptCode;
        return $this;
    }
    /**
     * Get RegisterDate value
     * @return string|null
     */
    public function getRegisterDate()
    {
        return $this->RegisterDate;
    }
    /**
     * Set RegisterDate value
     * @param string $registerDate
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setRegisterDate($registerDate = null)
    {
        // validation for constraint: maxExclusive
        if ($registerDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $registerDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($registerDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $registerDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registerDate) && !is_string($registerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registerDate)), __LINE__);
        }
        $this->RegisterDate = $registerDate;
        return $this;
    }
    /**
     * Get UnregisterDate value
     * @return string|null
     */
    public function getUnregisterDate()
    {
        return $this->UnregisterDate;
    }
    /**
     * Set UnregisterDate value
     * @param string $unregisterDate
     * @return \AisFssp\StructType\ShipDatumType
     */
    public function setUnregisterDate($unregisterDate = null)
    {
        // validation for constraint: maxExclusive
        if ($unregisterDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $unregisterDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($unregisterDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $unregisterDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unregisterDate) && !is_string($unregisterDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unregisterDate)), __LINE__);
        }
        $this->UnregisterDate = $unregisterDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ShipDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
