<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SequestrationType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер Sequestration «Сведения об аресте имущества и имеющихся ограничениях» | Используется для передачи сведений об аресте
 * имущества и имеющихся ограничениях (постановлении о наложении ареста на имущество должника). Для ФНС России при вынесении
 * постановления по статье 77 НК РФ: Обязателен.
 * @subpackage Structs
 */
class SequestrationType extends AbstractStructBase
{
    /**
     * The ReportProperty
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об имуществе
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \AisFssp\StructType\ReportPropertyType[]
     */
    public $ReportProperty;
    /**
     * The OrderNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер постановления | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $OrderNumber;
    /**
     * The OrderDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $OrderDate;
    /**
     * The OrderSanctionDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата вступления постановления в силу после получении санкции прокурора | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $OrderSanctionDate;
    /**
     * Constructor method for SequestrationType
     * @uses SequestrationType::setReportProperty()
     * @uses SequestrationType::setOrderNumber()
     * @uses SequestrationType::setOrderDate()
     * @uses SequestrationType::setOrderSanctionDate()
     * @param \AisFssp\StructType\ReportPropertyType[] $reportProperty
     * @param string $orderNumber
     * @param string $orderDate
     * @param string $orderSanctionDate
     */
    public function __construct(array $reportProperty = array(), $orderNumber = null, $orderDate = null, $orderSanctionDate = null)
    {
        $this
            ->setReportProperty($reportProperty)
            ->setOrderNumber($orderNumber)
            ->setOrderDate($orderDate)
            ->setOrderSanctionDate($orderSanctionDate);
    }
    /**
     * Get ReportProperty value
     * @return \AisFssp\StructType\ReportPropertyType[]
     */
    public function getReportProperty()
    {
        return $this->ReportProperty;
    }
    /**
     * Set ReportProperty value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ReportPropertyType[] $reportProperty
     * @return \AisFssp\StructType\SequestrationType
     */
    public function setReportProperty(array $reportProperty = array())
    {
        foreach ($reportProperty as $sequestrationTypeReportPropertyItem) {
            // validation for constraint: itemType
            if (!$sequestrationTypeReportPropertyItem instanceof \AisFssp\StructType\ReportPropertyType) {
                throw new \InvalidArgumentException(sprintf('The ReportProperty property can only contain items of \AisFssp\StructType\ReportPropertyType, "%s" given', is_object($sequestrationTypeReportPropertyItem) ? get_class($sequestrationTypeReportPropertyItem) : gettype($sequestrationTypeReportPropertyItem)), __LINE__);
            }
        }
        $this->ReportProperty = $reportProperty;
        return $this;
    }
    /**
     * Add item to ReportProperty value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ReportPropertyType $item
     * @return \AisFssp\StructType\SequestrationType
     */
    public function addToReportProperty(\AisFssp\StructType\ReportPropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ReportPropertyType) {
            throw new \InvalidArgumentException(sprintf('The ReportProperty property can only contain items of \AisFssp\StructType\ReportPropertyType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ReportProperty[] = $item;
        return $this;
    }
    /**
     * Get OrderNumber value
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->OrderNumber;
    }
    /**
     * Set OrderNumber value
     * @param string $orderNumber
     * @return \AisFssp\StructType\SequestrationType
     */
    public function setOrderNumber($orderNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($orderNumber) && strlen($orderNumber) > 25) || (is_array($orderNumber) && count($orderNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($orderNumber) ? strlen($orderNumber) : count($orderNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($orderNumber) && strlen($orderNumber) < 1) || (is_array($orderNumber) && count($orderNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($orderNumber) && !is_string($orderNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderNumber)), __LINE__);
        }
        $this->OrderNumber = $orderNumber;
        return $this;
    }
    /**
     * Get OrderDate value
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->OrderDate;
    }
    /**
     * Set OrderDate value
     * @param string $orderDate
     * @return \AisFssp\StructType\SequestrationType
     */
    public function setOrderDate($orderDate = null)
    {
        // validation for constraint: maxExclusive
        if ($orderDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $orderDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($orderDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $orderDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($orderDate) && !is_string($orderDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderDate)), __LINE__);
        }
        $this->OrderDate = $orderDate;
        return $this;
    }
    /**
     * Get OrderSanctionDate value
     * @return string|null
     */
    public function getOrderSanctionDate()
    {
        return $this->OrderSanctionDate;
    }
    /**
     * Set OrderSanctionDate value
     * @param string $orderSanctionDate
     * @return \AisFssp\StructType\SequestrationType
     */
    public function setOrderSanctionDate($orderSanctionDate = null)
    {
        // validation for constraint: maxExclusive
        if ($orderSanctionDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $orderSanctionDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($orderSanctionDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $orderSanctionDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($orderSanctionDate) && !is_string($orderSanctionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderSanctionDate)), __LINE__);
        }
        $this->OrderSanctionDate = $orderSanctionDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SequestrationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
