<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SentencedPersonNoImprisonmentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об отбывании осужденным должником наказания, не связанного с лишением свободы
 * @subpackage Structs
 */
class SentencedPersonNoImprisonmentType extends InformationType
{
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановки на учет | Дата | Дата
     * - minOccurs: 1
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $StartDate;
    /**
     * The FinDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата снятия с учета | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $FinDate;
    /**
     * The GroundDeregistration
     * Meta informations extracted from the WSDL
     * - documentation: Основание снятия с учета | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $GroundDeregistration;
    /**
     * Constructor method for SentencedPersonNoImprisonmentType
     * @uses SentencedPersonNoImprisonmentType::setStartDate()
     * @uses SentencedPersonNoImprisonmentType::setFinDate()
     * @uses SentencedPersonNoImprisonmentType::setGroundDeregistration()
     * @param string $startDate
     * @param string $finDate
     * @param string $groundDeregistration
     */
    public function __construct($startDate = null, $finDate = null, $groundDeregistration = null)
    {
        $this
            ->setStartDate($startDate)
            ->setFinDate($finDate)
            ->setGroundDeregistration($groundDeregistration);
    }
    /**
     * Get StartDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \AisFssp\StructType\SentencedPersonNoImprisonmentType
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: maxExclusive
        if ($startDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($startDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $startDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get FinDate value
     * @return string|null
     */
    public function getFinDate()
    {
        return $this->FinDate;
    }
    /**
     * Set FinDate value
     * @param string $finDate
     * @return \AisFssp\StructType\SentencedPersonNoImprisonmentType
     */
    public function setFinDate($finDate = null)
    {
        // validation for constraint: maxExclusive
        if ($finDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $finDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($finDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $finDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($finDate) && !is_string($finDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finDate)), __LINE__);
        }
        $this->FinDate = $finDate;
        return $this;
    }
    /**
     * Get GroundDeregistration value
     * @return string|null
     */
    public function getGroundDeregistration()
    {
        return $this->GroundDeregistration;
    }
    /**
     * Set GroundDeregistration value
     * @param string $groundDeregistration
     * @return \AisFssp\StructType\SentencedPersonNoImprisonmentType
     */
    public function setGroundDeregistration($groundDeregistration = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($groundDeregistration) && strlen($groundDeregistration) > 300) || (is_array($groundDeregistration) && count($groundDeregistration) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($groundDeregistration) ? strlen($groundDeregistration) : count($groundDeregistration)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($groundDeregistration) && strlen($groundDeregistration) < 1) || (is_array($groundDeregistration) && count($groundDeregistration) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($groundDeregistration) && !is_string($groundDeregistration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groundDeregistration)), __LINE__);
        }
        $this->GroundDeregistration = $groundDeregistration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SentencedPersonNoImprisonmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
