<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SenderContragentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Реквизиты отправителя документа—внешнего контрагента | используется для передачи сведений об организации и лице,
 * направившем юридически значимый документ в адрес ФССП России
 * @subpackage Structs
 */
class SenderContragentType extends AbstractStructBase
{
    /**
     * The AuthorName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица | ФИО должностного лица, от имени которого направлен судебный акт, определение | Полное имя физического
     * лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $AuthorName;
    /**
     * The AuthorPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность | Наименование должности | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $AuthorPost;
    /**
     * The AuthorEmail
     * Meta informations extracted from the WSDL
     * - documentation: Электропочта | Адрес электронной почты
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $AuthorEmail;
    /**
     * The AuthorTelephone
     * Meta informations extracted from the WSDL
     * - documentation: Контактный телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $AuthorTelephone;
    /**
     * Constructor method for SenderContragentType
     * @uses SenderContragentType::setAuthorName()
     * @uses SenderContragentType::setAuthorPost()
     * @uses SenderContragentType::setAuthorEmail()
     * @uses SenderContragentType::setAuthorTelephone()
     * @param string $authorName
     * @param string $authorPost
     * @param string $authorEmail
     * @param string $authorTelephone
     */
    public function __construct($authorName = null, $authorPost = null, $authorEmail = null, $authorTelephone = null)
    {
        $this
            ->setAuthorName($authorName)
            ->setAuthorPost($authorPost)
            ->setAuthorEmail($authorEmail)
            ->setAuthorTelephone($authorTelephone);
    }
    /**
     * Get AuthorName value
     * @return string|null
     */
    public function getAuthorName()
    {
        return $this->AuthorName;
    }
    /**
     * Set AuthorName value
     * @param string $authorName
     * @return \AisFssp\StructType\SenderContragentType
     */
    public function setAuthorName($authorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorName) && strlen($authorName) > 100) || (is_array($authorName) && count($authorName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authorName) ? strlen($authorName) : count($authorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorName) && strlen($authorName) < 1) || (is_array($authorName) && count($authorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorName) && !is_string($authorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorName)), __LINE__);
        }
        $this->AuthorName = $authorName;
        return $this;
    }
    /**
     * Get AuthorPost value
     * @return string|null
     */
    public function getAuthorPost()
    {
        return $this->AuthorPost;
    }
    /**
     * Set AuthorPost value
     * @param string $authorPost
     * @return \AisFssp\StructType\SenderContragentType
     */
    public function setAuthorPost($authorPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorPost) && strlen($authorPost) > 50) || (is_array($authorPost) && count($authorPost) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($authorPost) ? strlen($authorPost) : count($authorPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorPost) && strlen($authorPost) < 1) || (is_array($authorPost) && count($authorPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorPost) && !is_string($authorPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorPost)), __LINE__);
        }
        $this->AuthorPost = $authorPost;
        return $this;
    }
    /**
     * Get AuthorEmail value
     * @return string|null
     */
    public function getAuthorEmail()
    {
        return $this->AuthorEmail;
    }
    /**
     * Set AuthorEmail value
     * @param string $authorEmail
     * @return \AisFssp\StructType\SenderContragentType
     */
    public function setAuthorEmail($authorEmail = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorEmail) && strlen($authorEmail) > 100) || (is_array($authorEmail) && count($authorEmail) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authorEmail) ? strlen($authorEmail) : count($authorEmail)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorEmail) && strlen($authorEmail) < 1) || (is_array($authorEmail) && count($authorEmail) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorEmail) && !is_string($authorEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorEmail)), __LINE__);
        }
        $this->AuthorEmail = $authorEmail;
        return $this;
    }
    /**
     * Get AuthorTelephone value
     * @return string|null
     */
    public function getAuthorTelephone()
    {
        return $this->AuthorTelephone;
    }
    /**
     * Set AuthorTelephone value
     * @param string $authorTelephone
     * @return \AisFssp\StructType\SenderContragentType
     */
    public function setAuthorTelephone($authorTelephone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authorTelephone) && strlen($authorTelephone) > 25) || (is_array($authorTelephone) && count($authorTelephone) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($authorTelephone) ? strlen($authorTelephone) : count($authorTelephone)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($authorTelephone) && strlen($authorTelephone) < 1) || (is_array($authorTelephone) && count($authorTelephone) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authorTelephone) && !is_string($authorTelephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorTelephone)), __LINE__);
        }
        $this->AuthorTelephone = $authorTelephone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\SenderContragentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
