<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RestrictionActInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об арестах и ограничениях, наложенных судебными приставами-исполнителями на имущество должников | ЭП
 * - type: tns:RestrictionActInfo
 * @subpackage Structs
 */
class RestrictionActInfo extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Уникальный идентификатор документа, присвоенный АИС ФССП России. | Ключ объекта, присвоенний информационной
     * системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор документа запроса АИС внешнего контрагента. | Идентификатор объекта, присвоенный
     * объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа
     * в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestKey;
    /**
     * The HasActInfo
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия постановлений | Признак наличия постановления об ограничении выезда. | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $HasActInfo;
    /**
     * The ActInfo
     * Meta informations extracted from the WSDL
     * - documentation: Постановление об аресте и ограничении | Сведения об арестах и ограничениях, наложенных судебными приставами-исполнителями на
     * имущество должников.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\ActInfoType[]
     */
    public $ActInfo;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for RestrictionActInfo
     * @uses RestrictionActInfo::setInternalKey()
     * @uses RestrictionActInfo::setRequestKey()
     * @uses RestrictionActInfo::setHasActInfo()
     * @uses RestrictionActInfo::setActInfo()
     * @uses RestrictionActInfo::setSignDateTime()
     * @uses RestrictionActInfo::setSignature()
     * @uses RestrictionActInfo::setId()
     * @param int $internalKey
     * @param string $requestKey
     * @param bool $hasActInfo
     * @param \AisFssp\StructType\ActInfoType[] $actInfo
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $requestKey = null, $hasActInfo = null, array $actInfo = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestKey($requestKey)
            ->setHasActInfo($hasActInfo)
            ->setActInfo($actInfo)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\RestrictionActInfo
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->RequestKey;
    }
    /**
     * Set RequestKey value
     * @param string $requestKey
     * @return \AisFssp\StructType\RestrictionActInfo
     */
    public function setRequestKey($requestKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestKey) && strlen($requestKey) > 60) || (is_array($requestKey) && count($requestKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestKey) ? strlen($requestKey) : count($requestKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestKey) && strlen($requestKey) < 1) || (is_array($requestKey) && count($requestKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestKey) && !is_string($requestKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestKey)), __LINE__);
        }
        $this->RequestKey = $requestKey;
        return $this;
    }
    /**
     * Get HasActInfo value
     * @return bool|null
     */
    public function getHasActInfo()
    {
        return $this->HasActInfo;
    }
    /**
     * Set HasActInfo value
     * @param bool $hasActInfo
     * @return \AisFssp\StructType\RestrictionActInfo
     */
    public function setHasActInfo($hasActInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasActInfo) && !is_bool($hasActInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasActInfo)), __LINE__);
        }
        $this->HasActInfo = $hasActInfo;
        return $this;
    }
    /**
     * Get ActInfo value
     * @return \AisFssp\StructType\ActInfoType[]|null
     */
    public function getActInfo()
    {
        return $this->ActInfo;
    }
    /**
     * Set ActInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ActInfoType[] $actInfo
     * @return \AisFssp\StructType\RestrictionActInfo
     */
    public function setActInfo(array $actInfo = array())
    {
        foreach ($actInfo as $restrictionActInfoActInfoItem) {
            // validation for constraint: itemType
            if (!$restrictionActInfoActInfoItem instanceof \AisFssp\StructType\ActInfoType) {
                throw new \InvalidArgumentException(sprintf('The ActInfo property can only contain items of \AisFssp\StructType\ActInfoType, "%s" given', is_object($restrictionActInfoActInfoItem) ? get_class($restrictionActInfoActInfoItem) : gettype($restrictionActInfoActInfoItem)), __LINE__);
            }
        }
        $this->ActInfo = $actInfo;
        return $this;
    }
    /**
     * Add item to ActInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\ActInfoType $item
     * @return \AisFssp\StructType\RestrictionActInfo
     */
    public function addToActInfo(\AisFssp\StructType\ActInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\ActInfoType) {
            throw new \InvalidArgumentException(sprintf('The ActInfo property can only contain items of \AisFssp\StructType\ActInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ActInfo[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\RestrictionActInfo
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\RestrictionActInfo
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $restrictionActInfoSignatureItem) {
            // validation for constraint: itemType
            if (!$restrictionActInfoSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($restrictionActInfoSignatureItem) ? get_class($restrictionActInfoSignatureItem) : gettype($restrictionActInfoSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\RestrictionActInfo
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\RestrictionActInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\RestrictionActInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
