<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecoveredAmountAnswer StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на запрос о полученных физическим лицом суммах, взысканных по ИП
 * - type: tns:RecoveredAmountAnswer
 * @subpackage Structs
 */
class RecoveredAmountAnswer extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The RequestExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие).
     * Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $RequestExternalKey;
    /**
     * The Plaintiff
     * Meta informations extracted from the WSDL
     * - documentation: Взыскатель
     * @var \AisFssp\StructType\ContragentDatumType
     */
    public $Plaintiff;
    /**
     * The BeginDate
     * Meta informations extracted from the WSDL
     * - documentation: Начало периода | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $BeginDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - documentation: Окончание периода | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $EndDate;
    /**
     * The RecoveringIpInfo
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о взысканных суммах
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\RecoveringIpInfoType[]
     */
    public $RecoveringIpInfo;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for RecoveredAmountAnswer
     * @uses RecoveredAmountAnswer::setInternalKey()
     * @uses RecoveredAmountAnswer::setRequestExternalKey()
     * @uses RecoveredAmountAnswer::setPlaintiff()
     * @uses RecoveredAmountAnswer::setBeginDate()
     * @uses RecoveredAmountAnswer::setEndDate()
     * @uses RecoveredAmountAnswer::setRecoveringIpInfo()
     * @uses RecoveredAmountAnswer::setSignature()
     * @uses RecoveredAmountAnswer::setId()
     * @param int $internalKey
     * @param string $requestExternalKey
     * @param \AisFssp\StructType\ContragentDatumType $plaintiff
     * @param string $beginDate
     * @param string $endDate
     * @param \AisFssp\StructType\RecoveringIpInfoType[] $recoveringIpInfo
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $requestExternalKey = null, \AisFssp\StructType\ContragentDatumType $plaintiff = null, $beginDate = null, $endDate = null, array $recoveringIpInfo = array(), array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestExternalKey($requestExternalKey)
            ->setPlaintiff($plaintiff)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setRecoveringIpInfo($recoveringIpInfo)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\RecoveredAmountAnswer
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get RequestExternalKey value
     * @return string|null
     */
    public function getRequestExternalKey()
    {
        return $this->RequestExternalKey;
    }
    /**
     * Set RequestExternalKey value
     * @param string $requestExternalKey
     * @return \AisFssp\StructType\RecoveredAmountAnswer
     */
    public function setRequestExternalKey($requestExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) > 60) || (is_array($requestExternalKey) && count($requestExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestExternalKey) ? strlen($requestExternalKey) : count($requestExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestExternalKey) && strlen($requestExternalKey) < 1) || (is_array($requestExternalKey) && count($requestExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestExternalKey) && !is_string($requestExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestExternalKey)), __LINE__);
        }
        $this->RequestExternalKey = $requestExternalKey;
        return $this;
    }
    /**
     * Get Plaintiff value
     * @return \AisFssp\StructType\ContragentDatumType|null
     */
    public function getPlaintiff()
    {
        return $this->Plaintiff;
    }
    /**
     * Set Plaintiff value
     * @param \AisFssp\StructType\ContragentDatumType $plaintiff
     * @return \AisFssp\StructType\RecoveredAmountAnswer
     */
    public function setPlaintiff(\AisFssp\StructType\ContragentDatumType $plaintiff = null)
    {
        $this->Plaintiff = $plaintiff;
        return $this;
    }
    /**
     * Get BeginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->BeginDate;
    }
    /**
     * Set BeginDate value
     * @param string $beginDate
     * @return \AisFssp\StructType\RecoveredAmountAnswer
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: maxExclusive
        if ($beginDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $beginDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($beginDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $beginDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->BeginDate = $beginDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \AisFssp\StructType\RecoveredAmountAnswer
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: maxExclusive
        if ($endDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($endDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get RecoveringIpInfo value
     * @return \AisFssp\StructType\RecoveringIpInfoType[]|null
     */
    public function getRecoveringIpInfo()
    {
        return $this->RecoveringIpInfo;
    }
    /**
     * Set RecoveringIpInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RecoveringIpInfoType[] $recoveringIpInfo
     * @return \AisFssp\StructType\RecoveredAmountAnswer
     */
    public function setRecoveringIpInfo(array $recoveringIpInfo = array())
    {
        foreach ($recoveringIpInfo as $recoveredAmountAnswerRecoveringIpInfoItem) {
            // validation for constraint: itemType
            if (!$recoveredAmountAnswerRecoveringIpInfoItem instanceof \AisFssp\StructType\RecoveringIpInfoType) {
                throw new \InvalidArgumentException(sprintf('The RecoveringIpInfo property can only contain items of \AisFssp\StructType\RecoveringIpInfoType, "%s" given', is_object($recoveredAmountAnswerRecoveringIpInfoItem) ? get_class($recoveredAmountAnswerRecoveringIpInfoItem) : gettype($recoveredAmountAnswerRecoveringIpInfoItem)), __LINE__);
            }
        }
        $this->RecoveringIpInfo = $recoveringIpInfo;
        return $this;
    }
    /**
     * Add item to RecoveringIpInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\RecoveringIpInfoType $item
     * @return \AisFssp\StructType\RecoveredAmountAnswer
     */
    public function addToRecoveringIpInfo(\AisFssp\StructType\RecoveringIpInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\RecoveringIpInfoType) {
            throw new \InvalidArgumentException(sprintf('The RecoveringIpInfo property can only contain items of \AisFssp\StructType\RecoveringIpInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RecoveringIpInfo[] = $item;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\RecoveredAmountAnswer
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $recoveredAmountAnswerSignatureItem) {
            // validation for constraint: itemType
            if (!$recoveredAmountAnswerSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($recoveredAmountAnswerSignatureItem) ? get_class($recoveredAmountAnswerSignatureItem) : gettype($recoveredAmountAnswerSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\RecoveredAmountAnswer
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\RecoveredAmountAnswer
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\RecoveredAmountAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
