<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecallDoc StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ RecallDoc «Заявление об отзыве ИД» | Содержит сведения Заявления об отзыве Постановления о взыскании страховых взносов,
 * пеней и штрафов за счет имущества плательщика страховых взносов, направленного в ОСП ранее | ЭП
 * - type: tns:RecallDoc
 * @subpackage Structs
 */
class RecallDoc extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор заявления, присвоенный АИС внешнего контрагента. Уникален в рамках типа документа и
     * конкретного внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IdExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИД АИС ВК | Идентификатор исполнительного документа, полученного ранее от АИС внешнего контрагента. Заполняется
     * в том случае, если ИД был получен ранее от АИС того же внешнего контрагента | Идентификатор объекта, присвоенный объекту АИС внешнего
     * контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве
     * обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IdExternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата заявления | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The SPI
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ | Код СПИ, ведущего ИП | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при
     * получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $SPI;
    /**
     * The SPIFio
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | ФИО полностью СПИ, ведущего ИП | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $SPIFio;
    /**
     * The SPIPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность СПИ | Код должности СПИ, ведущего ИП | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $SPIPost;
    /**
     * The ClaimerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип взыскателя
     * @var string
     */
    public $ClaimerType;
    /**
     * The ClaimerName
     * Meta informations extracted from the WSDL
     * - documentation: Взыскатель | Наименование взыскателя, отменяющего ИД | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ClaimerName;
    /**
     * The OrganSignPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность подписавшего лица | Должность должностного лица, подписавшего Заявление | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $OrganSignPost;
    /**
     * The OrganSignFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО подписавшего лица | ФИО должностного лица, подписавшего Заявление | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OrganSignFIO;
    /**
     * The IDType
     * Meta informations extracted from the WSDL
     * - documentation: Вид исполнительного документа | Вид отменяемого ИД
     * @var string
     */
    public $IDType;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИД | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $IDNum;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИД | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The IDSum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма ИД | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IDSum;
    /**
     * The DebtorType
     * Meta informations extracted from the WSDL
     * - documentation: Тип должника
     * @var string
     */
    public $DebtorType;
    /**
     * The DebtorName
     * Meta informations extracted from the WSDL
     * - documentation: Должник | Полное наименование должника (для ЮЛ и ИП), ФИО полностью должника для ФЛ | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DebtorName;
    /**
     * The DebtorAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес должника | Адрес должника по ИД | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorAdr;
    /**
     * The DebtorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Дата рождения должника, для ФЛ обязательное | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DebtorBirthDate;
    /**
     * The DebtorBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения ФЛ | Для физических лиц обязательно | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $DebtorBirthYear;
    /**
     * The DebtorBirthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения | Место рождения должника, для ФЛ обязательное | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorBirthPlace;
    /**
     * The DebtorINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН должника | ИНН должника ЮЛ/ИП | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $DebtorINN;
    /**
     * The DebtorKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП должника | Код причины постановки на учет ЮЛ | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $DebtorKPP;
    /**
     * The DebtorOGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН/ОГРНИП | ОГРН/ОГРНИП ЮЛ/ИП | Основной государственный регистрационный номер (ОГРН)/Основной государственный
     * регистрационный номер индивидуального предпринимателя (ОГРНИП)
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $DebtorOGRN;
    /**
     * The DebtorNo
     * Meta informations extracted from the WSDL
     * - documentation: Рег. номер должника | Регистрационный номер должника, присвоенный органом, выдавшим ИД | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $DebtorNo;
    /**
     * The Subj
     * Meta informations extracted from the WSDL
     * - documentation: Предмет | Включает в себя резолютивную часть Заявления о прекращении исполнительных действий | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Subj;
    /**
     * The IDRecall
     * Meta informations extracted from the WSDL
     * - documentation: Отзыв | Отметка о необходимости возврата ИД | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $IDRecall;
    /**
     * The RecallDocBase
     * Meta informations extracted from the WSDL
     * - documentation: Заявление об отзыве ИД | Электронное обращение составленный в соответствии с форматом Приложения № 3 «Форматы электронного
     * обращение» в кодировке Base64
     * - minOccurs: 0
     * @var string
     */
    public $RecallDocBase;
    /**
     * The SignatureBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП Заявление об отзыве ИД | Электронное обращение составленный в соответствии с форматом Приложения № 3 «Форматы электронного
     * обращение» в кодировке Base64
     * - minOccurs: 0
     * @var string
     */
    public $SignatureBase;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Сведения о должнике
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $Data;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for RecallDoc
     * @uses RecallDoc::setExternalKey()
     * @uses RecallDoc::setIdExternalKey()
     * @uses RecallDoc::setDocDate()
     * @uses RecallDoc::setDocNumber()
     * @uses RecallDoc::setSPI()
     * @uses RecallDoc::setSPIFio()
     * @uses RecallDoc::setSPIPost()
     * @uses RecallDoc::setClaimerType()
     * @uses RecallDoc::setClaimerName()
     * @uses RecallDoc::setOrganSignPost()
     * @uses RecallDoc::setOrganSignFIO()
     * @uses RecallDoc::setIDType()
     * @uses RecallDoc::setIDNum()
     * @uses RecallDoc::setIDDate()
     * @uses RecallDoc::setIDSum()
     * @uses RecallDoc::setDebtorType()
     * @uses RecallDoc::setDebtorName()
     * @uses RecallDoc::setDebtorAdr()
     * @uses RecallDoc::setDebtorBirthDate()
     * @uses RecallDoc::setDebtorBirthYear()
     * @uses RecallDoc::setDebtorBirthPlace()
     * @uses RecallDoc::setDebtorINN()
     * @uses RecallDoc::setDebtorKPP()
     * @uses RecallDoc::setDebtorOGRN()
     * @uses RecallDoc::setDebtorNo()
     * @uses RecallDoc::setSubj()
     * @uses RecallDoc::setIDRecall()
     * @uses RecallDoc::setRecallDocBase()
     * @uses RecallDoc::setSignatureBase()
     * @uses RecallDoc::setData()
     * @uses RecallDoc::setSignDateTime()
     * @uses RecallDoc::setSignature()
     * @uses RecallDoc::setId()
     * @param string $externalKey
     * @param string $idExternalKey
     * @param string $docDate
     * @param string $docNumber
     * @param int $sPI
     * @param string $sPIFio
     * @param string $sPIPost
     * @param string $claimerType
     * @param string $claimerName
     * @param string $organSignPost
     * @param string $organSignFIO
     * @param string $iDType
     * @param string $iDNum
     * @param string $iDDate
     * @param float $iDSum
     * @param string $debtorType
     * @param string $debtorName
     * @param string $debtorAdr
     * @param string $debtorBirthDate
     * @param string $debtorBirthYear
     * @param string $debtorBirthPlace
     * @param string $debtorINN
     * @param string $debtorKPP
     * @param string $debtorOGRN
     * @param string $debtorNo
     * @param string $subj
     * @param bool $iDRecall
     * @param string $recallDocBase
     * @param string $signatureBase
     * @param \AisFssp\StructType\Data[] $data
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $idExternalKey = null, $docDate = null, $docNumber = null, $sPI = null, $sPIFio = null, $sPIPost = null, $claimerType = null, $claimerName = null, $organSignPost = null, $organSignFIO = null, $iDType = null, $iDNum = null, $iDDate = null, $iDSum = null, $debtorType = null, $debtorName = null, $debtorAdr = null, $debtorBirthDate = null, $debtorBirthYear = null, $debtorBirthPlace = null, $debtorINN = null, $debtorKPP = null, $debtorOGRN = null, $debtorNo = null, $subj = null, $iDRecall = null, $recallDocBase = null, $signatureBase = null, array $data = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setIdExternalKey($idExternalKey)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setSPI($sPI)
            ->setSPIFio($sPIFio)
            ->setSPIPost($sPIPost)
            ->setClaimerType($claimerType)
            ->setClaimerName($claimerName)
            ->setOrganSignPost($organSignPost)
            ->setOrganSignFIO($organSignFIO)
            ->setIDType($iDType)
            ->setIDNum($iDNum)
            ->setIDDate($iDDate)
            ->setIDSum($iDSum)
            ->setDebtorType($debtorType)
            ->setDebtorName($debtorName)
            ->setDebtorAdr($debtorAdr)
            ->setDebtorBirthDate($debtorBirthDate)
            ->setDebtorBirthYear($debtorBirthYear)
            ->setDebtorBirthPlace($debtorBirthPlace)
            ->setDebtorINN($debtorINN)
            ->setDebtorKPP($debtorKPP)
            ->setDebtorOGRN($debtorOGRN)
            ->setDebtorNo($debtorNo)
            ->setSubj($subj)
            ->setIDRecall($iDRecall)
            ->setRecallDocBase($recallDocBase)
            ->setSignatureBase($signatureBase)
            ->setData($data)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IdExternalKey value
     * @return string|null
     */
    public function getIdExternalKey()
    {
        return $this->IdExternalKey;
    }
    /**
     * Set IdExternalKey value
     * @param string $idExternalKey
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setIdExternalKey($idExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idExternalKey) && strlen($idExternalKey) > 60) || (is_array($idExternalKey) && count($idExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($idExternalKey) ? strlen($idExternalKey) : count($idExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($idExternalKey) && strlen($idExternalKey) < 1) || (is_array($idExternalKey) && count($idExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idExternalKey) && !is_string($idExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idExternalKey)), __LINE__);
        }
        $this->IdExternalKey = $idExternalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get SPI value
     * @return int|null
     */
    public function getSPI()
    {
        return $this->SPI;
    }
    /**
     * Set SPI value
     * @param int $sPI
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setSPI($sPI = null)
    {
        // validation for constraint: maxInclusive
        if ($sPI > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $sPI), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($sPI < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $sPI), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($sPI) && !is_numeric($sPI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sPI)), __LINE__);
        }
        $this->SPI = $sPI;
        return $this;
    }
    /**
     * Get SPIFio value
     * @return string|null
     */
    public function getSPIFio()
    {
        return $this->SPIFio;
    }
    /**
     * Set SPIFio value
     * @param string $sPIFio
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setSPIFio($sPIFio = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) > 100) || (is_array($sPIFio) && count($sPIFio) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($sPIFio) ? strlen($sPIFio) : count($sPIFio)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIFio) && strlen($sPIFio) < 1) || (is_array($sPIFio) && count($sPIFio) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIFio) && !is_string($sPIFio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIFio)), __LINE__);
        }
        $this->SPIFio = $sPIFio;
        return $this;
    }
    /**
     * Get SPIPost value
     * @return string|null
     */
    public function getSPIPost()
    {
        return $this->SPIPost;
    }
    /**
     * Set SPIPost value
     * @param string $sPIPost
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setSPIPost($sPIPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) > 25) || (is_array($sPIPost) && count($sPIPost) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($sPIPost) ? strlen($sPIPost) : count($sPIPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sPIPost) && strlen($sPIPost) < 1) || (is_array($sPIPost) && count($sPIPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($sPIPost) && !preg_match('/[0-9\\-\\.\\s]+/', $sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9\-\.\s]+", "%s" given', var_export($sPIPost, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sPIPost) && !is_string($sPIPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPIPost)), __LINE__);
        }
        $this->SPIPost = $sPIPost;
        return $this;
    }
    /**
     * Get ClaimerType value
     * @return string|null
     */
    public function getClaimerType()
    {
        return $this->ClaimerType;
    }
    /**
     * Set ClaimerType value
     * @uses \AisFssp\EnumType\ContragentType::valueIsValid()
     * @uses \AisFssp\EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claimerType
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setClaimerType($claimerType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ContragentType::valueIsValid($claimerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $claimerType, implode(', ', \AisFssp\EnumType\ContragentType::getValidValues())), __LINE__);
        }
        $this->ClaimerType = $claimerType;
        return $this;
    }
    /**
     * Get ClaimerName value
     * @return string|null
     */
    public function getClaimerName()
    {
        return $this->ClaimerName;
    }
    /**
     * Set ClaimerName value
     * @param string $claimerName
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setClaimerName($claimerName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($claimerName) && strlen($claimerName) > 1000) || (is_array($claimerName) && count($claimerName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($claimerName) ? strlen($claimerName) : count($claimerName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($claimerName) && strlen($claimerName) < 1) || (is_array($claimerName) && count($claimerName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($claimerName) && !is_string($claimerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($claimerName)), __LINE__);
        }
        $this->ClaimerName = $claimerName;
        return $this;
    }
    /**
     * Get OrganSignPost value
     * @return string|null
     */
    public function getOrganSignPost()
    {
        return $this->OrganSignPost;
    }
    /**
     * Set OrganSignPost value
     * @param string $organSignPost
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setOrganSignPost($organSignPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organSignPost) && strlen($organSignPost) > 300) || (is_array($organSignPost) && count($organSignPost) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($organSignPost) ? strlen($organSignPost) : count($organSignPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organSignPost) && strlen($organSignPost) < 1) || (is_array($organSignPost) && count($organSignPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organSignPost) && !is_string($organSignPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organSignPost)), __LINE__);
        }
        $this->OrganSignPost = $organSignPost;
        return $this;
    }
    /**
     * Get OrganSignFIO value
     * @return string|null
     */
    public function getOrganSignFIO()
    {
        return $this->OrganSignFIO;
    }
    /**
     * Set OrganSignFIO value
     * @param string $organSignFIO
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setOrganSignFIO($organSignFIO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organSignFIO) && strlen($organSignFIO) > 100) || (is_array($organSignFIO) && count($organSignFIO) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($organSignFIO) ? strlen($organSignFIO) : count($organSignFIO)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organSignFIO) && strlen($organSignFIO) < 1) || (is_array($organSignFIO) && count($organSignFIO) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organSignFIO) && !is_string($organSignFIO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organSignFIO)), __LINE__);
        }
        $this->OrganSignFIO = $organSignFIO;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \AisFssp\EnumType\IdType::valueIsValid()
     * @uses \AisFssp\EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setIDType($iDType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\IdType::valueIsValid($iDType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $iDType, implode(', ', \AisFssp\EnumType\IdType::getValidValues())), __LINE__);
        }
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string|null
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setIDNum($iDNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDNum) && strlen($iDNum) > 50) || (is_array($iDNum) && count($iDNum) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($iDNum) ? strlen($iDNum) : count($iDNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDNum) && strlen($iDNum) < 1) || (is_array($iDNum) && count($iDNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDNum) && !is_string($iDNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDNum)), __LINE__);
        }
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setIDDate($iDDate = null)
    {
        // validation for constraint: maxExclusive
        if ($iDDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iDDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDDate) && !is_string($iDDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDDate)), __LINE__);
        }
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get IDSum value
     * @return float|null
     */
    public function getIDSum()
    {
        return $this->IDSum;
    }
    /**
     * Set IDSum value
     * @param float $iDSum
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setIDSum($iDSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iDSum) && strlen(substr($iDSum, strpos($iDSum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iDSum, strpos($iDSum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iDSum) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iDSum)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iDSum, strpos($iDSum, '.')))), __LINE__);
        }
        $this->IDSum = $iDSum;
        return $this;
    }
    /**
     * Get DebtorType value
     * @return string|null
     */
    public function getDebtorType()
    {
        return $this->DebtorType;
    }
    /**
     * Set DebtorType value
     * @uses \AisFssp\EnumType\ContragentType::valueIsValid()
     * @uses \AisFssp\EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorType
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setDebtorType($debtorType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ContragentType::valueIsValid($debtorType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $debtorType, implode(', ', \AisFssp\EnumType\ContragentType::getValidValues())), __LINE__);
        }
        $this->DebtorType = $debtorType;
        return $this;
    }
    /**
     * Get DebtorName value
     * @return string|null
     */
    public function getDebtorName()
    {
        return $this->DebtorName;
    }
    /**
     * Set DebtorName value
     * @param string $debtorName
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setDebtorName($debtorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorName) && strlen($debtorName) > 1000) || (is_array($debtorName) && count($debtorName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($debtorName) ? strlen($debtorName) : count($debtorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorName) && strlen($debtorName) < 1) || (is_array($debtorName) && count($debtorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorName) && !is_string($debtorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorName)), __LINE__);
        }
        $this->DebtorName = $debtorName;
        return $this;
    }
    /**
     * Get DebtorAdr value
     * @return string|null
     */
    public function getDebtorAdr()
    {
        return $this->DebtorAdr;
    }
    /**
     * Set DebtorAdr value
     * @param string $debtorAdr
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setDebtorAdr($debtorAdr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorAdr) && strlen($debtorAdr) > 300) || (is_array($debtorAdr) && count($debtorAdr) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($debtorAdr) ? strlen($debtorAdr) : count($debtorAdr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorAdr) && strlen($debtorAdr) < 1) || (is_array($debtorAdr) && count($debtorAdr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorAdr) && !is_string($debtorAdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorAdr)), __LINE__);
        }
        $this->DebtorAdr = $debtorAdr;
        return $this;
    }
    /**
     * Get DebtorBirthDate value
     * @return string|null
     */
    public function getDebtorBirthDate()
    {
        return $this->DebtorBirthDate;
    }
    /**
     * Set DebtorBirthDate value
     * @param string $debtorBirthDate
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setDebtorBirthDate($debtorBirthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($debtorBirthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $debtorBirthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorBirthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorBirthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthDate) && !is_string($debtorBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthDate)), __LINE__);
        }
        $this->DebtorBirthDate = $debtorBirthDate;
        return $this;
    }
    /**
     * Get DebtorBirthYear value
     * @return string|null
     */
    public function getDebtorBirthYear()
    {
        return $this->DebtorBirthYear;
    }
    /**
     * Set DebtorBirthYear value
     * @param string $debtorBirthYear
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setDebtorBirthYear($debtorBirthYear = null)
    {
        // validation for constraint: maxInclusive
        if ($debtorBirthYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $debtorBirthYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorBirthYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorBirthYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthYear) && !is_string($debtorBirthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthYear)), __LINE__);
        }
        $this->DebtorBirthYear = $debtorBirthYear;
        return $this;
    }
    /**
     * Get DebtorBirthPlace value
     * @return string|null
     */
    public function getDebtorBirthPlace()
    {
        return $this->DebtorBirthPlace;
    }
    /**
     * Set DebtorBirthPlace value
     * @param string $debtorBirthPlace
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setDebtorBirthPlace($debtorBirthPlace = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorBirthPlace) && strlen($debtorBirthPlace) > 300) || (is_array($debtorBirthPlace) && count($debtorBirthPlace) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($debtorBirthPlace) ? strlen($debtorBirthPlace) : count($debtorBirthPlace)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorBirthPlace) && strlen($debtorBirthPlace) < 1) || (is_array($debtorBirthPlace) && count($debtorBirthPlace) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthPlace) && !is_string($debtorBirthPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthPlace)), __LINE__);
        }
        $this->DebtorBirthPlace = $debtorBirthPlace;
        return $this;
    }
    /**
     * Get DebtorINN value
     * @return string|null
     */
    public function getDebtorINN()
    {
        return $this->DebtorINN;
    }
    /**
     * Set DebtorINN value
     * @param string $debtorINN
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setDebtorINN($debtorINN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorINN) && strlen($debtorINN) > 12) || (is_array($debtorINN) && count($debtorINN) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($debtorINN) ? strlen($debtorINN) : count($debtorINN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorINN) && strlen($debtorINN) < 10) || (is_array($debtorINN) && count($debtorINN) < 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorINN) && !preg_match('/(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})/', $debtorINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})", "%s" given', var_export($debtorINN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorINN) && !is_string($debtorINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorINN)), __LINE__);
        }
        $this->DebtorINN = $debtorINN;
        return $this;
    }
    /**
     * Get DebtorKPP value
     * @return string|null
     */
    public function getDebtorKPP()
    {
        return $this->DebtorKPP;
    }
    /**
     * Set DebtorKPP value
     * @param string $debtorKPP
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setDebtorKPP($debtorKPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($debtorKPP) && strlen($debtorKPP) !== 9) || (is_array($debtorKPP) && count($debtorKPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorKPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $debtorKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($debtorKPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorKPP) && !is_string($debtorKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorKPP)), __LINE__);
        }
        $this->DebtorKPP = $debtorKPP;
        return $this;
    }
    /**
     * Get DebtorOGRN value
     * @return string|null
     */
    public function getDebtorOGRN()
    {
        return $this->DebtorOGRN;
    }
    /**
     * Set DebtorOGRN value
     * @param string $debtorOGRN
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setDebtorOGRN($debtorOGRN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorOGRN) && strlen($debtorOGRN) > 15) || (is_array($debtorOGRN) && count($debtorOGRN) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($debtorOGRN) ? strlen($debtorOGRN) : count($debtorOGRN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorOGRN) && strlen($debtorOGRN) < 13) || (is_array($debtorOGRN) && count($debtorOGRN) < 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorOGRN) && !preg_match('/([0-9]{13})|([0-9]{15})/', $debtorOGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{13})|([0-9]{15})", "%s" given', var_export($debtorOGRN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorOGRN) && !is_string($debtorOGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorOGRN)), __LINE__);
        }
        $this->DebtorOGRN = $debtorOGRN;
        return $this;
    }
    /**
     * Get DebtorNo value
     * @return string|null
     */
    public function getDebtorNo()
    {
        return $this->DebtorNo;
    }
    /**
     * Set DebtorNo value
     * @param string $debtorNo
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setDebtorNo($debtorNo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorNo) && strlen($debtorNo) > 20) || (is_array($debtorNo) && count($debtorNo) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($debtorNo) ? strlen($debtorNo) : count($debtorNo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorNo) && strlen($debtorNo) < 1) || (is_array($debtorNo) && count($debtorNo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorNo) && !is_string($debtorNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorNo)), __LINE__);
        }
        $this->DebtorNo = $debtorNo;
        return $this;
    }
    /**
     * Get Subj value
     * @return string|null
     */
    public function getSubj()
    {
        return $this->Subj;
    }
    /**
     * Set Subj value
     * @param string $subj
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setSubj($subj = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($subj) && strlen($subj) > 300) || (is_array($subj) && count($subj) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($subj) ? strlen($subj) : count($subj)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($subj) && strlen($subj) < 1) || (is_array($subj) && count($subj) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($subj) && !is_string($subj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subj)), __LINE__);
        }
        $this->Subj = $subj;
        return $this;
    }
    /**
     * Get IDRecall value
     * @return bool|null
     */
    public function getIDRecall()
    {
        return $this->IDRecall;
    }
    /**
     * Set IDRecall value
     * @param bool $iDRecall
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setIDRecall($iDRecall = null)
    {
        // validation for constraint: boolean
        if (!is_null($iDRecall) && !is_bool($iDRecall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($iDRecall)), __LINE__);
        }
        $this->IDRecall = $iDRecall;
        return $this;
    }
    /**
     * Get RecallDocBase value
     * @return string|null
     */
    public function getRecallDocBase()
    {
        return $this->RecallDocBase;
    }
    /**
     * Set RecallDocBase value
     * @param string $recallDocBase
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setRecallDocBase($recallDocBase = null)
    {
        // validation for constraint: string
        if (!is_null($recallDocBase) && !is_string($recallDocBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recallDocBase)), __LINE__);
        }
        $this->RecallDocBase = $recallDocBase;
        return $this;
    }
    /**
     * Get SignatureBase value
     * @return string|null
     */
    public function getSignatureBase()
    {
        return $this->SignatureBase;
    }
    /**
     * Set SignatureBase value
     * @param string $signatureBase
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setSignatureBase($signatureBase = null)
    {
        // validation for constraint: string
        if (!is_null($signatureBase) && !is_string($signatureBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signatureBase)), __LINE__);
        }
        $this->SignatureBase = $signatureBase;
        return $this;
    }
    /**
     * Get Data value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $data
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setData(array $data = array())
    {
        foreach ($data as $recallDocDataItem) {
            // validation for constraint: itemType
            if (!$recallDocDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($recallDocDataItem) ? get_class($recallDocDataItem) : gettype($recallDocDataItem)), __LINE__);
            }
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\RecallDoc
     */
    public function addToData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $recallDocSignatureItem) {
            // validation for constraint: itemType
            if (!$recallDocSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($recallDocSignatureItem) ? get_class($recallDocSignatureItem) : gettype($recallDocSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\RecallDoc
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\RecallDoc
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\RecallDoc
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
