<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RealtyRegistryExtractType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Выписка из реестра недвижимости
 * @subpackage Structs
 */
class RealtyRegistryExtractType extends InformationType
{
    /**
     * The extractNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер выписки/справки/сообщения | Строка длиной от 1 до 50 символов
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $extractNumber;
    /**
     * The extractDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выписки/справки/сообщения | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $extractDate;
    /**
     * The queryNumber
     * Meta informations extracted from the WSDL
     * - documentation: Hомер документа запроса | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $queryNumber;
    /**
     * The queryDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа запроса | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $queryDate;
    /**
     * The outgoingNumber
     * Meta informations extracted from the WSDL
     * - documentation: Исходящий номер учреждения | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $outgoingNumber;
    /**
     * The outgoingDate
     * Meta informations extracted from the WSDL
     * - documentation: Исходящая дата учреждения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $outgoingDate;
    /**
     * The registrator
     * Meta informations extracted from the WSDL
     * - documentation: Регистратор, подписавший выписку(справку) | Полное имя физического лица (фамилия, имя, отчество)
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $registrator;
    /**
     * The addInfo
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительная информация | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $addInfo;
    /**
     * The recipientInfo
     * Meta informations extracted from the WSDL
     * - documentation: Описание получателя информации ("выписка выдана ...") | Строка длиной от 1 до 4000 символов
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $recipientInfo;
    /**
     * The refusalCode
     * Meta informations extracted from the WSDL
     * - documentation: Тип отказа | По классификатору «Классификатор типов отказов запросов информации ЕГРП» | Строка длиной от 1 до 3 символов
     * - minOccurs: 0
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $refusalCode;
    /**
     * The refusalName
     * Meta informations extracted from the WSDL
     * - documentation: Текст типа отказа | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $refusalName;
    /**
     * The refusalText
     * Meta informations extracted from the WSDL
     * - documentation: Текст отказа | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $refusalText;
    /**
     * The arrestInfo
     * Meta informations extracted from the WSDL
     * - documentation: Информация о зарегистрированных записей КУА | Строка длиной от 1 до 4000 символов
     * - minOccurs: 0
     * - maxLength: 4000
     * - minLength: 1
     * @var string
     */
    public $arrestInfo;
    /**
     * Constructor method for RealtyRegistryExtractType
     * @uses RealtyRegistryExtractType::setExtractNumber()
     * @uses RealtyRegistryExtractType::setExtractDate()
     * @uses RealtyRegistryExtractType::setQueryNumber()
     * @uses RealtyRegistryExtractType::setQueryDate()
     * @uses RealtyRegistryExtractType::setOutgoingNumber()
     * @uses RealtyRegistryExtractType::setOutgoingDate()
     * @uses RealtyRegistryExtractType::setRegistrator()
     * @uses RealtyRegistryExtractType::setAddInfo()
     * @uses RealtyRegistryExtractType::setRecipientInfo()
     * @uses RealtyRegistryExtractType::setRefusalCode()
     * @uses RealtyRegistryExtractType::setRefusalName()
     * @uses RealtyRegistryExtractType::setRefusalText()
     * @uses RealtyRegistryExtractType::setArrestInfo()
     * @param string $extractNumber
     * @param string $extractDate
     * @param string $queryNumber
     * @param string $queryDate
     * @param string $outgoingNumber
     * @param string $outgoingDate
     * @param string $registrator
     * @param string $addInfo
     * @param string $recipientInfo
     * @param string $refusalCode
     * @param string $refusalName
     * @param string $refusalText
     * @param string $arrestInfo
     */
    public function __construct($extractNumber = null, $extractDate = null, $queryNumber = null, $queryDate = null, $outgoingNumber = null, $outgoingDate = null, $registrator = null, $addInfo = null, $recipientInfo = null, $refusalCode = null, $refusalName = null, $refusalText = null, $arrestInfo = null)
    {
        $this
            ->setExtractNumber($extractNumber)
            ->setExtractDate($extractDate)
            ->setQueryNumber($queryNumber)
            ->setQueryDate($queryDate)
            ->setOutgoingNumber($outgoingNumber)
            ->setOutgoingDate($outgoingDate)
            ->setRegistrator($registrator)
            ->setAddInfo($addInfo)
            ->setRecipientInfo($recipientInfo)
            ->setRefusalCode($refusalCode)
            ->setRefusalName($refusalName)
            ->setRefusalText($refusalText)
            ->setArrestInfo($arrestInfo);
    }
    /**
     * Get extractNumber value
     * @return string|null
     */
    public function getExtractNumber()
    {
        return $this->extractNumber;
    }
    /**
     * Set extractNumber value
     * @param string $extractNumber
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setExtractNumber($extractNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($extractNumber) && strlen($extractNumber) > 50) || (is_array($extractNumber) && count($extractNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($extractNumber) ? strlen($extractNumber) : count($extractNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($extractNumber) && strlen($extractNumber) < 1) || (is_array($extractNumber) && count($extractNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($extractNumber) && !is_string($extractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extractNumber)), __LINE__);
        }
        $this->extractNumber = $extractNumber;
        return $this;
    }
    /**
     * Get extractDate value
     * @return string|null
     */
    public function getExtractDate()
    {
        return $this->extractDate;
    }
    /**
     * Set extractDate value
     * @param string $extractDate
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setExtractDate($extractDate = null)
    {
        // validation for constraint: maxExclusive
        if ($extractDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $extractDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($extractDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $extractDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($extractDate) && !is_string($extractDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extractDate)), __LINE__);
        }
        $this->extractDate = $extractDate;
        return $this;
    }
    /**
     * Get queryNumber value
     * @return string|null
     */
    public function getQueryNumber()
    {
        return $this->queryNumber;
    }
    /**
     * Set queryNumber value
     * @param string $queryNumber
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setQueryNumber($queryNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($queryNumber) && strlen($queryNumber) > 50) || (is_array($queryNumber) && count($queryNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($queryNumber) ? strlen($queryNumber) : count($queryNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($queryNumber) && strlen($queryNumber) < 1) || (is_array($queryNumber) && count($queryNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($queryNumber) && !is_string($queryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queryNumber)), __LINE__);
        }
        $this->queryNumber = $queryNumber;
        return $this;
    }
    /**
     * Get queryDate value
     * @return string|null
     */
    public function getQueryDate()
    {
        return $this->queryDate;
    }
    /**
     * Set queryDate value
     * @param string $queryDate
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setQueryDate($queryDate = null)
    {
        // validation for constraint: maxExclusive
        if ($queryDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $queryDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($queryDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $queryDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($queryDate) && !is_string($queryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queryDate)), __LINE__);
        }
        $this->queryDate = $queryDate;
        return $this;
    }
    /**
     * Get outgoingNumber value
     * @return string|null
     */
    public function getOutgoingNumber()
    {
        return $this->outgoingNumber;
    }
    /**
     * Set outgoingNumber value
     * @param string $outgoingNumber
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setOutgoingNumber($outgoingNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($outgoingNumber) && strlen($outgoingNumber) > 50) || (is_array($outgoingNumber) && count($outgoingNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($outgoingNumber) ? strlen($outgoingNumber) : count($outgoingNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($outgoingNumber) && strlen($outgoingNumber) < 1) || (is_array($outgoingNumber) && count($outgoingNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($outgoingNumber) && !is_string($outgoingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($outgoingNumber)), __LINE__);
        }
        $this->outgoingNumber = $outgoingNumber;
        return $this;
    }
    /**
     * Get outgoingDate value
     * @return string|null
     */
    public function getOutgoingDate()
    {
        return $this->outgoingDate;
    }
    /**
     * Set outgoingDate value
     * @param string $outgoingDate
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setOutgoingDate($outgoingDate = null)
    {
        // validation for constraint: maxExclusive
        if ($outgoingDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $outgoingDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($outgoingDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $outgoingDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($outgoingDate) && !is_string($outgoingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($outgoingDate)), __LINE__);
        }
        $this->outgoingDate = $outgoingDate;
        return $this;
    }
    /**
     * Get registrator value
     * @return string|null
     */
    public function getRegistrator()
    {
        return $this->registrator;
    }
    /**
     * Set registrator value
     * @param string $registrator
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setRegistrator($registrator = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($registrator) && strlen($registrator) > 100) || (is_array($registrator) && count($registrator) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($registrator) ? strlen($registrator) : count($registrator)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($registrator) && strlen($registrator) < 1) || (is_array($registrator) && count($registrator) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($registrator) && !is_string($registrator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($registrator)), __LINE__);
        }
        $this->registrator = $registrator;
        return $this;
    }
    /**
     * Get addInfo value
     * @return string|null
     */
    public function getAddInfo()
    {
        return $this->addInfo;
    }
    /**
     * Set addInfo value
     * @param string $addInfo
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setAddInfo($addInfo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addInfo) && strlen($addInfo) > 4000) || (is_array($addInfo) && count($addInfo) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($addInfo) ? strlen($addInfo) : count($addInfo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($addInfo) && strlen($addInfo) < 1) || (is_array($addInfo) && count($addInfo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addInfo) && !is_string($addInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addInfo)), __LINE__);
        }
        $this->addInfo = $addInfo;
        return $this;
    }
    /**
     * Get recipientInfo value
     * @return string|null
     */
    public function getRecipientInfo()
    {
        return $this->recipientInfo;
    }
    /**
     * Set recipientInfo value
     * @param string $recipientInfo
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setRecipientInfo($recipientInfo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($recipientInfo) && strlen($recipientInfo) > 4000) || (is_array($recipientInfo) && count($recipientInfo) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($recipientInfo) ? strlen($recipientInfo) : count($recipientInfo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recipientInfo) && strlen($recipientInfo) < 1) || (is_array($recipientInfo) && count($recipientInfo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recipientInfo) && !is_string($recipientInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recipientInfo)), __LINE__);
        }
        $this->recipientInfo = $recipientInfo;
        return $this;
    }
    /**
     * Get refusalCode value
     * @return string|null
     */
    public function getRefusalCode()
    {
        return $this->refusalCode;
    }
    /**
     * Set refusalCode value
     * @param string $refusalCode
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setRefusalCode($refusalCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($refusalCode) && strlen($refusalCode) > 3) || (is_array($refusalCode) && count($refusalCode) > 3)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s) at most, "%d" length given', is_scalar($refusalCode) ? strlen($refusalCode) : count($refusalCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($refusalCode) && strlen($refusalCode) < 1) || (is_array($refusalCode) && count($refusalCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($refusalCode) && !is_string($refusalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refusalCode)), __LINE__);
        }
        $this->refusalCode = $refusalCode;
        return $this;
    }
    /**
     * Get refusalName value
     * @return string|null
     */
    public function getRefusalName()
    {
        return $this->refusalName;
    }
    /**
     * Set refusalName value
     * @param string $refusalName
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setRefusalName($refusalName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($refusalName) && strlen($refusalName) > 255) || (is_array($refusalName) && count($refusalName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($refusalName) ? strlen($refusalName) : count($refusalName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($refusalName) && strlen($refusalName) < 1) || (is_array($refusalName) && count($refusalName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($refusalName) && !is_string($refusalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refusalName)), __LINE__);
        }
        $this->refusalName = $refusalName;
        return $this;
    }
    /**
     * Get refusalText value
     * @return string|null
     */
    public function getRefusalText()
    {
        return $this->refusalText;
    }
    /**
     * Set refusalText value
     * @param string $refusalText
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setRefusalText($refusalText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($refusalText) && strlen($refusalText) > 4000) || (is_array($refusalText) && count($refusalText) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($refusalText) ? strlen($refusalText) : count($refusalText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($refusalText) && strlen($refusalText) < 1) || (is_array($refusalText) && count($refusalText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($refusalText) && !is_string($refusalText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refusalText)), __LINE__);
        }
        $this->refusalText = $refusalText;
        return $this;
    }
    /**
     * Get arrestInfo value
     * @return string|null
     */
    public function getArrestInfo()
    {
        return $this->arrestInfo;
    }
    /**
     * Set arrestInfo value
     * @param string $arrestInfo
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public function setArrestInfo($arrestInfo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($arrestInfo) && strlen($arrestInfo) > 4000) || (is_array($arrestInfo) && count($arrestInfo) > 4000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 4000 element(s) or a scalar of 4000 character(s) at most, "%d" length given', is_scalar($arrestInfo) ? strlen($arrestInfo) : count($arrestInfo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($arrestInfo) && strlen($arrestInfo) < 1) || (is_array($arrestInfo) && count($arrestInfo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($arrestInfo) && !is_string($arrestInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrestInfo)), __LINE__);
        }
        $this->arrestInfo = $arrestInfo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\RealtyRegistryExtractType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
