<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о физическом лице от ФНС
 * @subpackage Structs
 */
class PersonDatumType extends InformationType
{
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН физического лица | ИНН Физического лица
     * - minOccurs: 0
     * - length: 12
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10}
     * @var string
     */
    public $INN;
    /**
     * The birthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $birthDate;
    /**
     * The birthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения физического лица | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $birthPlace;
    /**
     * The OGRNIP
     * Meta informations extracted from the WSDL
     * - documentation: ОГРНИП индивидуального предпринимателя | Основной государственный регистрационный номер индивидуального предпринимателя
     * (ОГРНИП)
     * - minOccurs: 0
     * - length: 15
     * - pattern: [0-9]{15}
     * @var string
     */
    public $OGRNIP;
    /**
     * The FNSResource
     * Meta informations extracted from the WSDL
     * - documentation: Вид ресурса - источника сведений | Вид ресурса (реестра) ФНС
     * - minOccurs: 0
     * - maxInclusive: 3
     * - minInclusive: 1
     * @var int
     */
    public $FNSResource;
    /**
     * The FIO
     * Meta informations extracted from the WSDL
     * - documentation: Фамилия, имя, отчество физического лица
     * @var \AisFssp\StructType\FioType
     */
    public $FIO;
    /**
     * The FIOLat
     * Meta informations extracted from the WSDL
     * - documentation: Фамилия, имя, отчество физического лица латиницей
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $FIOLat;
    /**
     * The gender
     * Meta informations extracted from the WSDL
     * - documentation: Пол
     * - minOccurs: 0
     * @var string
     */
    public $gender;
    /**
     * The SNILS
     * Meta informations extracted from the WSDL
     * - documentation: СНИЛС физического лица | СНИЛС
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $SNILS;
    /**
     * Constructor method for PersonDatumType
     * @uses PersonDatumType::setINN()
     * @uses PersonDatumType::setBirthDate()
     * @uses PersonDatumType::setBirthPlace()
     * @uses PersonDatumType::setOGRNIP()
     * @uses PersonDatumType::setFNSResource()
     * @uses PersonDatumType::setFIO()
     * @uses PersonDatumType::setFIOLat()
     * @uses PersonDatumType::setGender()
     * @uses PersonDatumType::setSNILS()
     * @param string $iNN
     * @param string $birthDate
     * @param string $birthPlace
     * @param string $oGRNIP
     * @param int $fNSResource
     * @param \AisFssp\StructType\FioType $fIO
     * @param \AisFssp\StructType\FioType $fIOLat
     * @param string $gender
     * @param string $sNILS
     */
    public function __construct($iNN = null, $birthDate = null, $birthPlace = null, $oGRNIP = null, $fNSResource = null, \AisFssp\StructType\FioType $fIO = null, \AisFssp\StructType\FioType $fIOLat = null, $gender = null, $sNILS = null)
    {
        $this
            ->setINN($iNN)
            ->setBirthDate($birthDate)
            ->setBirthPlace($birthPlace)
            ->setOGRNIP($oGRNIP)
            ->setFNSResource($fNSResource)
            ->setFIO($fIO)
            ->setFIOLat($fIOLat)
            ->setGender($gender)
            ->setSNILS($sNILS);
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \AisFssp\StructType\PersonDatumType
     */
    public function setINN($iNN = null)
    {
        // validation for constraint: length
        if ((is_scalar($iNN) && strlen($iNN) !== 12) || (is_array($iNN) && count($iNN) !== 12)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iNN) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10}/', $iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10}", "%s" given', var_export($iNN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iNN) && !is_string($iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNN)), __LINE__);
        }
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get birthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->birthDate;
    }
    /**
     * Set birthDate value
     * @param string $birthDate
     * @return \AisFssp\StructType\PersonDatumType
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($birthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($birthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $birthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->birthDate = $birthDate;
        return $this;
    }
    /**
     * Get birthPlace value
     * @return string|null
     */
    public function getBirthPlace()
    {
        return $this->birthPlace;
    }
    /**
     * Set birthPlace value
     * @param string $birthPlace
     * @return \AisFssp\StructType\PersonDatumType
     */
    public function setBirthPlace($birthPlace = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($birthPlace) && strlen($birthPlace) > 300) || (is_array($birthPlace) && count($birthPlace) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($birthPlace) ? strlen($birthPlace) : count($birthPlace)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($birthPlace) && strlen($birthPlace) < 1) || (is_array($birthPlace) && count($birthPlace) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($birthPlace) && !is_string($birthPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthPlace)), __LINE__);
        }
        $this->birthPlace = $birthPlace;
        return $this;
    }
    /**
     * Get OGRNIP value
     * @return string|null
     */
    public function getOGRNIP()
    {
        return $this->OGRNIP;
    }
    /**
     * Set OGRNIP value
     * @param string $oGRNIP
     * @return \AisFssp\StructType\PersonDatumType
     */
    public function setOGRNIP($oGRNIP = null)
    {
        // validation for constraint: length
        if ((is_scalar($oGRNIP) && strlen($oGRNIP) !== 15) || (is_array($oGRNIP) && count($oGRNIP) !== 15)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oGRNIP) && !preg_match('/[0-9]{15}/', $oGRNIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{15}", "%s" given', var_export($oGRNIP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oGRNIP) && !is_string($oGRNIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oGRNIP)), __LINE__);
        }
        $this->OGRNIP = $oGRNIP;
        return $this;
    }
    /**
     * Get FNSResource value
     * @return int|null
     */
    public function getFNSResource()
    {
        return $this->FNSResource;
    }
    /**
     * Set FNSResource value
     * @param int $fNSResource
     * @return \AisFssp\StructType\PersonDatumType
     */
    public function setFNSResource($fNSResource = null)
    {
        // validation for constraint: maxInclusive
        if ($fNSResource > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 3, "%s" given', $fNSResource), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($fNSResource < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1, "%s" given', $fNSResource), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($fNSResource) && !is_numeric($fNSResource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fNSResource)), __LINE__);
        }
        $this->FNSResource = $fNSResource;
        return $this;
    }
    /**
     * Get FIO value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getFIO()
    {
        return $this->FIO;
    }
    /**
     * Set FIO value
     * @param \AisFssp\StructType\FioType $fIO
     * @return \AisFssp\StructType\PersonDatumType
     */
    public function setFIO(\AisFssp\StructType\FioType $fIO = null)
    {
        $this->FIO = $fIO;
        return $this;
    }
    /**
     * Get FIOLat value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getFIOLat()
    {
        return $this->FIOLat;
    }
    /**
     * Set FIOLat value
     * @param \AisFssp\StructType\FioType $fIOLat
     * @return \AisFssp\StructType\PersonDatumType
     */
    public function setFIOLat(\AisFssp\StructType\FioType $fIOLat = null)
    {
        $this->FIOLat = $fIOLat;
        return $this;
    }
    /**
     * Get gender value
     * @return string|null
     */
    public function getGender()
    {
        return $this->gender;
    }
    /**
     * Set gender value
     * @uses \AisFssp\EnumType\GenderCodeType::valueIsValid()
     * @uses \AisFssp\EnumType\GenderCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \AisFssp\StructType\PersonDatumType
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\GenderCodeType::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $gender, implode(', ', \AisFssp\EnumType\GenderCodeType::getValidValues())), __LINE__);
        }
        $this->gender = $gender;
        return $this;
    }
    /**
     * Get SNILS value
     * @return string|null
     */
    public function getSNILS()
    {
        return $this->SNILS;
    }
    /**
     * Set SNILS value
     * @param string $sNILS
     * @return \AisFssp\StructType\PersonDatumType
     */
    public function setSNILS($sNILS = null)
    {
        // validation for constraint: length
        if ((is_scalar($sNILS) && strlen($sNILS) !== 11) || (is_array($sNILS) && count($sNILS) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($sNILS) && !preg_match('/[0-9]{11}/', $sNILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($sNILS, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sNILS) && !is_string($sNILS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sNILS)), __LINE__);
        }
        $this->SNILS = $sNILS;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\PersonDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
