<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PenaltyChargesRegistry StructType
 * Meta informations extracted from the WSDL
 * - documentation: Реестр штрафов по АД
 * - type: tns:PenaltyChargesRegistry
 * @subpackage Structs
 */
class PenaltyChargesRegistry extends AbstractStructBase
{
    /**
     * The Version
     * Meta informations extracted from the WSDL
     * - documentation: Версия документа | Заполняется значением «PLTY_1_1» | Строка длиной от 1 до 8 символов
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $Version;
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ реестра ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The OspCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $OspCode;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The UnloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выгрузки | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $UnloadDate;
    /**
     * The PenaltyData
     * Meta informations extracted from the WSDL
     * - documentation: Данные по штрафам
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\PenaltyChargesData[]
     */
    public $PenaltyData;
    /**
     * Constructor method for PenaltyChargesRegistry
     * @uses PenaltyChargesRegistry::setVersion()
     * @uses PenaltyChargesRegistry::setInternalKey()
     * @uses PenaltyChargesRegistry::setOspCode()
     * @uses PenaltyChargesRegistry::setDocDate()
     * @uses PenaltyChargesRegistry::setDocNumber()
     * @uses PenaltyChargesRegistry::setUnloadDate()
     * @uses PenaltyChargesRegistry::setPenaltyData()
     * @param string $version
     * @param int $internalKey
     * @param string $ospCode
     * @param string $docDate
     * @param string $docNumber
     * @param string $unloadDate
     * @param \AisFssp\StructType\PenaltyChargesData[] $penaltyData
     */
    public function __construct($version = null, $internalKey = null, $ospCode = null, $docDate = null, $docNumber = null, $unloadDate = null, array $penaltyData = array())
    {
        $this
            ->setVersion($version)
            ->setInternalKey($internalKey)
            ->setOspCode($ospCode)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setUnloadDate($unloadDate)
            ->setPenaltyData($penaltyData);
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \AisFssp\StructType\PenaltyChargesRegistry
     */
    public function setVersion($version = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($version) && strlen($version) > 8) || (is_array($version) && count($version) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($version) ? strlen($version) : count($version)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($version) && strlen($version) < 1) || (is_array($version) && count($version) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\PenaltyChargesRegistry
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get OspCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->OspCode;
    }
    /**
     * Set OspCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\PenaltyChargesRegistry
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->OspCode = $ospCode;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\PenaltyChargesRegistry
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\PenaltyChargesRegistry
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get UnloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->UnloadDate;
    }
    /**
     * Set UnloadDate value
     * @param string $unloadDate
     * @return \AisFssp\StructType\PenaltyChargesRegistry
     */
    public function setUnloadDate($unloadDate = null)
    {
        // validation for constraint: maxExclusive
        if ($unloadDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($unloadDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unloadDate) && !is_string($unloadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unloadDate)), __LINE__);
        }
        $this->UnloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get PenaltyData value
     * @return \AisFssp\StructType\PenaltyChargesData[]|null
     */
    public function getPenaltyData()
    {
        return $this->PenaltyData;
    }
    /**
     * Set PenaltyData value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\PenaltyChargesData[] $penaltyData
     * @return \AisFssp\StructType\PenaltyChargesRegistry
     */
    public function setPenaltyData(array $penaltyData = array())
    {
        foreach ($penaltyData as $penaltyChargesRegistryPenaltyDataItem) {
            // validation for constraint: itemType
            if (!$penaltyChargesRegistryPenaltyDataItem instanceof \AisFssp\StructType\PenaltyChargesData) {
                throw new \InvalidArgumentException(sprintf('The PenaltyData property can only contain items of \AisFssp\StructType\PenaltyChargesData, "%s" given', is_object($penaltyChargesRegistryPenaltyDataItem) ? get_class($penaltyChargesRegistryPenaltyDataItem) : gettype($penaltyChargesRegistryPenaltyDataItem)), __LINE__);
            }
        }
        $this->PenaltyData = $penaltyData;
        return $this;
    }
    /**
     * Add item to PenaltyData value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\PenaltyChargesData $item
     * @return \AisFssp\StructType\PenaltyChargesRegistry
     */
    public function addToPenaltyData(\AisFssp\StructType\PenaltyChargesData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\PenaltyChargesData) {
            throw new \InvalidArgumentException(sprintf('The PenaltyData property can only contain items of \AisFssp\StructType\PenaltyChargesData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PenaltyData[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\PenaltyChargesRegistry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
