<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentProperties StructType
 * Meta informations extracted from the WSDL
 * - documentation: Контейнер PaymentProperties «Реквизиты для перечисления» | Реквизиты для перечисления взысканных сумм взыскателю (для налоговых
 * платежей может быть указано более одного набора реквизитов)
 * - type: tns:PaymentProperties
 * @subpackage Structs
 */
class PaymentProperties extends AbstractStructBase
{
    /**
     * The RecpName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование получателя | Наименование получателя (взыскателя) для указания в платежном документе | Строка длиной от 1 до 160
     * символов
     * - maxLength: 160
     * - minLength: 1
     * @var string
     */
    public $RecpName;
    /**
     * The RecpBank
     * Meta informations extracted from the WSDL
     * - documentation: Банк получателя (взыскателя) | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $RecpBank;
    /**
     * The RecpBIK
     * Meta informations extracted from the WSDL
     * - documentation: БИК банка получателя (взыскателя) | Банковский идентификационный код (БИК)
     * - length: 9
     * - pattern: [0-9]{9}
     * @var string
     */
    public $RecpBIK;
    /**
     * The RecpCnt
     * Meta informations extracted from the WSDL
     * - documentation: Расчетный счет получателя (взыскателя) | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $RecpCnt;
    /**
     * The RecpINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН получателя (взыскателя) | ИНН юридического лица
     * - minOccurs: 0
     * - length: 10
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}
     * @var string
     */
    public $RecpINN;
    /**
     * The RecpKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП получателя (взыскателя) | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $RecpKPP;
    /**
     * The Okato
     * Meta informations extracted from the WSDL
     * - documentation: ОКАТО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - length: 11
     * - pattern: [0-9]{11}
     * @var string
     */
    public $Okato;
    /**
     * The Oktmo
     * Meta informations extracted from the WSDL
     * - documentation: ОКТМО | Код объекта административно- территориального деления
     * - minOccurs: 0
     * - maxLength: 11
     * - minLength: 8
     * - pattern: ([0-9]{8})|([0-9]{11})
     * @var string
     */
    public $Oktmo;
    /**
     * The Kbk
     * Meta informations extracted from the WSDL
     * - documentation: КБК | Код бюджетной классификации (КБК)
     * - minOccurs: 0
     * - length: 20
     * - pattern: [0-9]{20}
     * @var string
     */
    public $Kbk;
    /**
     * The PersonalAccount
     * Meta informations extracted from the WSDL
     * - documentation: Лицевой счет | Лицевой счет
     * - minOccurs: 0
     * - length: 11
     * @var string
     */
    public $PersonalAccount;
    /**
     * The UNIFOCode
     * Meta informations extracted from the WSDL
     * - documentation: Код начисления УНИФО | Заполняется в том случае, если данная сумма зарегистрирована как начисление в системе УНИФО | Код
     * начисления УНИФО
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 20
     * - pattern: (([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]
     * @var string
     */
    public $UNIFOCode;
    /**
     * The PokPl
     * Meta informations extracted from the WSDL
     * - documentation: Показатель типа платежа | В соответствии с приказом Минфина №107н от 12.11.2013 | Показатель типа платежа | ATTR_PAYMENT_TYPE (Приказ Минфина
     * №107н от 12.11.2013)
     * - minOccurs: 0
     * - maxLength: 2
     * - minLength: 1
     * @var string
     */
    public $PokPl;
    /**
     * The RekvSum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма, перечисляемая по данным реквизитам | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $RekvSum;
    /**
     * Constructor method for PaymentProperties
     * @uses PaymentProperties::setRecpName()
     * @uses PaymentProperties::setRecpBank()
     * @uses PaymentProperties::setRecpBIK()
     * @uses PaymentProperties::setRecpCnt()
     * @uses PaymentProperties::setRecpINN()
     * @uses PaymentProperties::setRecpKPP()
     * @uses PaymentProperties::setOkato()
     * @uses PaymentProperties::setOktmo()
     * @uses PaymentProperties::setKbk()
     * @uses PaymentProperties::setPersonalAccount()
     * @uses PaymentProperties::setUNIFOCode()
     * @uses PaymentProperties::setPokPl()
     * @uses PaymentProperties::setRekvSum()
     * @param string $recpName
     * @param string $recpBank
     * @param string $recpBIK
     * @param string $recpCnt
     * @param string $recpINN
     * @param string $recpKPP
     * @param string $okato
     * @param string $oktmo
     * @param string $kbk
     * @param string $personalAccount
     * @param string $uNIFOCode
     * @param string $pokPl
     * @param float $rekvSum
     */
    public function __construct($recpName = null, $recpBank = null, $recpBIK = null, $recpCnt = null, $recpINN = null, $recpKPP = null, $okato = null, $oktmo = null, $kbk = null, $personalAccount = null, $uNIFOCode = null, $pokPl = null, $rekvSum = null)
    {
        $this
            ->setRecpName($recpName)
            ->setRecpBank($recpBank)
            ->setRecpBIK($recpBIK)
            ->setRecpCnt($recpCnt)
            ->setRecpINN($recpINN)
            ->setRecpKPP($recpKPP)
            ->setOkato($okato)
            ->setOktmo($oktmo)
            ->setKbk($kbk)
            ->setPersonalAccount($personalAccount)
            ->setUNIFOCode($uNIFOCode)
            ->setPokPl($pokPl)
            ->setRekvSum($rekvSum);
    }
    /**
     * Get RecpName value
     * @return string|null
     */
    public function getRecpName()
    {
        return $this->RecpName;
    }
    /**
     * Set RecpName value
     * @param string $recpName
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setRecpName($recpName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($recpName) && strlen($recpName) > 160) || (is_array($recpName) && count($recpName) > 160)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 160 element(s) or a scalar of 160 character(s) at most, "%d" length given', is_scalar($recpName) ? strlen($recpName) : count($recpName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recpName) && strlen($recpName) < 1) || (is_array($recpName) && count($recpName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpName) && !is_string($recpName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpName)), __LINE__);
        }
        $this->RecpName = $recpName;
        return $this;
    }
    /**
     * Get RecpBank value
     * @return string|null
     */
    public function getRecpBank()
    {
        return $this->RecpBank;
    }
    /**
     * Set RecpBank value
     * @param string $recpBank
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setRecpBank($recpBank = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($recpBank) && strlen($recpBank) > 300) || (is_array($recpBank) && count($recpBank) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($recpBank) ? strlen($recpBank) : count($recpBank)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recpBank) && strlen($recpBank) < 1) || (is_array($recpBank) && count($recpBank) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpBank) && !is_string($recpBank)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpBank)), __LINE__);
        }
        $this->RecpBank = $recpBank;
        return $this;
    }
    /**
     * Get RecpBIK value
     * @return string|null
     */
    public function getRecpBIK()
    {
        return $this->RecpBIK;
    }
    /**
     * Set RecpBIK value
     * @param string $recpBIK
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setRecpBIK($recpBIK = null)
    {
        // validation for constraint: length
        if ((is_scalar($recpBIK) && strlen($recpBIK) !== 9) || (is_array($recpBIK) && count($recpBIK) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($recpBIK) && !preg_match('/[0-9]{9}/', $recpBIK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{9}", "%s" given', var_export($recpBIK, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpBIK) && !is_string($recpBIK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpBIK)), __LINE__);
        }
        $this->RecpBIK = $recpBIK;
        return $this;
    }
    /**
     * Get RecpCnt value
     * @return string|null
     */
    public function getRecpCnt()
    {
        return $this->RecpCnt;
    }
    /**
     * Set RecpCnt value
     * @param string $recpCnt
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setRecpCnt($recpCnt = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($recpCnt) && strlen($recpCnt) > 20) || (is_array($recpCnt) && count($recpCnt) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($recpCnt) ? strlen($recpCnt) : count($recpCnt)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($recpCnt) && strlen($recpCnt) < 1) || (is_array($recpCnt) && count($recpCnt) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpCnt) && !is_string($recpCnt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpCnt)), __LINE__);
        }
        $this->RecpCnt = $recpCnt;
        return $this;
    }
    /**
     * Get RecpINN value
     * @return string|null
     */
    public function getRecpINN()
    {
        return $this->RecpINN;
    }
    /**
     * Set RecpINN value
     * @param string $recpINN
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setRecpINN($recpINN = null)
    {
        // validation for constraint: length
        if ((is_scalar($recpINN) && strlen($recpINN) !== 10) || (is_array($recpINN) && count($recpINN) !== 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($recpINN) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}/', $recpINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8}", "%s" given', var_export($recpINN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpINN) && !is_string($recpINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpINN)), __LINE__);
        }
        $this->RecpINN = $recpINN;
        return $this;
    }
    /**
     * Get RecpKPP value
     * @return string|null
     */
    public function getRecpKPP()
    {
        return $this->RecpKPP;
    }
    /**
     * Set RecpKPP value
     * @param string $recpKPP
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setRecpKPP($recpKPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($recpKPP) && strlen($recpKPP) !== 9) || (is_array($recpKPP) && count($recpKPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($recpKPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $recpKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($recpKPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($recpKPP) && !is_string($recpKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($recpKPP)), __LINE__);
        }
        $this->RecpKPP = $recpKPP;
        return $this;
    }
    /**
     * Get Okato value
     * @return string|null
     */
    public function getOkato()
    {
        return $this->Okato;
    }
    /**
     * Set Okato value
     * @param string $okato
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setOkato($okato = null)
    {
        // validation for constraint: length
        if ((is_scalar($okato) && strlen($okato) !== 11) || (is_array($okato) && count($okato) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($okato) && !preg_match('/[0-9]{11}/', $okato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{11}", "%s" given', var_export($okato, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($okato) && !is_string($okato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($okato)), __LINE__);
        }
        $this->Okato = $okato;
        return $this;
    }
    /**
     * Get Oktmo value
     * @return string|null
     */
    public function getOktmo()
    {
        return $this->Oktmo;
    }
    /**
     * Set Oktmo value
     * @param string $oktmo
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setOktmo($oktmo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oktmo) && strlen($oktmo) > 11) || (is_array($oktmo) && count($oktmo) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($oktmo) ? strlen($oktmo) : count($oktmo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oktmo) && strlen($oktmo) < 8) || (is_array($oktmo) && count($oktmo) < 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oktmo) && !preg_match('/([0-9]{8})|([0-9]{11})/', $oktmo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{8})|([0-9]{11})", "%s" given', var_export($oktmo, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oktmo) && !is_string($oktmo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oktmo)), __LINE__);
        }
        $this->Oktmo = $oktmo;
        return $this;
    }
    /**
     * Get Kbk value
     * @return string|null
     */
    public function getKbk()
    {
        return $this->Kbk;
    }
    /**
     * Set Kbk value
     * @param string $kbk
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setKbk($kbk = null)
    {
        // validation for constraint: length
        if ((is_scalar($kbk) && strlen($kbk) !== 20) || (is_array($kbk) && count($kbk) !== 20)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($kbk) && !preg_match('/[0-9]{20}/', $kbk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{20}", "%s" given', var_export($kbk, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kbk) && !is_string($kbk)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kbk)), __LINE__);
        }
        $this->Kbk = $kbk;
        return $this;
    }
    /**
     * Get PersonalAccount value
     * @return string|null
     */
    public function getPersonalAccount()
    {
        return $this->PersonalAccount;
    }
    /**
     * Set PersonalAccount value
     * @param string $personalAccount
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setPersonalAccount($personalAccount = null)
    {
        // validation for constraint: length
        if ((is_scalar($personalAccount) && strlen($personalAccount) !== 11) || (is_array($personalAccount) && count($personalAccount) !== 11)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($personalAccount) && !is_string($personalAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($personalAccount)), __LINE__);
        }
        $this->PersonalAccount = $personalAccount;
        return $this;
    }
    /**
     * Get UNIFOCode value
     * @return string|null
     */
    public function getUNIFOCode()
    {
        return $this->UNIFOCode;
    }
    /**
     * Set UNIFOCode value
     * @param string $uNIFOCode
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setUNIFOCode($uNIFOCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uNIFOCode) && strlen($uNIFOCode) > 25) || (is_array($uNIFOCode) && count($uNIFOCode) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($uNIFOCode) ? strlen($uNIFOCode) : count($uNIFOCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($uNIFOCode) && strlen($uNIFOCode) < 20) || (is_array($uNIFOCode) && count($uNIFOCode) < 20)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($uNIFOCode) && !preg_match('/(([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]/', $uNIFOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]", "%s" given', var_export($uNIFOCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uNIFOCode) && !is_string($uNIFOCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uNIFOCode)), __LINE__);
        }
        $this->UNIFOCode = $uNIFOCode;
        return $this;
    }
    /**
     * Get PokPl value
     * @return string|null
     */
    public function getPokPl()
    {
        return $this->PokPl;
    }
    /**
     * Set PokPl value
     * @param string $pokPl
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setPokPl($pokPl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($pokPl) && strlen($pokPl) > 2) || (is_array($pokPl) && count($pokPl) > 2)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s) at most, "%d" length given', is_scalar($pokPl) ? strlen($pokPl) : count($pokPl)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($pokPl) && strlen($pokPl) < 1) || (is_array($pokPl) && count($pokPl) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($pokPl) && !is_string($pokPl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pokPl)), __LINE__);
        }
        $this->PokPl = $pokPl;
        return $this;
    }
    /**
     * Get RekvSum value
     * @return float|null
     */
    public function getRekvSum()
    {
        return $this->RekvSum;
    }
    /**
     * Set RekvSum value
     * @param float $rekvSum
     * @return \AisFssp\StructType\PaymentProperties
     */
    public function setRekvSum($rekvSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($rekvSum) && strlen(substr($rekvSum, strpos($rekvSum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($rekvSum, strpos($rekvSum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($rekvSum) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $rekvSum)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($rekvSum, strpos($rekvSum, '.')))), __LINE__);
        }
        $this->RekvSum = $rekvSum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\PaymentProperties
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
