<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentNotification StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ PaymentNotification «Уведомление о платеже»
 * - type: tns:PaymentNotification
 * @subpackage Structs
 */
class PaymentNotification extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The BillNumber
     * Meta informations extracted from the WSDL
     * - documentation: УИН начисления | Код начисления УНИФО
     * - maxLength: 25
     * - minLength: 20
     * - pattern: (([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]
     * @var string
     */
    public $BillNumber;
    /**
     * The PaymentId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор транзакции | Строка длиной от 1 до 12 символов
     * - maxLength: 12
     * - minLength: 1
     * @var string
     */
    public $PaymentId;
    /**
     * The PaymentStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус платежа | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $PaymentStatus;
    /**
     * The IsPayed
     * Meta informations extracted from the WSDL
     * - documentation: Признак успешной оплаты платежа | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsPayed;
    /**
     * The PaymentDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время платежа | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $PaymentDate;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма платежа | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for PaymentNotification
     * @uses PaymentNotification::setExternalKey()
     * @uses PaymentNotification::setBillNumber()
     * @uses PaymentNotification::setPaymentId()
     * @uses PaymentNotification::setPaymentStatus()
     * @uses PaymentNotification::setIsPayed()
     * @uses PaymentNotification::setPaymentDate()
     * @uses PaymentNotification::setAmount()
     * @param string $externalKey
     * @param string $billNumber
     * @param string $paymentId
     * @param string $paymentStatus
     * @param bool $isPayed
     * @param string $paymentDate
     * @param float $amount
     */
    public function __construct($externalKey = null, $billNumber = null, $paymentId = null, $paymentStatus = null, $isPayed = null, $paymentDate = null, $amount = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setBillNumber($billNumber)
            ->setPaymentId($paymentId)
            ->setPaymentStatus($paymentStatus)
            ->setIsPayed($isPayed)
            ->setPaymentDate($paymentDate)
            ->setAmount($amount);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\PaymentNotification
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get BillNumber value
     * @return string|null
     */
    public function getBillNumber()
    {
        return $this->BillNumber;
    }
    /**
     * Set BillNumber value
     * @param string $billNumber
     * @return \AisFssp\StructType\PaymentNotification
     */
    public function setBillNumber($billNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($billNumber) && strlen($billNumber) > 25) || (is_array($billNumber) && count($billNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($billNumber) ? strlen($billNumber) : count($billNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($billNumber) && strlen($billNumber) < 20) || (is_array($billNumber) && count($billNumber) < 20)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($billNumber) && !preg_match('/(([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]/', $billNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9a-zA-Zа-яА-Я]{19})|([0-9]{8}[0-9a-zA-Zа-яА-Я]{16}))[0-9]", "%s" given', var_export($billNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($billNumber) && !is_string($billNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billNumber)), __LINE__);
        }
        $this->BillNumber = $billNumber;
        return $this;
    }
    /**
     * Get PaymentId value
     * @return string|null
     */
    public function getPaymentId()
    {
        return $this->PaymentId;
    }
    /**
     * Set PaymentId value
     * @param string $paymentId
     * @return \AisFssp\StructType\PaymentNotification
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($paymentId) && strlen($paymentId) > 12) || (is_array($paymentId) && count($paymentId) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($paymentId) ? strlen($paymentId) : count($paymentId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($paymentId) && strlen($paymentId) < 1) || (is_array($paymentId) && count($paymentId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paymentId) && !is_string($paymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentId)), __LINE__);
        }
        $this->PaymentId = $paymentId;
        return $this;
    }
    /**
     * Get PaymentStatus value
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->PaymentStatus;
    }
    /**
     * Set PaymentStatus value
     * @param string $paymentStatus
     * @return \AisFssp\StructType\PaymentNotification
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($paymentStatus) && strlen($paymentStatus) > 20) || (is_array($paymentStatus) && count($paymentStatus) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($paymentStatus) ? strlen($paymentStatus) : count($paymentStatus)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($paymentStatus) && strlen($paymentStatus) < 1) || (is_array($paymentStatus) && count($paymentStatus) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paymentStatus) && !is_string($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentStatus)), __LINE__);
        }
        $this->PaymentStatus = $paymentStatus;
        return $this;
    }
    /**
     * Get IsPayed value
     * @return bool|null
     */
    public function getIsPayed()
    {
        return $this->IsPayed;
    }
    /**
     * Set IsPayed value
     * @param bool $isPayed
     * @return \AisFssp\StructType\PaymentNotification
     */
    public function setIsPayed($isPayed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPayed) && !is_bool($isPayed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPayed)), __LINE__);
        }
        $this->IsPayed = $isPayed;
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \AisFssp\StructType\PaymentNotification
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: maxExclusive
        if ($paymentDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $paymentDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($paymentDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $paymentDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \AisFssp\StructType\PaymentNotification
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($amount) && strlen(substr($amount, strpos($amount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($amount, strpos($amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($amount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $amount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($amount, strpos($amount, '.')))), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\PaymentNotification
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
