<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о платежах
 * @subpackage Structs
 */
class PaymentDatumType extends InformationType
{
    /**
     * The contactTelephone
     * Meta informations extracted from the WSDL
     * - documentation: Контактный телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $contactTelephone;
    /**
     * The beginDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата начала периода | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $beginDate;
    /**
     * The endDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания периода (включительно) | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $endDate;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - documentation: Код валюты | Согласно справочнику кодов валют | Валюта | Код валюты по общероссийскому классификатору валют. В случае
     * отсутствия значения кода в общероссийском классификаторе валют - используется значение из Классификатора клиринговых валют.
     * - length: 3
     * - pattern: [0-9a-zA-Zа-яА-Я]{1}[0-9]{2}
     * @var string
     */
    public $currency;
    /**
     * The paymentAmount
     * Meta informations extracted from the WSDL
     * - documentation: Сумма платежей | За 2 месяца по всем номерам телефонов. Значение меньше 1 => 0.53 (53 копейки) | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $paymentAmount;
    /**
     * Constructor method for PaymentDatumType
     * @uses PaymentDatumType::setContactTelephone()
     * @uses PaymentDatumType::setBeginDate()
     * @uses PaymentDatumType::setEndDate()
     * @uses PaymentDatumType::setCurrency()
     * @uses PaymentDatumType::setPaymentAmount()
     * @param string $contactTelephone
     * @param string $beginDate
     * @param string $endDate
     * @param string $currency
     * @param float $paymentAmount
     */
    public function __construct($contactTelephone = null, $beginDate = null, $endDate = null, $currency = null, $paymentAmount = null)
    {
        $this
            ->setContactTelephone($contactTelephone)
            ->setBeginDate($beginDate)
            ->setEndDate($endDate)
            ->setCurrency($currency)
            ->setPaymentAmount($paymentAmount);
    }
    /**
     * Get contactTelephone value
     * @return string|null
     */
    public function getContactTelephone()
    {
        return $this->contactTelephone;
    }
    /**
     * Set contactTelephone value
     * @param string $contactTelephone
     * @return \AisFssp\StructType\PaymentDatumType
     */
    public function setContactTelephone($contactTelephone = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($contactTelephone) && strlen($contactTelephone) > 25) || (is_array($contactTelephone) && count($contactTelephone) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($contactTelephone) ? strlen($contactTelephone) : count($contactTelephone)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($contactTelephone) && strlen($contactTelephone) < 1) || (is_array($contactTelephone) && count($contactTelephone) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contactTelephone) && !is_string($contactTelephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactTelephone)), __LINE__);
        }
        $this->contactTelephone = $contactTelephone;
        return $this;
    }
    /**
     * Get beginDate value
     * @return string|null
     */
    public function getBeginDate()
    {
        return $this->beginDate;
    }
    /**
     * Set beginDate value
     * @param string $beginDate
     * @return \AisFssp\StructType\PaymentDatumType
     */
    public function setBeginDate($beginDate = null)
    {
        // validation for constraint: maxExclusive
        if ($beginDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $beginDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($beginDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $beginDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($beginDate) && !is_string($beginDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($beginDate)), __LINE__);
        }
        $this->beginDate = $beginDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \AisFssp\StructType\PaymentDatumType
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: maxExclusive
        if ($endDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($endDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $endDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \AisFssp\StructType\PaymentDatumType
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: length
        if ((is_scalar($currency) && strlen($currency) !== 3) || (is_array($currency) && count($currency) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($currency) && !preg_match('/[0-9a-zA-Zа-яА-Я]{1}[0-9]{2}/', $currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9a-zA-Zа-яА-Я]{1}[0-9]{2}", "%s" given', var_export($currency, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get paymentAmount value
     * @return float|null
     */
    public function getPaymentAmount()
    {
        return $this->paymentAmount;
    }
    /**
     * Set paymentAmount value
     * @param float $paymentAmount
     * @return \AisFssp\StructType\PaymentDatumType
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paymentAmount) && strlen(substr($paymentAmount, strpos($paymentAmount, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paymentAmount, strpos($paymentAmount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($paymentAmount) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $paymentAmount)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($paymentAmount, strpos($paymentAmount, '.')))), __LINE__);
        }
        $this->paymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\PaymentDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
