<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutgoingForcedExecDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Исходящий документ принудительного исполнения | используется для передачи документов внешним контрагентам
 * - type: tns:OutgoingForcedExecDocument
 * @subpackage Structs
 */
class OutgoingForcedExecDocument extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа в АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или
     * при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The IncomingDocKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор входящего документа | Идентификатор документа, направленного ранее внешним контрагентов в АИС ФССП России.
     * Обязательно, если документ направляется в ответ на ранее принятый от внешнего контрагента документ | Идентификатор объекта,
     * присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IncomingDocKey;
    /**
     * The ProcDocRef
     * Meta informations extracted from the WSDL
     * - documentation: Постановление СПИ | Обязательно для документов: - Уведомление о готовности к реализации арестованного имущества.
     * - minOccurs: 0
     * @var \AisFssp\StructType\DocRefType
     */
    public $ProcDocRef;
    /**
     * The SenderProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты СПИ
     * - minOccurs: 0
     * @var \AisFssp\StructType\SenderSPIType
     */
    public $SenderProperties;
    /**
     * The RejectReason
     * Meta informations extracted from the WSDL
     * - documentation: Причина отказа | Обязательно для документа: Уведомления об отказе в предоставлении гос.услуги
     * - minOccurs: 0
     * @var string
     */
    public $RejectReason;
    /**
     * The IP
     * Meta informations extracted from the WSDL
     * - documentation: Исполнительное производство
     * - minOccurs: 0
     * @var \AisFssp\StructType\IP
     */
    public $IP;
    /**
     * The DocumentData
     * Meta informations extracted from the WSDL
     * - documentation: Документ в формате ПИЭВ
     * @var \AisFssp\StructType\EmbeddedDocumentType
     */
    public $DocumentData;
    /**
     * Constructor method for OutgoingForcedExecDocument
     * @uses OutgoingForcedExecDocument::setInternalKey()
     * @uses OutgoingForcedExecDocument::setIncomingDocKey()
     * @uses OutgoingForcedExecDocument::setProcDocRef()
     * @uses OutgoingForcedExecDocument::setSenderProperties()
     * @uses OutgoingForcedExecDocument::setRejectReason()
     * @uses OutgoingForcedExecDocument::setIP()
     * @uses OutgoingForcedExecDocument::setDocumentData()
     * @param int $internalKey
     * @param string $incomingDocKey
     * @param \AisFssp\StructType\DocRefType $procDocRef
     * @param \AisFssp\StructType\SenderSPIType $senderProperties
     * @param string $rejectReason
     * @param \AisFssp\StructType\IP $iP
     * @param \AisFssp\StructType\EmbeddedDocumentType $documentData
     */
    public function __construct($internalKey = null, $incomingDocKey = null, \AisFssp\StructType\DocRefType $procDocRef = null, \AisFssp\StructType\SenderSPIType $senderProperties = null, $rejectReason = null, \AisFssp\StructType\IP $iP = null, \AisFssp\StructType\EmbeddedDocumentType $documentData = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setIncomingDocKey($incomingDocKey)
            ->setProcDocRef($procDocRef)
            ->setSenderProperties($senderProperties)
            ->setRejectReason($rejectReason)
            ->setIP($iP)
            ->setDocumentData($documentData);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\OutgoingForcedExecDocument
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get IncomingDocKey value
     * @return string|null
     */
    public function getIncomingDocKey()
    {
        return $this->IncomingDocKey;
    }
    /**
     * Set IncomingDocKey value
     * @param string $incomingDocKey
     * @return \AisFssp\StructType\OutgoingForcedExecDocument
     */
    public function setIncomingDocKey($incomingDocKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($incomingDocKey) && strlen($incomingDocKey) > 60) || (is_array($incomingDocKey) && count($incomingDocKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($incomingDocKey) ? strlen($incomingDocKey) : count($incomingDocKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($incomingDocKey) && strlen($incomingDocKey) < 1) || (is_array($incomingDocKey) && count($incomingDocKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($incomingDocKey) && !is_string($incomingDocKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($incomingDocKey)), __LINE__);
        }
        $this->IncomingDocKey = $incomingDocKey;
        return $this;
    }
    /**
     * Get ProcDocRef value
     * @return \AisFssp\StructType\DocRefType|null
     */
    public function getProcDocRef()
    {
        return $this->ProcDocRef;
    }
    /**
     * Set ProcDocRef value
     * @param \AisFssp\StructType\DocRefType $procDocRef
     * @return \AisFssp\StructType\OutgoingForcedExecDocument
     */
    public function setProcDocRef(\AisFssp\StructType\DocRefType $procDocRef = null)
    {
        $this->ProcDocRef = $procDocRef;
        return $this;
    }
    /**
     * Get SenderProperties value
     * @return \AisFssp\StructType\SenderSPIType|null
     */
    public function getSenderProperties()
    {
        return $this->SenderProperties;
    }
    /**
     * Set SenderProperties value
     * @param \AisFssp\StructType\SenderSPIType $senderProperties
     * @return \AisFssp\StructType\OutgoingForcedExecDocument
     */
    public function setSenderProperties(\AisFssp\StructType\SenderSPIType $senderProperties = null)
    {
        $this->SenderProperties = $senderProperties;
        return $this;
    }
    /**
     * Get RejectReason value
     * @return string|null
     */
    public function getRejectReason()
    {
        return $this->RejectReason;
    }
    /**
     * Set RejectReason value
     * @uses \AisFssp\EnumType\RejectReasonType::valueIsValid()
     * @uses \AisFssp\EnumType\RejectReasonType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rejectReason
     * @return \AisFssp\StructType\OutgoingForcedExecDocument
     */
    public function setRejectReason($rejectReason = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\RejectReasonType::valueIsValid($rejectReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rejectReason, implode(', ', \AisFssp\EnumType\RejectReasonType::getValidValues())), __LINE__);
        }
        $this->RejectReason = $rejectReason;
        return $this;
    }
    /**
     * Get IP value
     * @return \AisFssp\StructType\IP|null
     */
    public function getIP()
    {
        return $this->IP;
    }
    /**
     * Set IP value
     * @param \AisFssp\StructType\IP $iP
     * @return \AisFssp\StructType\OutgoingForcedExecDocument
     */
    public function setIP(\AisFssp\StructType\IP $iP = null)
    {
        $this->IP = $iP;
        return $this;
    }
    /**
     * Get DocumentData value
     * @return \AisFssp\StructType\EmbeddedDocumentType|null
     */
    public function getDocumentData()
    {
        return $this->DocumentData;
    }
    /**
     * Set DocumentData value
     * @param \AisFssp\StructType\EmbeddedDocumentType $documentData
     * @return \AisFssp\StructType\OutgoingForcedExecDocument
     */
    public function setDocumentData(\AisFssp\StructType\EmbeddedDocumentType $documentData = null)
    {
        $this->DocumentData = $documentData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\OutgoingForcedExecDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
