<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutgoingArbitraryDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на электронное обращение
 * - type: tns:OutgoingArbitraryDocument
 * @subpackage Structs
 */
class OutgoingArbitraryDocument extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа в АИС ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или
     * при получении объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The IncomingDocKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор входящего документа | Идентификатор документа, направленного ранее внешним контрагентов в АИС ФССП России.
     * Обязательно, если документ направляется в ответ на ранее принятый от внешнего контрагента документ | Идентификатор объекта,
     * присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа
     * идентифицируемого документа в пространстве обмена данными с конкретным внешним контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IncomingDocKey;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - minOccurs: 0
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $DocType;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Описание документа | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $Description;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The SenderProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты СПИ
     * - minOccurs: 0
     * @var \AisFssp\StructType\SenderContragentType
     */
    public $SenderProperties;
    /**
     * The Attachments
     * Meta informations extracted from the WSDL
     * - documentation: Вложения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $Attachments;
    /**
     * Constructor method for OutgoingArbitraryDocument
     * @uses OutgoingArbitraryDocument::setInternalKey()
     * @uses OutgoingArbitraryDocument::setIncomingDocKey()
     * @uses OutgoingArbitraryDocument::setDocType()
     * @uses OutgoingArbitraryDocument::setDescription()
     * @uses OutgoingArbitraryDocument::setDocDate()
     * @uses OutgoingArbitraryDocument::setDocNumber()
     * @uses OutgoingArbitraryDocument::setSenderProperties()
     * @uses OutgoingArbitraryDocument::setAttachments()
     * @param int $internalKey
     * @param string $incomingDocKey
     * @param string $docType
     * @param string $description
     * @param string $docDate
     * @param string $docNumber
     * @param \AisFssp\StructType\SenderContragentType $senderProperties
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     */
    public function __construct($internalKey = null, $incomingDocKey = null, $docType = null, $description = null, $docDate = null, $docNumber = null, \AisFssp\StructType\SenderContragentType $senderProperties = null, array $attachments = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setIncomingDocKey($incomingDocKey)
            ->setDocType($docType)
            ->setDescription($description)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setSenderProperties($senderProperties)
            ->setAttachments($attachments);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\OutgoingArbitraryDocument
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get IncomingDocKey value
     * @return string|null
     */
    public function getIncomingDocKey()
    {
        return $this->IncomingDocKey;
    }
    /**
     * Set IncomingDocKey value
     * @param string $incomingDocKey
     * @return \AisFssp\StructType\OutgoingArbitraryDocument
     */
    public function setIncomingDocKey($incomingDocKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($incomingDocKey) && strlen($incomingDocKey) > 60) || (is_array($incomingDocKey) && count($incomingDocKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($incomingDocKey) ? strlen($incomingDocKey) : count($incomingDocKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($incomingDocKey) && strlen($incomingDocKey) < 1) || (is_array($incomingDocKey) && count($incomingDocKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($incomingDocKey) && !is_string($incomingDocKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($incomingDocKey)), __LINE__);
        }
        $this->IncomingDocKey = $incomingDocKey;
        return $this;
    }
    /**
     * Get DocType value
     * @return string|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @param string $docType
     * @return \AisFssp\StructType\OutgoingArbitraryDocument
     */
    public function setDocType($docType = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docType) && strlen($docType) > 1) || (is_array($docType) && count($docType) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($docType) ? strlen($docType) : count($docType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docType) && strlen($docType) < 1) || (is_array($docType) && count($docType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docType) && !is_string($docType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docType)), __LINE__);
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \AisFssp\StructType\OutgoingArbitraryDocument
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 50) || (is_array($description) && count($description) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($description) && strlen($description) < 1) || (is_array($description) && count($description) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\OutgoingArbitraryDocument
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\OutgoingArbitraryDocument
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get SenderProperties value
     * @return \AisFssp\StructType\SenderContragentType|null
     */
    public function getSenderProperties()
    {
        return $this->SenderProperties;
    }
    /**
     * Set SenderProperties value
     * @param \AisFssp\StructType\SenderContragentType $senderProperties
     * @return \AisFssp\StructType\OutgoingArbitraryDocument
     */
    public function setSenderProperties(\AisFssp\StructType\SenderContragentType $senderProperties = null)
    {
        $this->SenderProperties = $senderProperties;
        return $this;
    }
    /**
     * Get Attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->Attachments;
    }
    /**
     * Set Attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\OutgoingArbitraryDocument
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $outgoingArbitraryDocumentAttachmentsItem) {
            // validation for constraint: itemType
            if (!$outgoingArbitraryDocumentAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The Attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($outgoingArbitraryDocumentAttachmentsItem) ? get_class($outgoingArbitraryDocumentAttachmentsItem) : gettype($outgoingArbitraryDocumentAttachmentsItem)), __LINE__);
            }
        }
        $this->Attachments = $attachments;
        return $this;
    }
    /**
     * Add item to Attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\OutgoingArbitraryDocument
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The Attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Attachments[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\OutgoingArbitraryDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
