<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OkvedDetailType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о видах экономической деятельности
 * @subpackage Structs
 */
class OkvedDetailType extends AbstractStructBase
{
    /**
     * The OKVED
     * Meta informations extracted from the WSDL
     * - documentation: Kод ОКВЭД | Код вида экономической деятельности
     * - length: 8
     * - pattern: [0-9]{8}
     * @var string
     */
    public $OKVED;
    /**
     * The isMain
     * Meta informations extracted from the WSDL
     * - documentation: Признак основного вида деятельности
     * @var string
     */
    public $isMain;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида деятельности | Строка длиной от 1 до 80 символов
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * Constructor method for OkvedDetailType
     * @uses OkvedDetailType::setOKVED()
     * @uses OkvedDetailType::setIsMain()
     * @uses OkvedDetailType::setName()
     * @param string $oKVED
     * @param string $isMain
     * @param string $name
     */
    public function __construct($oKVED = null, $isMain = null, $name = null)
    {
        $this
            ->setOKVED($oKVED)
            ->setIsMain($isMain)
            ->setName($name);
    }
    /**
     * Get OKVED value
     * @return string|null
     */
    public function getOKVED()
    {
        return $this->OKVED;
    }
    /**
     * Set OKVED value
     * @param string $oKVED
     * @return \AisFssp\StructType\OkvedDetailType
     */
    public function setOKVED($oKVED = null)
    {
        // validation for constraint: length
        if ((is_scalar($oKVED) && strlen($oKVED) !== 8) || (is_array($oKVED) && count($oKVED) !== 8)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($oKVED) && !preg_match('/[0-9]{8}/', $oKVED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{8}", "%s" given', var_export($oKVED, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKVED) && !is_string($oKVED)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKVED)), __LINE__);
        }
        $this->OKVED = $oKVED;
        return $this;
    }
    /**
     * Get isMain value
     * @return string|null
     */
    public function getIsMain()
    {
        return $this->isMain;
    }
    /**
     * Set isMain value
     * @uses \AisFssp\EnumType\OkvedIsMainType::valueIsValid()
     * @uses \AisFssp\EnumType\OkvedIsMainType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $isMain
     * @return \AisFssp\StructType\OkvedDetailType
     */
    public function setIsMain($isMain = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\OkvedIsMainType::valueIsValid($isMain)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $isMain, implode(', ', \AisFssp\EnumType\OkvedIsMainType::getValidValues())), __LINE__);
        }
        $this->isMain = $isMain;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \AisFssp\StructType\OkvedDetailType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 80) || (is_array($name) && count($name) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\OkvedDetailType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
