<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NoticeSaleSeizedProperty StructType
 * Meta informations extracted from the WSDL
 * - documentation: Уведомление о реализации арестованного имущества | ЭП
 * - type: tns:NoticeSaleSeizedProperty
 * @subpackage Structs
 */
class NoticeSaleSeizedProperty extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор документа, присвоенный АИС внешнего контрагента. | Идентификатор объекта, присвоенный
     * объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа
     * в пространстве обмена данными с конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The NoticeNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер уведомления | Номер уведомления о готовности к реализации арестованного имущества. | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $NoticeNum;
    /**
     * The NoticeDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата уведомления | Дата уведомления о готовности к реализации арестованного имущества. | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $NoticeDate;
    /**
     * The ProcDocId
     * Meta informations extracted from the WSDL
     * - documentation: Ключ постановления | Ключ постановления судебного пристава-исполнителя о передачи арестованного имущества должника на
     * реализацию. | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $ProcDocId;
    /**
     * The NoticeSaleSeizedPropertyBase
     * Meta informations extracted from the WSDL
     * - documentation: Уведомление | Оригинал уведомления о реализации арестованного имущества вынесенного в электронном виде согласно формату
     * Приложения № X «Формат постановления должностного лица ФССП России, выданного в виде электронного документа, юридическая значимость
     * которого подтверждена электронной подписью в порядке, установленном законодательством Российской Федерации» в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $NoticeSaleSeizedPropertyBase;
    /**
     * The SignatureNoticeSaleSeizedPropertyBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП уведомления | ЭП уведомления о готовности к реализации арестованного имущества вынесенного в электронном виде, элемента
     * «NoticeSaleSeizedPropertyBase» в формате pkcs#7, в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $SignatureNoticeSaleSeizedPropertyBase;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Приложенные файлы | Дополнительные данные в произвольных форматах.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for NoticeSaleSeizedProperty
     * @uses NoticeSaleSeizedProperty::setExternalKey()
     * @uses NoticeSaleSeizedProperty::setNoticeNum()
     * @uses NoticeSaleSeizedProperty::setNoticeDate()
     * @uses NoticeSaleSeizedProperty::setProcDocId()
     * @uses NoticeSaleSeizedProperty::setNoticeSaleSeizedPropertyBase()
     * @uses NoticeSaleSeizedProperty::setSignatureNoticeSaleSeizedPropertyBase()
     * @uses NoticeSaleSeizedProperty::setAttachments()
     * @uses NoticeSaleSeizedProperty::setSignDateTime()
     * @uses NoticeSaleSeizedProperty::setSignature()
     * @param string $externalKey
     * @param string $noticeNum
     * @param string $noticeDate
     * @param int $procDocId
     * @param string $noticeSaleSeizedPropertyBase
     * @param string $signatureNoticeSaleSeizedPropertyBase
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct($externalKey = null, $noticeNum = null, $noticeDate = null, $procDocId = null, $noticeSaleSeizedPropertyBase = null, $signatureNoticeSaleSeizedPropertyBase = null, array $attachments = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setExternalKey($externalKey)
            ->setNoticeNum($noticeNum)
            ->setNoticeDate($noticeDate)
            ->setProcDocId($procDocId)
            ->setNoticeSaleSeizedPropertyBase($noticeSaleSeizedPropertyBase)
            ->setSignatureNoticeSaleSeizedPropertyBase($signatureNoticeSaleSeizedPropertyBase)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get NoticeNum value
     * @return string|null
     */
    public function getNoticeNum()
    {
        return $this->NoticeNum;
    }
    /**
     * Set NoticeNum value
     * @param string $noticeNum
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty
     */
    public function setNoticeNum($noticeNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($noticeNum) && strlen($noticeNum) > 25) || (is_array($noticeNum) && count($noticeNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($noticeNum) ? strlen($noticeNum) : count($noticeNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($noticeNum) && strlen($noticeNum) < 1) || (is_array($noticeNum) && count($noticeNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noticeNum) && !is_string($noticeNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noticeNum)), __LINE__);
        }
        $this->NoticeNum = $noticeNum;
        return $this;
    }
    /**
     * Get NoticeDate value
     * @return string|null
     */
    public function getNoticeDate()
    {
        return $this->NoticeDate;
    }
    /**
     * Set NoticeDate value
     * @param string $noticeDate
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty
     */
    public function setNoticeDate($noticeDate = null)
    {
        // validation for constraint: maxExclusive
        if ($noticeDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $noticeDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($noticeDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $noticeDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($noticeDate) && !is_string($noticeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noticeDate)), __LINE__);
        }
        $this->NoticeDate = $noticeDate;
        return $this;
    }
    /**
     * Get ProcDocId value
     * @return int|null
     */
    public function getProcDocId()
    {
        return $this->ProcDocId;
    }
    /**
     * Set ProcDocId value
     * @param int $procDocId
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty
     */
    public function setProcDocId($procDocId = null)
    {
        // validation for constraint: maxInclusive
        if ($procDocId > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $procDocId), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($procDocId < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $procDocId), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($procDocId) && !is_numeric($procDocId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($procDocId)), __LINE__);
        }
        $this->ProcDocId = $procDocId;
        return $this;
    }
    /**
     * Get NoticeSaleSeizedPropertyBase value
     * @return string|null
     */
    public function getNoticeSaleSeizedPropertyBase()
    {
        return $this->NoticeSaleSeizedPropertyBase;
    }
    /**
     * Set NoticeSaleSeizedPropertyBase value
     * @param string $noticeSaleSeizedPropertyBase
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty
     */
    public function setNoticeSaleSeizedPropertyBase($noticeSaleSeizedPropertyBase = null)
    {
        // validation for constraint: string
        if (!is_null($noticeSaleSeizedPropertyBase) && !is_string($noticeSaleSeizedPropertyBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noticeSaleSeizedPropertyBase)), __LINE__);
        }
        $this->NoticeSaleSeizedPropertyBase = $noticeSaleSeizedPropertyBase;
        return $this;
    }
    /**
     * Get SignatureNoticeSaleSeizedPropertyBase value
     * @return string|null
     */
    public function getSignatureNoticeSaleSeizedPropertyBase()
    {
        return $this->SignatureNoticeSaleSeizedPropertyBase;
    }
    /**
     * Set SignatureNoticeSaleSeizedPropertyBase value
     * @param string $signatureNoticeSaleSeizedPropertyBase
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty
     */
    public function setSignatureNoticeSaleSeizedPropertyBase($signatureNoticeSaleSeizedPropertyBase = null)
    {
        // validation for constraint: string
        if (!is_null($signatureNoticeSaleSeizedPropertyBase) && !is_string($signatureNoticeSaleSeizedPropertyBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signatureNoticeSaleSeizedPropertyBase)), __LINE__);
        }
        $this->SignatureNoticeSaleSeizedPropertyBase = $signatureNoticeSaleSeizedPropertyBase;
        return $this;
    }
    /**
     * Get attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $noticeSaleSeizedPropertyAttachmentsItem) {
            // validation for constraint: itemType
            if (!$noticeSaleSeizedPropertyAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($noticeSaleSeizedPropertyAttachmentsItem) ? get_class($noticeSaleSeizedPropertyAttachmentsItem) : gettype($noticeSaleSeizedPropertyAttachmentsItem)), __LINE__);
            }
        }
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $noticeSaleSeizedPropertySignatureItem) {
            // validation for constraint: itemType
            if (!$noticeSaleSeizedPropertySignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($noticeSaleSeizedPropertySignatureItem) ? get_class($noticeSaleSeizedPropertySignatureItem) : gettype($noticeSaleSeizedPropertySignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\NoticeSaleSeizedProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
