<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ManagementDataType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип сведений ManagementDataType "Должностные лица" | Содержит данные о должностных лицах (руководителях) организации
 * @subpackage Structs
 */
class ManagementDataType extends InformationType
{
    /**
     * The ManagerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип должностного лица | Тип должностного лица | NSI_MVV_Manager
     * - length: 2
     * - pattern: [0-9]{2}
     * @var string
     */
    public $ManagerType;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: ФИО
     * @var \AisFssp\StructType\FioType
     */
    public $Name;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Адрес проживания руководителя | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Address;
    /**
     * The TelephoneNumber
     * Meta informations extracted from the WSDL
     * - documentation: Телефон | Номер телефона
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $TelephoneNumber;
    /**
     * Constructor method for ManagementDataType
     * @uses ManagementDataType::setManagerType()
     * @uses ManagementDataType::setName()
     * @uses ManagementDataType::setAddress()
     * @uses ManagementDataType::setTelephoneNumber()
     * @param string $managerType
     * @param \AisFssp\StructType\FioType $name
     * @param string $address
     * @param string $telephoneNumber
     */
    public function __construct($managerType = null, \AisFssp\StructType\FioType $name = null, $address = null, $telephoneNumber = null)
    {
        $this
            ->setManagerType($managerType)
            ->setName($name)
            ->setAddress($address)
            ->setTelephoneNumber($telephoneNumber);
    }
    /**
     * Get ManagerType value
     * @return string|null
     */
    public function getManagerType()
    {
        return $this->ManagerType;
    }
    /**
     * Set ManagerType value
     * @param string $managerType
     * @return \AisFssp\StructType\ManagementDataType
     */
    public function setManagerType($managerType = null)
    {
        // validation for constraint: length
        if ((is_scalar($managerType) && strlen($managerType) !== 2) || (is_array($managerType) && count($managerType) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($managerType) && !preg_match('/[0-9]{2}/', $managerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{2}", "%s" given', var_export($managerType, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($managerType) && !is_string($managerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($managerType)), __LINE__);
        }
        $this->ManagerType = $managerType;
        return $this;
    }
    /**
     * Get Name value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \AisFssp\StructType\FioType $name
     * @return \AisFssp\StructType\ManagementDataType
     */
    public function setName(\AisFssp\StructType\FioType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \AisFssp\StructType\ManagementDataType
     */
    public function setAddress($address = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($address) && strlen($address) > 300) || (is_array($address) && count($address) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($address) ? strlen($address) : count($address)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($address) && strlen($address) < 1) || (is_array($address) && count($address) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return $this->TelephoneNumber;
    }
    /**
     * Set TelephoneNumber value
     * @param string $telephoneNumber
     * @return \AisFssp\StructType\ManagementDataType
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($telephoneNumber) && strlen($telephoneNumber) > 25) || (is_array($telephoneNumber) && count($telephoneNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($telephoneNumber) ? strlen($telephoneNumber) : count($telephoneNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($telephoneNumber) && strlen($telephoneNumber) < 1) || (is_array($telephoneNumber) && count($telephoneNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        $this->TelephoneNumber = $telephoneNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ManagementDataType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
