<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MailState StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ MailState "Статус корреспонденции" | «Статус корреспонденции»
 * - type: tns:MailState
 * @subpackage Structs
 */
class MailState extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: >Идентификатор, присвоенный ФГУП «Почта России» | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС,
     * ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с
     * конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата докумета | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The Barcode
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор отправления | Идентификатор отправления, присвоенный ФГУП «Почта России» | Штрих-код в формате code39
     * - maxLength: 44
     * - minLength: 1
     * - pattern: [0-9A-Z\-\.\+$/%]+
     * @var string
     */
    public $Barcode;
    /**
     * The StateDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата докумета | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $StateDate;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - documentation: Статус
     * @var string
     */
    public $State;
    /**
     * The PostOfficeCode
     * Meta informations extracted from the WSDL
     * - documentation: Индекс почтового отделения | Строка длиной от 1 до 6 символов
     * - maxLength: 6
     * - minLength: 1
     * @var string
     */
    public $PostOfficeCode;
    /**
     * The ErrorText
     * Meta informations extracted from the WSDL
     * - documentation: Сообщение об ошибке | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $ErrorText;
    /**
     * Constructor method for MailState
     * @uses MailState::setInternalKey()
     * @uses MailState::setExternalKey()
     * @uses MailState::setDocDate()
     * @uses MailState::setBarcode()
     * @uses MailState::setStateDate()
     * @uses MailState::setState()
     * @uses MailState::setPostOfficeCode()
     * @uses MailState::setErrorText()
     * @param int $internalKey
     * @param string $externalKey
     * @param string $docDate
     * @param string $barcode
     * @param string $stateDate
     * @param string $state
     * @param string $postOfficeCode
     * @param string $errorText
     */
    public function __construct($internalKey = null, $externalKey = null, $docDate = null, $barcode = null, $stateDate = null, $state = null, $postOfficeCode = null, $errorText = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setExternalKey($externalKey)
            ->setDocDate($docDate)
            ->setBarcode($barcode)
            ->setStateDate($stateDate)
            ->setState($state)
            ->setPostOfficeCode($postOfficeCode)
            ->setErrorText($errorText);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\MailState
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\MailState
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\MailState
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get Barcode value
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->Barcode;
    }
    /**
     * Set Barcode value
     * @param string $barcode
     * @return \AisFssp\StructType\MailState
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($barcode) && strlen($barcode) > 44) || (is_array($barcode) && count($barcode) > 44)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 44 element(s) or a scalar of 44 character(s) at most, "%d" length given', is_scalar($barcode) ? strlen($barcode) : count($barcode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($barcode) && strlen($barcode) < 1) || (is_array($barcode) && count($barcode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($barcode) && !preg_match('/[0-9A-Z\\-\\.\\+$\/%]+/', $barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9A-Z\-\.\+$/%]+", "%s" given', var_export($barcode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barcode)), __LINE__);
        }
        $this->Barcode = $barcode;
        return $this;
    }
    /**
     * Get StateDate value
     * @return string|null
     */
    public function getStateDate()
    {
        return $this->StateDate;
    }
    /**
     * Set StateDate value
     * @param string $stateDate
     * @return \AisFssp\StructType\MailState
     */
    public function setStateDate($stateDate = null)
    {
        // validation for constraint: maxExclusive
        if ($stateDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $stateDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($stateDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $stateDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($stateDate) && !is_string($stateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateDate)), __LINE__);
        }
        $this->StateDate = $stateDate;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @uses \AisFssp\EnumType\MailStateType::valueIsValid()
     * @uses \AisFssp\EnumType\MailStateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \AisFssp\StructType\MailState
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\MailStateType::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \AisFssp\EnumType\MailStateType::getValidValues())), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get PostOfficeCode value
     * @return string|null
     */
    public function getPostOfficeCode()
    {
        return $this->PostOfficeCode;
    }
    /**
     * Set PostOfficeCode value
     * @param string $postOfficeCode
     * @return \AisFssp\StructType\MailState
     */
    public function setPostOfficeCode($postOfficeCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($postOfficeCode) && strlen($postOfficeCode) > 6) || (is_array($postOfficeCode) && count($postOfficeCode) > 6)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 6 element(s) or a scalar of 6 character(s) at most, "%d" length given', is_scalar($postOfficeCode) ? strlen($postOfficeCode) : count($postOfficeCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($postOfficeCode) && strlen($postOfficeCode) < 1) || (is_array($postOfficeCode) && count($postOfficeCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($postOfficeCode) && !is_string($postOfficeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postOfficeCode)), __LINE__);
        }
        $this->PostOfficeCode = $postOfficeCode;
        return $this;
    }
    /**
     * Get ErrorText value
     * @return string|null
     */
    public function getErrorText()
    {
        return $this->ErrorText;
    }
    /**
     * Set ErrorText value
     * @param string $errorText
     * @return \AisFssp\StructType\MailState
     */
    public function setErrorText($errorText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($errorText) && strlen($errorText) > 100) || (is_array($errorText) && count($errorText) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($errorText) ? strlen($errorText) : count($errorText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($errorText) && strlen($errorText) < 1) || (is_array($errorText) && count($errorText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($errorText) && !is_string($errorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorText)), __LINE__);
        }
        $this->ErrorText = $errorText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\MailState
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
