<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupTableQuery StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос данных справочника
 * @subpackage Structs
 */
class LookupTableQuery extends AbstractStructBase
{
    /**
     * The lookupTable
     * Meta informations extracted from the WSDL
     * - documentation: Тип справочника
     * @var string
     */
    public $lookupTable;
    /**
     * The filter
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительное условие | Указание данного значения позволяет при необходимости получить лишь часть справочника. | Строка
     * длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $filter;
    /**
     * Constructor method for LookupTableQuery
     * @uses LookupTableQuery::setLookupTable()
     * @uses LookupTableQuery::setFilter()
     * @param string $lookupTable
     * @param string $filter
     */
    public function __construct($lookupTable = null, $filter = null)
    {
        $this
            ->setLookupTable($lookupTable)
            ->setFilter($filter);
    }
    /**
     * Get lookupTable value
     * @return string|null
     */
    public function getLookupTable()
    {
        return $this->lookupTable;
    }
    /**
     * Set lookupTable value
     * @uses \AisFssp\EnumType\LookupTableType::valueIsValid()
     * @uses \AisFssp\EnumType\LookupTableType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lookupTable
     * @return \AisFssp\StructType\LookupTableQuery
     */
    public function setLookupTable($lookupTable = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\LookupTableType::valueIsValid($lookupTable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $lookupTable, implode(', ', \AisFssp\EnumType\LookupTableType::getValidValues())), __LINE__);
        }
        $this->lookupTable = $lookupTable;
        return $this;
    }
    /**
     * Get filter value
     * @return string|null
     */
    public function getFilter()
    {
        return $this->filter;
    }
    /**
     * Set filter value
     * @param string $filter
     * @return \AisFssp\StructType\LookupTableQuery
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($filter) && strlen($filter) > 1000) || (is_array($filter) && count($filter) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($filter) ? strlen($filter) : count($filter)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($filter) && strlen($filter) < 1) || (is_array($filter) && count($filter) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filter)), __LINE__);
        }
        $this->filter = $filter;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\LookupTableQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
