<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LicenseActivityType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Вид деятельности, на который выдана лицензия
 * @subpackage Structs
 */
class LicenseActivityType extends AbstractStructBase
{
    /**
     * The activityId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $activityId;
    /**
     * The activityName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида деятельности, на который выдана лицензия | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $activityName;
    /**
     * Constructor method for LicenseActivityType
     * @uses LicenseActivityType::setActivityId()
     * @uses LicenseActivityType::setActivityName()
     * @param int $activityId
     * @param string $activityName
     */
    public function __construct($activityId = null, $activityName = null)
    {
        $this
            ->setActivityId($activityId)
            ->setActivityName($activityName);
    }
    /**
     * Get activityId value
     * @return int|null
     */
    public function getActivityId()
    {
        return $this->activityId;
    }
    /**
     * Set activityId value
     * @param int $activityId
     * @return \AisFssp\StructType\LicenseActivityType
     */
    public function setActivityId($activityId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($activityId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $activityId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($activityId, strpos($activityId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($activityId) && !is_numeric($activityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($activityId)), __LINE__);
        }
        $this->activityId = $activityId;
        return $this;
    }
    /**
     * Get activityName value
     * @return string|null
     */
    public function getActivityName()
    {
        return $this->activityName;
    }
    /**
     * Set activityName value
     * @param string $activityName
     * @return \AisFssp\StructType\LicenseActivityType
     */
    public function setActivityName($activityName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($activityName) && strlen($activityName) > 1000) || (is_array($activityName) && count($activityName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($activityName) ? strlen($activityName) : count($activityName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($activityName) && strlen($activityName) < 1) || (is_array($activityName) && count($activityName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($activityName) && !is_string($activityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($activityName)), __LINE__);
        }
        $this->activityName = $activityName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\LicenseActivityType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
