<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvestigationRegistry StructType
 * Meta informations extracted from the WSDL
 * - documentation: Реестр розыска | ЭП
 * @subpackage Structs
 */
class InvestigationRegistry extends AbstractStructBase
{
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - documentation: Версия документа | Строка длиной от 1 до 8 символов
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $version;
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ реестра ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The ospCode
     * Meta informations extracted from the WSDL
     * - documentation: Код ОСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $ospCode;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The unloadDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время выгрузки | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $unloadDate;
    /**
     * The invData
     * Meta informations extracted from the WSDL
     * - documentation: Данные розыска
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\InvestigationData[]
     */
    public $invData;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * Constructor method for InvestigationRegistry
     * @uses InvestigationRegistry::setVersion()
     * @uses InvestigationRegistry::setInternalKey()
     * @uses InvestigationRegistry::setOspCode()
     * @uses InvestigationRegistry::setDocDate()
     * @uses InvestigationRegistry::setDocNumber()
     * @uses InvestigationRegistry::setUnloadDate()
     * @uses InvestigationRegistry::setInvData()
     * @uses InvestigationRegistry::setSignDateTime()
     * @uses InvestigationRegistry::setSignature()
     * @param string $version
     * @param int $internalKey
     * @param string $ospCode
     * @param string $docDate
     * @param string $docNumber
     * @param string $unloadDate
     * @param \AisFssp\StructType\InvestigationData[] $invData
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     */
    public function __construct($version = null, $internalKey = null, $ospCode = null, $docDate = null, $docNumber = null, $unloadDate = null, array $invData = array(), $signDateTime = null, array $signature = array())
    {
        $this
            ->setVersion($version)
            ->setInternalKey($internalKey)
            ->setOspCode($ospCode)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setUnloadDate($unloadDate)
            ->setInvData($invData)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature);
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \AisFssp\StructType\InvestigationRegistry
     */
    public function setVersion($version = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($version) && strlen($version) > 8) || (is_array($version) && count($version) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($version) ? strlen($version) : count($version)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($version) && strlen($version) < 1) || (is_array($version) && count($version) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\InvestigationRegistry
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get ospCode value
     * @return string|null
     */
    public function getOspCode()
    {
        return $this->ospCode;
    }
    /**
     * Set ospCode value
     * @param string $ospCode
     * @return \AisFssp\StructType\InvestigationRegistry
     */
    public function setOspCode($ospCode = null)
    {
        // validation for constraint: length
        if ((is_scalar($ospCode) && strlen($ospCode) !== 5) || (is_array($ospCode) && count($ospCode) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($ospCode) && !preg_match('/[0-9]{5}/', $ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($ospCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ospCode) && !is_string($ospCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ospCode)), __LINE__);
        }
        $this->ospCode = $ospCode;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \AisFssp\StructType\InvestigationRegistry
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\InvestigationRegistry
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get unloadDate value
     * @return string|null
     */
    public function getUnloadDate()
    {
        return $this->unloadDate;
    }
    /**
     * Set unloadDate value
     * @param string $unloadDate
     * @return \AisFssp\StructType\InvestigationRegistry
     */
    public function setUnloadDate($unloadDate = null)
    {
        // validation for constraint: maxExclusive
        if ($unloadDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($unloadDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $unloadDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($unloadDate) && !is_string($unloadDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unloadDate)), __LINE__);
        }
        $this->unloadDate = $unloadDate;
        return $this;
    }
    /**
     * Get invData value
     * @return \AisFssp\StructType\InvestigationData[]|null
     */
    public function getInvData()
    {
        return $this->invData;
    }
    /**
     * Set invData value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\InvestigationData[] $invData
     * @return \AisFssp\StructType\InvestigationRegistry
     */
    public function setInvData(array $invData = array())
    {
        foreach ($invData as $investigationRegistryInvDataItem) {
            // validation for constraint: itemType
            if (!$investigationRegistryInvDataItem instanceof \AisFssp\StructType\InvestigationData) {
                throw new \InvalidArgumentException(sprintf('The invData property can only contain items of \AisFssp\StructType\InvestigationData, "%s" given', is_object($investigationRegistryInvDataItem) ? get_class($investigationRegistryInvDataItem) : gettype($investigationRegistryInvDataItem)), __LINE__);
            }
        }
        $this->invData = $invData;
        return $this;
    }
    /**
     * Add item to invData value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\InvestigationData $item
     * @return \AisFssp\StructType\InvestigationRegistry
     */
    public function addToInvData(\AisFssp\StructType\InvestigationData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\InvestigationData) {
            throw new \InvalidArgumentException(sprintf('The invData property can only contain items of \AisFssp\StructType\InvestigationData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->invData[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\InvestigationRegistry
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\InvestigationRegistry
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $investigationRegistrySignatureItem) {
            // validation for constraint: itemType
            if (!$investigationRegistrySignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($investigationRegistrySignatureItem) ? get_class($investigationRegistrySignatureItem) : gettype($investigationRegistrySignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\InvestigationRegistry
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\InvestigationRegistry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
