<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncomingForcedExecDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Входящий документ принудительного исполнения | Используется приема документов от внешних контрагентов
 * - type: tns:IncomingForcedExecDocument
 * @subpackage Structs
 */
class IncomingForcedExecDocument extends AbstractStructBase
{
    /**
     * The SenderProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты внешнего контрагента
     * - minOccurs: 1
     * @var \AisFssp\StructType\SenderContragentType
     */
    public $SenderProperties;
    /**
     * The SideProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты стороны ИП
     * - minOccurs: 1
     * @var \AisFssp\StructType\ContragentDatumType
     */
    public $SideProperties;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа в АИС внешних контрагентов | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом
     * (ФНС, ПФР и прочие). Данный идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с
     * конкретным внешним контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The OutgoingDocKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор исходящего документа АИС ФССП России | Обязательно, если данный документ направляется в ответ на исходящий
     * документ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $OutgoingDocKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП России | Обязательно, если данный документ направлен в ответ на документ, содержащий сведения об исполнительном
     * производстве | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The ProcDocRef
     * Meta informations extracted from the WSDL
     * - documentation: Постановление СПИ | Обязательно для документов: - Уведомление о готовности к реализации арестованного имущества - Отчет о
     * результатах реализации арестованного имущества
     * - minOccurs: 0
     * @var \AisFssp\StructType\DocRefType
     */
    public $ProcDocRef;
    /**
     * The DocumentData
     * Meta informations extracted from the WSDL
     * - documentation: Документ в формате ПИЭВ
     * @var \AisFssp\StructType\EmbeddedDocumentType
     */
    public $DocumentData;
    /**
     * Constructor method for IncomingForcedExecDocument
     * @uses IncomingForcedExecDocument::setSenderProperties()
     * @uses IncomingForcedExecDocument::setSideProperties()
     * @uses IncomingForcedExecDocument::setExternalKey()
     * @uses IncomingForcedExecDocument::setOutgoingDocKey()
     * @uses IncomingForcedExecDocument::setIpInternalKey()
     * @uses IncomingForcedExecDocument::setProcDocRef()
     * @uses IncomingForcedExecDocument::setDocumentData()
     * @param \AisFssp\StructType\SenderContragentType $senderProperties
     * @param \AisFssp\StructType\ContragentDatumType $sideProperties
     * @param string $externalKey
     * @param int $outgoingDocKey
     * @param int $ipInternalKey
     * @param \AisFssp\StructType\DocRefType $procDocRef
     * @param \AisFssp\StructType\EmbeddedDocumentType $documentData
     */
    public function __construct(\AisFssp\StructType\SenderContragentType $senderProperties = null, \AisFssp\StructType\ContragentDatumType $sideProperties = null, $externalKey = null, $outgoingDocKey = null, $ipInternalKey = null, \AisFssp\StructType\DocRefType $procDocRef = null, \AisFssp\StructType\EmbeddedDocumentType $documentData = null)
    {
        $this
            ->setSenderProperties($senderProperties)
            ->setSideProperties($sideProperties)
            ->setExternalKey($externalKey)
            ->setOutgoingDocKey($outgoingDocKey)
            ->setIpInternalKey($ipInternalKey)
            ->setProcDocRef($procDocRef)
            ->setDocumentData($documentData);
    }
    /**
     * Get SenderProperties value
     * @return \AisFssp\StructType\SenderContragentType
     */
    public function getSenderProperties()
    {
        return $this->SenderProperties;
    }
    /**
     * Set SenderProperties value
     * @param \AisFssp\StructType\SenderContragentType $senderProperties
     * @return \AisFssp\StructType\IncomingForcedExecDocument
     */
    public function setSenderProperties(\AisFssp\StructType\SenderContragentType $senderProperties = null)
    {
        $this->SenderProperties = $senderProperties;
        return $this;
    }
    /**
     * Get SideProperties value
     * @return \AisFssp\StructType\ContragentDatumType
     */
    public function getSideProperties()
    {
        return $this->SideProperties;
    }
    /**
     * Set SideProperties value
     * @param \AisFssp\StructType\ContragentDatumType $sideProperties
     * @return \AisFssp\StructType\IncomingForcedExecDocument
     */
    public function setSideProperties(\AisFssp\StructType\ContragentDatumType $sideProperties = null)
    {
        $this->SideProperties = $sideProperties;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\IncomingForcedExecDocument
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get OutgoingDocKey value
     * @return int|null
     */
    public function getOutgoingDocKey()
    {
        return $this->OutgoingDocKey;
    }
    /**
     * Set OutgoingDocKey value
     * @param int $outgoingDocKey
     * @return \AisFssp\StructType\IncomingForcedExecDocument
     */
    public function setOutgoingDocKey($outgoingDocKey = null)
    {
        // validation for constraint: maxInclusive
        if ($outgoingDocKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $outgoingDocKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($outgoingDocKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $outgoingDocKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($outgoingDocKey) && !is_numeric($outgoingDocKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($outgoingDocKey)), __LINE__);
        }
        $this->OutgoingDocKey = $outgoingDocKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \AisFssp\StructType\IncomingForcedExecDocument
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($ipInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ipInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($ipInternalKey) && !is_numeric($ipInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ipInternalKey)), __LINE__);
        }
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get ProcDocRef value
     * @return \AisFssp\StructType\DocRefType|null
     */
    public function getProcDocRef()
    {
        return $this->ProcDocRef;
    }
    /**
     * Set ProcDocRef value
     * @param \AisFssp\StructType\DocRefType $procDocRef
     * @return \AisFssp\StructType\IncomingForcedExecDocument
     */
    public function setProcDocRef(\AisFssp\StructType\DocRefType $procDocRef = null)
    {
        $this->ProcDocRef = $procDocRef;
        return $this;
    }
    /**
     * Get DocumentData value
     * @return \AisFssp\StructType\EmbeddedDocumentType|null
     */
    public function getDocumentData()
    {
        return $this->DocumentData;
    }
    /**
     * Set DocumentData value
     * @param \AisFssp\StructType\EmbeddedDocumentType $documentData
     * @return \AisFssp\StructType\IncomingForcedExecDocument
     */
    public function setDocumentData(\AisFssp\StructType\EmbeddedDocumentType $documentData = null)
    {
        $this->DocumentData = $documentData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IncomingForcedExecDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
