<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPSideRequestCourseIDType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ IPSideRequestCourseIDType «Регистрация запроса о ходе ИП по исполнительному документу» | ЭП
 * @subpackage Structs
 */
class IPSideRequestCourseIDType extends IPSideRequestType
{
    /**
     * The IDTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Код органа, выдавшего ИД
     * @var string
     */
    public $IDTypeCode;
    /**
     * The IDNumber
     * Meta informations extracted from the WSDL
     * - documentation: Код предмета исполнения | Строка длиной от 1 до 25 символов
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IDNumber;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата ИД | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The IDSubjectText
     * Meta informations extracted from the WSDL
     * - documentation: Предмет исполнения | Строка длиной от 1 до 500 символов
     * - maxLength: 500
     * - minLength: 1
     * @var string
     */
    public $IDSubjectText;
    /**
     * The IDCourtName
     * Meta informations extracted from the WSDL
     * - documentation: Орган выдавший исполнительный документ | Строка длиной от 1 до 250 символов
     * - maxLength: 250
     * - minLength: 1
     * @var string
     */
    public $IDCourtName;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for IPSideRequestCourseIDType
     * @uses IPSideRequestCourseIDType::setIDTypeCode()
     * @uses IPSideRequestCourseIDType::setIDNumber()
     * @uses IPSideRequestCourseIDType::setIDDate()
     * @uses IPSideRequestCourseIDType::setIDSubjectText()
     * @uses IPSideRequestCourseIDType::setIDCourtName()
     * @uses IPSideRequestCourseIDType::setSignature()
     * @uses IPSideRequestCourseIDType::setId()
     * @param string $iDTypeCode
     * @param string $iDNumber
     * @param string $iDDate
     * @param string $iDSubjectText
     * @param string $iDCourtName
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($iDTypeCode = null, $iDNumber = null, $iDDate = null, $iDSubjectText = null, $iDCourtName = null, array $signature = array(), $id = null)
    {
        $this
            ->setIDTypeCode($iDTypeCode)
            ->setIDNumber($iDNumber)
            ->setIDDate($iDDate)
            ->setIDSubjectText($iDSubjectText)
            ->setIDCourtName($iDCourtName)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get IDTypeCode value
     * @return string|null
     */
    public function getIDTypeCode()
    {
        return $this->IDTypeCode;
    }
    /**
     * Set IDTypeCode value
     * @uses \AisFssp\EnumType\IdType::valueIsValid()
     * @uses \AisFssp\EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDTypeCode
     * @return \AisFssp\StructType\IPSideRequestCourseIDType
     */
    public function setIDTypeCode($iDTypeCode = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\IdType::valueIsValid($iDTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $iDTypeCode, implode(', ', \AisFssp\EnumType\IdType::getValidValues())), __LINE__);
        }
        $this->IDTypeCode = $iDTypeCode;
        return $this;
    }
    /**
     * Get IDNumber value
     * @return string|null
     */
    public function getIDNumber()
    {
        return $this->IDNumber;
    }
    /**
     * Set IDNumber value
     * @param string $iDNumber
     * @return \AisFssp\StructType\IPSideRequestCourseIDType
     */
    public function setIDNumber($iDNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDNumber) && strlen($iDNumber) > 25) || (is_array($iDNumber) && count($iDNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iDNumber) ? strlen($iDNumber) : count($iDNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDNumber) && strlen($iDNumber) < 1) || (is_array($iDNumber) && count($iDNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDNumber) && !is_string($iDNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDNumber)), __LINE__);
        }
        $this->IDNumber = $iDNumber;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \AisFssp\StructType\IPSideRequestCourseIDType
     */
    public function setIDDate($iDDate = null)
    {
        // validation for constraint: maxExclusive
        if ($iDDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iDDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDDate) && !is_string($iDDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDDate)), __LINE__);
        }
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get IDSubjectText value
     * @return string|null
     */
    public function getIDSubjectText()
    {
        return $this->IDSubjectText;
    }
    /**
     * Set IDSubjectText value
     * @param string $iDSubjectText
     * @return \AisFssp\StructType\IPSideRequestCourseIDType
     */
    public function setIDSubjectText($iDSubjectText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDSubjectText) && strlen($iDSubjectText) > 500) || (is_array($iDSubjectText) && count($iDSubjectText) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($iDSubjectText) ? strlen($iDSubjectText) : count($iDSubjectText)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDSubjectText) && strlen($iDSubjectText) < 1) || (is_array($iDSubjectText) && count($iDSubjectText) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDSubjectText) && !is_string($iDSubjectText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDSubjectText)), __LINE__);
        }
        $this->IDSubjectText = $iDSubjectText;
        return $this;
    }
    /**
     * Get IDCourtName value
     * @return string|null
     */
    public function getIDCourtName()
    {
        return $this->IDCourtName;
    }
    /**
     * Set IDCourtName value
     * @param string $iDCourtName
     * @return \AisFssp\StructType\IPSideRequestCourseIDType
     */
    public function setIDCourtName($iDCourtName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDCourtName) && strlen($iDCourtName) > 250) || (is_array($iDCourtName) && count($iDCourtName) > 250)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 250 element(s) or a scalar of 250 character(s) at most, "%d" length given', is_scalar($iDCourtName) ? strlen($iDCourtName) : count($iDCourtName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDCourtName) && strlen($iDCourtName) < 1) || (is_array($iDCourtName) && count($iDCourtName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDCourtName) && !is_string($iDCourtName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDCourtName)), __LINE__);
        }
        $this->IDCourtName = $iDCourtName;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\IPSideRequestCourseIDType
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $iPSideRequestCourseIDTypeSignatureItem) {
            // validation for constraint: itemType
            if (!$iPSideRequestCourseIDTypeSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($iPSideRequestCourseIDTypeSignatureItem) ? get_class($iPSideRequestCourseIDTypeSignatureItem) : gettype($iPSideRequestCourseIDTypeSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\IPSideRequestCourseIDType
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\IPSideRequestCourseIDType
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPSideRequestCourseIDType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
