<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPSideQuery StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос стороны ИП | Документ содержит запрос Ведомства, являющегося стороной ИП, сведений по исполнительному производству
 * - type: tns:IPSideQuery
 * @subpackage Structs
 */
class IPSideQuery extends AbstractStructBase
{
    /**
     * The IPNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП строковый | Номер документа
     * - minOccurs: 1
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IPNum;
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The IdExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор ИД АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - minOccurs: 0
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $IdExternalKey;
    /**
     * The DocType
     * Meta informations extracted from the WSDL
     * - documentation: Тип документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string[]
     */
    public $DocType;
    /**
     * The DocDateBegin
     * Meta informations extracted from the WSDL
     * - documentation: Начальная дата | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDateBegin;
    /**
     * The DocDateEnd
     * Meta informations extracted from the WSDL
     * - documentation: Конечная дата (включительно) | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDateEnd;
    /**
     * The Subscription
     * Meta informations extracted from the WSDL
     * - documentation: Подписка на рассылку документов | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $Subscription;
    /**
     * Constructor method for IPSideQuery
     * @uses IPSideQuery::setIPNum()
     * @uses IPSideQuery::setExternalKey()
     * @uses IPSideQuery::setIpInternalKey()
     * @uses IPSideQuery::setIdExternalKey()
     * @uses IPSideQuery::setDocType()
     * @uses IPSideQuery::setDocDateBegin()
     * @uses IPSideQuery::setDocDateEnd()
     * @uses IPSideQuery::setSubscription()
     * @param string $iPNum
     * @param string $externalKey
     * @param int $ipInternalKey
     * @param string $idExternalKey
     * @param string[] $docType
     * @param string $docDateBegin
     * @param string $docDateEnd
     * @param bool $subscription
     */
    public function __construct($iPNum = null, $externalKey = null, $ipInternalKey = null, $idExternalKey = null, array $docType = array(), $docDateBegin = null, $docDateEnd = null, $subscription = null)
    {
        $this
            ->setIPNum($iPNum)
            ->setExternalKey($externalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setIdExternalKey($idExternalKey)
            ->setDocType($docType)
            ->setDocDateBegin($docDateBegin)
            ->setDocDateEnd($docDateEnd)
            ->setSubscription($subscription);
    }
    /**
     * Get IPNum value
     * @return string
     */
    public function getIPNum()
    {
        return $this->IPNum;
    }
    /**
     * Set IPNum value
     * @param string $iPNum
     * @return \AisFssp\StructType\IPSideQuery
     */
    public function setIPNum($iPNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iPNum) && strlen($iPNum) > 25) || (is_array($iPNum) && count($iPNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iPNum) ? strlen($iPNum) : count($iPNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iPNum) && strlen($iPNum) < 1) || (is_array($iPNum) && count($iPNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iPNum) && !is_string($iPNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPNum)), __LINE__);
        }
        $this->IPNum = $iPNum;
        return $this;
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\IPSideQuery
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \AisFssp\StructType\IPSideQuery
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($ipInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ipInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($ipInternalKey) && !is_numeric($ipInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ipInternalKey)), __LINE__);
        }
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get IdExternalKey value
     * @return string|null
     */
    public function getIdExternalKey()
    {
        return $this->IdExternalKey;
    }
    /**
     * Set IdExternalKey value
     * @param string $idExternalKey
     * @return \AisFssp\StructType\IPSideQuery
     */
    public function setIdExternalKey($idExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($idExternalKey) && strlen($idExternalKey) > 60) || (is_array($idExternalKey) && count($idExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($idExternalKey) ? strlen($idExternalKey) : count($idExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($idExternalKey) && strlen($idExternalKey) < 1) || (is_array($idExternalKey) && count($idExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idExternalKey) && !is_string($idExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idExternalKey)), __LINE__);
        }
        $this->IdExternalKey = $idExternalKey;
        return $this;
    }
    /**
     * Get DocType value
     * @return string[]|null
     */
    public function getDocType()
    {
        return $this->DocType;
    }
    /**
     * Set DocType value
     * @throws \InvalidArgumentException
     * @param string[] $docType
     * @return \AisFssp\StructType\IPSideQuery
     */
    public function setDocType(array $docType = array())
    {
        // validation for constraint: maxLength
        if ((is_scalar($docType) && strlen($docType) > 1) || (is_array($docType) && count($docType) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($docType) ? strlen($docType) : count($docType)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docType) && strlen($docType) < 1) || (is_array($docType) && count($docType) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        foreach ($docType as $iPSideQueryDocTypeItem) {
            // validation for constraint: itemType
            if (!is_string($iPSideQueryDocTypeItem)) {
                throw new \InvalidArgumentException(sprintf('The DocType property can only contain items of string, "%s" given', is_object($iPSideQueryDocTypeItem) ? get_class($iPSideQueryDocTypeItem) : gettype($iPSideQueryDocTypeItem)), __LINE__);
            }
        }
        $this->DocType = $docType;
        return $this;
    }
    /**
     * Add item to DocType value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \AisFssp\StructType\IPSideQuery
     */
    public function addToDocType($item)
    {
        // validation for constraint: maxLength
        if ((is_scalar($item) && strlen($item) > 1) || (is_array($item) && count($item) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($item) ? strlen($item) : count($item)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($item) && strlen($item) < 1) || (is_array($item) && count($item) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The DocType property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DocType[] = $item;
        return $this;
    }
    /**
     * Get DocDateBegin value
     * @return string|null
     */
    public function getDocDateBegin()
    {
        return $this->DocDateBegin;
    }
    /**
     * Set DocDateBegin value
     * @param string $docDateBegin
     * @return \AisFssp\StructType\IPSideQuery
     */
    public function setDocDateBegin($docDateBegin = null)
    {
        // validation for constraint: maxExclusive
        if ($docDateBegin >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDateBegin), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDateBegin < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDateBegin), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDateBegin) && !is_string($docDateBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDateBegin)), __LINE__);
        }
        $this->DocDateBegin = $docDateBegin;
        return $this;
    }
    /**
     * Get DocDateEnd value
     * @return string|null
     */
    public function getDocDateEnd()
    {
        return $this->DocDateEnd;
    }
    /**
     * Set DocDateEnd value
     * @param string $docDateEnd
     * @return \AisFssp\StructType\IPSideQuery
     */
    public function setDocDateEnd($docDateEnd = null)
    {
        // validation for constraint: maxExclusive
        if ($docDateEnd >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDateEnd), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDateEnd < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDateEnd), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDateEnd) && !is_string($docDateEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDateEnd)), __LINE__);
        }
        $this->DocDateEnd = $docDateEnd;
        return $this;
    }
    /**
     * Get Subscription value
     * @return bool|null
     */
    public function getSubscription()
    {
        return $this->Subscription;
    }
    /**
     * Set Subscription value
     * @param bool $subscription
     * @return \AisFssp\StructType\IPSideQuery
     */
    public function setSubscription($subscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($subscription) && !is_bool($subscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($subscription)), __LINE__);
        }
        $this->Subscription = $subscription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPSideQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
