<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IPSideAnswer StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ стороне ИП | Документ содержит ответ на запрос стороны исполнительного производства о ходе исполнительного
 * производства, в частности, сведения о документах по ИП
 * - type: tns:IPSideAnswer
 * @subpackage Structs
 */
class IPSideAnswer extends AbstractStructBase
{
    /**
     * The InternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $InternalKey;
    /**
     * The QueryExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $QueryExternalKey;
    /**
     * The IpInternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ИП ФССП РФ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $IpInternalKey;
    /**
     * The ActDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата актуальности | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ActDate;
    /**
     * The IPDocsInfo
     * Meta informations extracted from the WSDL
     * - documentation: Документы ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPDocInfoType[]
     */
    public $IPDocsInfo;
    /**
     * The IPAcctRecords
     * Meta informations extracted from the WSDL
     * - documentation: Расчёты ИП
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\IPAccountingType[]
     */
    public $IPAcctRecords;
    /**
     * Constructor method for IPSideAnswer
     * @uses IPSideAnswer::setInternalKey()
     * @uses IPSideAnswer::setQueryExternalKey()
     * @uses IPSideAnswer::setIpInternalKey()
     * @uses IPSideAnswer::setActDate()
     * @uses IPSideAnswer::setIPDocsInfo()
     * @uses IPSideAnswer::setIPAcctRecords()
     * @param int $internalKey
     * @param string $queryExternalKey
     * @param int $ipInternalKey
     * @param string $actDate
     * @param \AisFssp\StructType\IPDocInfoType[] $iPDocsInfo
     * @param \AisFssp\StructType\IPAccountingType[] $iPAcctRecords
     */
    public function __construct($internalKey = null, $queryExternalKey = null, $ipInternalKey = null, $actDate = null, array $iPDocsInfo = array(), array $iPAcctRecords = array())
    {
        $this
            ->setInternalKey($internalKey)
            ->setQueryExternalKey($queryExternalKey)
            ->setIpInternalKey($ipInternalKey)
            ->setActDate($actDate)
            ->setIPDocsInfo($iPDocsInfo)
            ->setIPAcctRecords($iPAcctRecords);
    }
    /**
     * Get InternalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->InternalKey;
    }
    /**
     * Set InternalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\IPSideAnswer
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->InternalKey = $internalKey;
        return $this;
    }
    /**
     * Get QueryExternalKey value
     * @return string|null
     */
    public function getQueryExternalKey()
    {
        return $this->QueryExternalKey;
    }
    /**
     * Set QueryExternalKey value
     * @param string $queryExternalKey
     * @return \AisFssp\StructType\IPSideAnswer
     */
    public function setQueryExternalKey($queryExternalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($queryExternalKey) && strlen($queryExternalKey) > 60) || (is_array($queryExternalKey) && count($queryExternalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($queryExternalKey) ? strlen($queryExternalKey) : count($queryExternalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($queryExternalKey) && strlen($queryExternalKey) < 1) || (is_array($queryExternalKey) && count($queryExternalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($queryExternalKey) && !is_string($queryExternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queryExternalKey)), __LINE__);
        }
        $this->QueryExternalKey = $queryExternalKey;
        return $this;
    }
    /**
     * Get IpInternalKey value
     * @return int|null
     */
    public function getIpInternalKey()
    {
        return $this->IpInternalKey;
    }
    /**
     * Set IpInternalKey value
     * @param int $ipInternalKey
     * @return \AisFssp\StructType\IPSideAnswer
     */
    public function setIpInternalKey($ipInternalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($ipInternalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($ipInternalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $ipInternalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($ipInternalKey) && !is_numeric($ipInternalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ipInternalKey)), __LINE__);
        }
        $this->IpInternalKey = $ipInternalKey;
        return $this;
    }
    /**
     * Get ActDate value
     * @return string|null
     */
    public function getActDate()
    {
        return $this->ActDate;
    }
    /**
     * Set ActDate value
     * @param string $actDate
     * @return \AisFssp\StructType\IPSideAnswer
     */
    public function setActDate($actDate = null)
    {
        // validation for constraint: maxExclusive
        if ($actDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $actDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($actDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $actDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($actDate) && !is_string($actDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actDate)), __LINE__);
        }
        $this->ActDate = $actDate;
        return $this;
    }
    /**
     * Get IPDocsInfo value
     * @return \AisFssp\StructType\IPDocInfoType[]|null
     */
    public function getIPDocsInfo()
    {
        return $this->IPDocsInfo;
    }
    /**
     * Set IPDocsInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPDocInfoType[] $iPDocsInfo
     * @return \AisFssp\StructType\IPSideAnswer
     */
    public function setIPDocsInfo(array $iPDocsInfo = array())
    {
        foreach ($iPDocsInfo as $iPSideAnswerIPDocsInfoItem) {
            // validation for constraint: itemType
            if (!$iPSideAnswerIPDocsInfoItem instanceof \AisFssp\StructType\IPDocInfoType) {
                throw new \InvalidArgumentException(sprintf('The IPDocsInfo property can only contain items of \AisFssp\StructType\IPDocInfoType, "%s" given', is_object($iPSideAnswerIPDocsInfoItem) ? get_class($iPSideAnswerIPDocsInfoItem) : gettype($iPSideAnswerIPDocsInfoItem)), __LINE__);
            }
        }
        $this->IPDocsInfo = $iPDocsInfo;
        return $this;
    }
    /**
     * Add item to IPDocsInfo value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPDocInfoType $item
     * @return \AisFssp\StructType\IPSideAnswer
     */
    public function addToIPDocsInfo(\AisFssp\StructType\IPDocInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPDocInfoType) {
            throw new \InvalidArgumentException(sprintf('The IPDocsInfo property can only contain items of \AisFssp\StructType\IPDocInfoType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IPDocsInfo[] = $item;
        return $this;
    }
    /**
     * Get IPAcctRecords value
     * @return \AisFssp\StructType\IPAccountingType[]|null
     */
    public function getIPAcctRecords()
    {
        return $this->IPAcctRecords;
    }
    /**
     * Set IPAcctRecords value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPAccountingType[] $iPAcctRecords
     * @return \AisFssp\StructType\IPSideAnswer
     */
    public function setIPAcctRecords(array $iPAcctRecords = array())
    {
        foreach ($iPAcctRecords as $iPSideAnswerIPAcctRecordsItem) {
            // validation for constraint: itemType
            if (!$iPSideAnswerIPAcctRecordsItem instanceof \AisFssp\StructType\IPAccountingType) {
                throw new \InvalidArgumentException(sprintf('The IPAcctRecords property can only contain items of \AisFssp\StructType\IPAccountingType, "%s" given', is_object($iPSideAnswerIPAcctRecordsItem) ? get_class($iPSideAnswerIPAcctRecordsItem) : gettype($iPSideAnswerIPAcctRecordsItem)), __LINE__);
            }
        }
        $this->IPAcctRecords = $iPAcctRecords;
        return $this;
    }
    /**
     * Add item to IPAcctRecords value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\IPAccountingType $item
     * @return \AisFssp\StructType\IPSideAnswer
     */
    public function addToIPAcctRecords(\AisFssp\StructType\IPAccountingType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\IPAccountingType) {
            throw new \InvalidArgumentException(sprintf('The IPAcctRecords property can only contain items of \AisFssp\StructType\IPAccountingType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IPAcctRecords[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\IPSideAnswer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
