<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HijackingType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об угоне
 * @subpackage Structs
 */
class HijackingType extends AbstractStructBase
{
    /**
     * The HijackingDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата угона | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $HijackingDate;
    /**
     * The HijackingEndDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата исключения из угона | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $HijackingEndDate;
    /**
     * The CaseNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер дела | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $CaseNumber;
    /**
     * Constructor method for HijackingType
     * @uses HijackingType::setHijackingDate()
     * @uses HijackingType::setHijackingEndDate()
     * @uses HijackingType::setCaseNumber()
     * @param string $hijackingDate
     * @param string $hijackingEndDate
     * @param string $caseNumber
     */
    public function __construct($hijackingDate = null, $hijackingEndDate = null, $caseNumber = null)
    {
        $this
            ->setHijackingDate($hijackingDate)
            ->setHijackingEndDate($hijackingEndDate)
            ->setCaseNumber($caseNumber);
    }
    /**
     * Get HijackingDate value
     * @return string|null
     */
    public function getHijackingDate()
    {
        return $this->HijackingDate;
    }
    /**
     * Set HijackingDate value
     * @param string $hijackingDate
     * @return \AisFssp\StructType\HijackingType
     */
    public function setHijackingDate($hijackingDate = null)
    {
        // validation for constraint: maxExclusive
        if ($hijackingDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $hijackingDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($hijackingDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $hijackingDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hijackingDate) && !is_string($hijackingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hijackingDate)), __LINE__);
        }
        $this->HijackingDate = $hijackingDate;
        return $this;
    }
    /**
     * Get HijackingEndDate value
     * @return string|null
     */
    public function getHijackingEndDate()
    {
        return $this->HijackingEndDate;
    }
    /**
     * Set HijackingEndDate value
     * @param string $hijackingEndDate
     * @return \AisFssp\StructType\HijackingType
     */
    public function setHijackingEndDate($hijackingEndDate = null)
    {
        // validation for constraint: maxExclusive
        if ($hijackingEndDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $hijackingEndDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($hijackingEndDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $hijackingEndDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hijackingEndDate) && !is_string($hijackingEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hijackingEndDate)), __LINE__);
        }
        $this->HijackingEndDate = $hijackingEndDate;
        return $this;
    }
    /**
     * Get CaseNumber value
     * @return string|null
     */
    public function getCaseNumber()
    {
        return $this->CaseNumber;
    }
    /**
     * Set CaseNumber value
     * @param string $caseNumber
     * @return \AisFssp\StructType\HijackingType
     */
    public function setCaseNumber($caseNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($caseNumber) && strlen($caseNumber) > 50) || (is_array($caseNumber) && count($caseNumber) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($caseNumber) ? strlen($caseNumber) : count($caseNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($caseNumber) && strlen($caseNumber) < 1) || (is_array($caseNumber) && count($caseNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($caseNumber) && !is_string($caseNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($caseNumber)), __LINE__);
        }
        $this->CaseNumber = $caseNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\HijackingType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
