<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о товаре
 * @subpackage Structs
 */
class GoodsDatumType extends InformationType
{
    /**
     * The GoodsType
     * Meta informations extracted from the WSDL
     * - documentation: Тип сведений о товаре
     * @var string
     */
    public $GoodsType;
    /**
     * The GoodsName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование товара | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $GoodsName;
    /**
     * The GoodsCost
     * Meta informations extracted from the WSDL
     * - documentation: Стоимость товара | Сумма
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $GoodsCost;
    /**
     * The MoveDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата товара | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $MoveDate;
    /**
     * The SourceCountry
     * Meta informations extracted from the WSDL
     * - documentation: Место | Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $SourceCountry;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - documentation: Направление | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Direction;
    /**
     * The Grounds
     * Meta informations extracted from the WSDL
     * - documentation: Дополнительная информация | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $Grounds;
    /**
     * Constructor method for GoodsDatumType
     * @uses GoodsDatumType::setGoodsType()
     * @uses GoodsDatumType::setGoodsName()
     * @uses GoodsDatumType::setGoodsCost()
     * @uses GoodsDatumType::setMoveDate()
     * @uses GoodsDatumType::setSourceCountry()
     * @uses GoodsDatumType::setDirection()
     * @uses GoodsDatumType::setGrounds()
     * @param string $goodsType
     * @param string $goodsName
     * @param float $goodsCost
     * @param string $moveDate
     * @param string $sourceCountry
     * @param string $direction
     * @param string $grounds
     */
    public function __construct($goodsType = null, $goodsName = null, $goodsCost = null, $moveDate = null, $sourceCountry = null, $direction = null, $grounds = null)
    {
        $this
            ->setGoodsType($goodsType)
            ->setGoodsName($goodsName)
            ->setGoodsCost($goodsCost)
            ->setMoveDate($moveDate)
            ->setSourceCountry($sourceCountry)
            ->setDirection($direction)
            ->setGrounds($grounds);
    }
    /**
     * Get GoodsType value
     * @return string|null
     */
    public function getGoodsType()
    {
        return $this->GoodsType;
    }
    /**
     * Set GoodsType value
     * @uses \AisFssp\EnumType\GoodsType::valueIsValid()
     * @uses \AisFssp\EnumType\GoodsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $goodsType
     * @return \AisFssp\StructType\GoodsDatumType
     */
    public function setGoodsType($goodsType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\GoodsType::valueIsValid($goodsType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $goodsType, implode(', ', \AisFssp\EnumType\GoodsType::getValidValues())), __LINE__);
        }
        $this->GoodsType = $goodsType;
        return $this;
    }
    /**
     * Get GoodsName value
     * @return string|null
     */
    public function getGoodsName()
    {
        return $this->GoodsName;
    }
    /**
     * Set GoodsName value
     * @param string $goodsName
     * @return \AisFssp\StructType\GoodsDatumType
     */
    public function setGoodsName($goodsName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($goodsName) && strlen($goodsName) > 1000) || (is_array($goodsName) && count($goodsName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($goodsName) ? strlen($goodsName) : count($goodsName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($goodsName) && strlen($goodsName) < 1) || (is_array($goodsName) && count($goodsName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($goodsName) && !is_string($goodsName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($goodsName)), __LINE__);
        }
        $this->GoodsName = $goodsName;
        return $this;
    }
    /**
     * Get GoodsCost value
     * @return float|null
     */
    public function getGoodsCost()
    {
        return $this->GoodsCost;
    }
    /**
     * Set GoodsCost value
     * @param float $goodsCost
     * @return \AisFssp\StructType\GoodsDatumType
     */
    public function setGoodsCost($goodsCost = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($goodsCost) && strlen(substr($goodsCost, strpos($goodsCost, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($goodsCost, strpos($goodsCost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($goodsCost) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $goodsCost)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($goodsCost, strpos($goodsCost, '.')))), __LINE__);
        }
        $this->GoodsCost = $goodsCost;
        return $this;
    }
    /**
     * Get MoveDate value
     * @return string|null
     */
    public function getMoveDate()
    {
        return $this->MoveDate;
    }
    /**
     * Set MoveDate value
     * @param string $moveDate
     * @return \AisFssp\StructType\GoodsDatumType
     */
    public function setMoveDate($moveDate = null)
    {
        // validation for constraint: maxExclusive
        if ($moveDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $moveDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($moveDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $moveDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($moveDate) && !is_string($moveDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moveDate)), __LINE__);
        }
        $this->MoveDate = $moveDate;
        return $this;
    }
    /**
     * Get SourceCountry value
     * @return string|null
     */
    public function getSourceCountry()
    {
        return $this->SourceCountry;
    }
    /**
     * Set SourceCountry value
     * @param string $sourceCountry
     * @return \AisFssp\StructType\GoodsDatumType
     */
    public function setSourceCountry($sourceCountry = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sourceCountry) && strlen($sourceCountry) > 1000) || (is_array($sourceCountry) && count($sourceCountry) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($sourceCountry) ? strlen($sourceCountry) : count($sourceCountry)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($sourceCountry) && strlen($sourceCountry) < 1) || (is_array($sourceCountry) && count($sourceCountry) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sourceCountry) && !is_string($sourceCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceCountry)), __LINE__);
        }
        $this->SourceCountry = $sourceCountry;
        return $this;
    }
    /**
     * Get Direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param string $direction
     * @return \AisFssp\StructType\GoodsDatumType
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($direction) && strlen($direction) > 1000) || (is_array($direction) && count($direction) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($direction) ? strlen($direction) : count($direction)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($direction) && strlen($direction) < 1) || (is_array($direction) && count($direction) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($direction)), __LINE__);
        }
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get Grounds value
     * @return string|null
     */
    public function getGrounds()
    {
        return $this->Grounds;
    }
    /**
     * Set Grounds value
     * @param string $grounds
     * @return \AisFssp\StructType\GoodsDatumType
     */
    public function setGrounds($grounds = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($grounds) && strlen($grounds) > 1000) || (is_array($grounds) && count($grounds) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($grounds) ? strlen($grounds) : count($grounds)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($grounds) && strlen($grounds) < 1) || (is_array($grounds) && count($grounds) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($grounds) && !is_string($grounds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grounds)), __LINE__);
        }
        $this->Grounds = $grounds;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\GoodsDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
