<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FishQuotaCurYearDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о наличии квот на вылов биоресурсов на текущий год
 * @subpackage Structs
 */
class FishQuotaCurYearDatumType extends FishDatumType
{
    /**
     * The year
     * Meta informations extracted from the WSDL
     * - documentation: Год квоты | Год (выпуска, рождения и т. п.)
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $year;
    /**
     * The volume
     * Meta informations extracted from the WSDL
     * - documentation: Объем | Количество
     * - fractionDigits: 3
     * - totalDigits: 15
     * @var float
     */
    public $volume;
    /**
     * The OKEICode
     * Meta informations extracted from the WSDL
     * - documentation: Код единицы по ОКЕИ | Код ОКЕИ
     * - length: 3
     * @var string
     */
    public $OKEICode;
    /**
     * The OKEIName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование единицы по ОКЕИ | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OKEIName;
    /**
     * Constructor method for FishQuotaCurYearDatumType
     * @uses FishQuotaCurYearDatumType::setYear()
     * @uses FishQuotaCurYearDatumType::setVolume()
     * @uses FishQuotaCurYearDatumType::setOKEICode()
     * @uses FishQuotaCurYearDatumType::setOKEIName()
     * @param string $year
     * @param float $volume
     * @param string $oKEICode
     * @param string $oKEIName
     */
    public function __construct($year = null, $volume = null, $oKEICode = null, $oKEIName = null)
    {
        $this
            ->setYear($year)
            ->setVolume($volume)
            ->setOKEICode($oKEICode)
            ->setOKEIName($oKEIName);
    }
    /**
     * Get year value
     * @return string|null
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param string $year
     * @return \AisFssp\StructType\FishQuotaCurYearDatumType
     */
    public function setYear($year = null)
    {
        // validation for constraint: maxInclusive
        if ($year > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $year), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($year < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $year), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($year) && !is_string($year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($year)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
    /**
     * Get volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \AisFssp\StructType\FishQuotaCurYearDatumType
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($volume) && strlen(substr($volume, strpos($volume, '.') + 1)) !== 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 3 fraction digits, "%d" given', strlen(substr($volume, strpos($volume, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($volume) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $volume)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($volume, strpos($volume, '.')))), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get OKEICode value
     * @return string|null
     */
    public function getOKEICode()
    {
        return $this->OKEICode;
    }
    /**
     * Set OKEICode value
     * @param string $oKEICode
     * @return \AisFssp\StructType\FishQuotaCurYearDatumType
     */
    public function setOKEICode($oKEICode = null)
    {
        // validation for constraint: length
        if ((is_scalar($oKEICode) && strlen($oKEICode) !== 3) || (is_array($oKEICode) && count($oKEICode) !== 3)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 3 element(s) or a scalar of 3 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKEICode) && !is_string($oKEICode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKEICode)), __LINE__);
        }
        $this->OKEICode = $oKEICode;
        return $this;
    }
    /**
     * Get OKEIName value
     * @return string|null
     */
    public function getOKEIName()
    {
        return $this->OKEIName;
    }
    /**
     * Set OKEIName value
     * @param string $oKEIName
     * @return \AisFssp\StructType\FishQuotaCurYearDatumType
     */
    public function setOKEIName($oKEIName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($oKEIName) && strlen($oKEIName) > 100) || (is_array($oKEIName) && count($oKEIName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($oKEIName) ? strlen($oKEIName) : count($oKEIName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($oKEIName) && strlen($oKEIName) < 1) || (is_array($oKEIName) && count($oKEIName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($oKEIName) && !is_string($oKEIName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oKEIName)), __LINE__);
        }
        $this->OKEIName = $oKEIName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\FishQuotaCurYearDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
