<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FishDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о биоресурсах
 * @subpackage Structs
 */
abstract class FishDatumType extends InformationType
{
    /**
     * The organName
     * Meta informations extracted from the WSDL
     * - documentation: Орган исполнительной власти | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $organName;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The resourceCode
     * Meta informations extracted from the WSDL
     * - documentation: Код вида водного биоресурса | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $resourceCode;
    /**
     * The resourceName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида водного биоресурса | Строка длиной от 1 до 100 символов
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $resourceName;
    /**
     * The areaCode
     * Meta informations extracted from the WSDL
     * - documentation: Код района добычи | Строка длиной от 1 до 10 символов
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $areaCode;
    /**
     * The areaName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование района добычи | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $areaName;
    /**
     * Constructor method for FishDatumType
     * @uses FishDatumType::setOrganName()
     * @uses FishDatumType::setDocDate()
     * @uses FishDatumType::setDocNumber()
     * @uses FishDatumType::setResourceCode()
     * @uses FishDatumType::setResourceName()
     * @uses FishDatumType::setAreaCode()
     * @uses FishDatumType::setAreaName()
     * @param string $organName
     * @param string $docDate
     * @param string $docNumber
     * @param string $resourceCode
     * @param string $resourceName
     * @param string $areaCode
     * @param string $areaName
     */
    public function __construct($organName = null, $docDate = null, $docNumber = null, $resourceCode = null, $resourceName = null, $areaCode = null, $areaName = null)
    {
        $this
            ->setOrganName($organName)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setResourceCode($resourceCode)
            ->setResourceName($resourceName)
            ->setAreaCode($areaCode)
            ->setAreaName($areaName);
    }
    /**
     * Get organName value
     * @return string|null
     */
    public function getOrganName()
    {
        return $this->organName;
    }
    /**
     * Set organName value
     * @param string $organName
     * @return \AisFssp\StructType\FishDatumType
     */
    public function setOrganName($organName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organName) && strlen($organName) > 300) || (is_array($organName) && count($organName) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($organName) ? strlen($organName) : count($organName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organName) && strlen($organName) < 1) || (is_array($organName) && count($organName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organName) && !is_string($organName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organName)), __LINE__);
        }
        $this->organName = $organName;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \AisFssp\StructType\FishDatumType
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\FishDatumType
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get resourceCode value
     * @return string|null
     */
    public function getResourceCode()
    {
        return $this->resourceCode;
    }
    /**
     * Set resourceCode value
     * @param string $resourceCode
     * @return \AisFssp\StructType\FishDatumType
     */
    public function setResourceCode($resourceCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($resourceCode) && strlen($resourceCode) > 10) || (is_array($resourceCode) && count($resourceCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($resourceCode) ? strlen($resourceCode) : count($resourceCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($resourceCode) && strlen($resourceCode) < 1) || (is_array($resourceCode) && count($resourceCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($resourceCode) && !is_string($resourceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resourceCode)), __LINE__);
        }
        $this->resourceCode = $resourceCode;
        return $this;
    }
    /**
     * Get resourceName value
     * @return string|null
     */
    public function getResourceName()
    {
        return $this->resourceName;
    }
    /**
     * Set resourceName value
     * @param string $resourceName
     * @return \AisFssp\StructType\FishDatumType
     */
    public function setResourceName($resourceName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($resourceName) && strlen($resourceName) > 100) || (is_array($resourceName) && count($resourceName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($resourceName) ? strlen($resourceName) : count($resourceName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($resourceName) && strlen($resourceName) < 1) || (is_array($resourceName) && count($resourceName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($resourceName) && !is_string($resourceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resourceName)), __LINE__);
        }
        $this->resourceName = $resourceName;
        return $this;
    }
    /**
     * Get areaCode value
     * @return string|null
     */
    public function getAreaCode()
    {
        return $this->areaCode;
    }
    /**
     * Set areaCode value
     * @param string $areaCode
     * @return \AisFssp\StructType\FishDatumType
     */
    public function setAreaCode($areaCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($areaCode) && strlen($areaCode) > 10) || (is_array($areaCode) && count($areaCode) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($areaCode) ? strlen($areaCode) : count($areaCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($areaCode) && strlen($areaCode) < 1) || (is_array($areaCode) && count($areaCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($areaCode) && !is_string($areaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($areaCode)), __LINE__);
        }
        $this->areaCode = $areaCode;
        return $this;
    }
    /**
     * Get areaName value
     * @return string|null
     */
    public function getAreaName()
    {
        return $this->areaName;
    }
    /**
     * Set areaName value
     * @param string $areaName
     * @return \AisFssp\StructType\FishDatumType
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($areaName) && strlen($areaName) > 300) || (is_array($areaName) && count($areaName) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($areaName) ? strlen($areaName) : count($areaName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($areaName) && strlen($areaName) < 1) || (is_array($areaName) && count($areaName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($areaName)), __LINE__);
        }
        $this->areaName = $areaName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\FishDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
