<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtDoc StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ ExtDoc «Исполнительный документ» | ЭП
 * - type: tns:ExtDoc
 * @subpackage Structs
 */
class ExtDoc extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Указывается идентификатор исполнительного документа, присвоенный АИС внешнего контрагента. Уникален в
     * рамках типа документа и конкретного внешнего контрагента. Для ФНС номер исполнительного документа системный (уникальный в пределах
     * данного типа документа) составной в формате СНД, где С- код налоговой по классификатору СОНО, Н – номер постановления - 20 цифровых
     * позиций, Д – дата в формате ДД.ММ.ГГГГ | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Указывается исходящая дата исполнительного документа (Дата постановления) | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The BarCode
     * Meta informations extracted from the WSDL
     * - documentation: Штрих код | Указывается штрих-код органа, выдавшего ИД | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $BarCode;
    /**
     * The IDType
     * Meta informations extracted from the WSDL
     * - documentation: Код вида ИД | Указывается код типа ИД. Поле обязательное для заполнения. Заполняется из справочника «Типы ИД». Справочник
     * заполняется в соответствие с ч. 1 ст. 12 ФЗ-229
     * @var string
     */
    public $IDType;
    /**
     * The IDNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИД | Указывается номер ИД. Поле обязательное для заполнения. Указывается номер исполнительного документа, присвоенный в
     * органе, выдавшем ИД. В случае отсутствия нумерации ИД указывается значение "б/н" | Номер документа
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IDNum;
    /**
     * The IDDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата выдачи ИД | Указывается дата выдачи ИД. Поле обязательное для заполнения в соответствие со статьей 13 ФЗ-229 | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $IDDate;
    /**
     * The IDCopy
     * Meta informations extracted from the WSDL
     * - documentation: Экземпляр ИД | Указывается номер экземпляра ИД. Поле обязательное для заполнения для ИД, выданных на основании решения или
     * приговора суда о взыскании денежных сумм с солидарных ответчиков ст. 429 ГПК РФ | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $IDCopy;
    /**
     * The DeloNum
     * Meta informations extracted from the WSDL
     * - documentation: Номер дела или материалов | Указывается номер дела или материалов, на основании которых выдан ИД. Поле обязательное для
     * заполнения в соответствие со статьей 13 ФЗ-229. В случае отсутствия нумерации указывается значение "б/н". Для ПФР: Номер в соответствии с
     * Требованием об уплате недоимки по страховым взносам, пеней и штрафов (форма № 5-ПФР, утвержденная Приказом МЗСР РФ от 07.12.2009 № 957н) | Строка
     * длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $DeloNum;
    /**
     * The DeloDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата принятия решения по делу | Указывается дата принятия судебного акта, акта другого органа или должностного лица. Поле
     * обязательное для заполнения в соответствие со ст. 13 ФЗ-229. Для ПФР: Дата в соответствии с Требованием об уплате недоимки по страховым
     * взносам, пеней и штрафов (форма № 5-ПФР, утвержденная Приказом МЗСР РФ от 07.12.2009 № 957н) | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DeloDate;
    /**
     * The OrganCode
     * Meta informations extracted from the WSDL
     * - documentation: Код органа, выдавшего ИД | Указывается код органа по ведомственному справочнику ФССП России. Для ФНС: По справочнику СОНО. Для
     * ПФР: По справочнику ТО ПФР. | Строка длиной от 1 до 20 символов
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $OrganCode;
    /**
     * The Organ
     * Meta informations extracted from the WSDL
     * - documentation: Орган, выдавший ИД | Указывается наименование суда или подразделения уполномоченного органа, выдавшего ИД. Поле обязательное
     * для заполнения в соответствие со статьей 13 ФЗ-229. Для ФНС России орган, выдавший ИД заполняется в соответствии с наименованием по
     * справочнику СОНО | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $Organ;
    /**
     * The OrganAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес органа, выдавшего ИД | Указывается адрес, суда или подразделения уполномоченного органа, выдавшего ИД. Поле обязательное
     * для заполнения в соответствие со статьей 13 ФЗ-229. Адрес органа, выдавшего ИД в формате «Код страны» + «запятая» + «Адрес в формате 9 запятых
     * по КЛАДР» или (в случае отсутствия кода страны) в произвольном формате. | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $OrganAdr;
    /**
     * The OrganSignPost
     * Meta informations extracted from the WSDL
     * - documentation: Должность лица вынесшего ИД | Указывается наименование должности лица, вынесшего ИД, по Общероссийскому классификатору
     * профессий рабочих, должностей служащих и тарифных разрядов. Поле обязательное для заполнения. Для ПФР: Руководителя либо заместителя
     * руководителя ТО ПФР | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $OrganSignPost;
    /**
     * The OrganSignFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должностного лица вынесшего ИД | Указывается ФИО должностного лица, выдавшего ИД. Поле обязательное для заполнения в
     * соответствие со статьей 13 ФЗ-229. Для ПФР: Руководителя либо заместителя руководителя ТО ПФР | Полное имя физического лица (фамилия, имя,
     * отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $OrganSignFIO;
    /**
     * The AktDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата вступления решения в законную силу | Указывается дата вступления в законную силу судебного акта, акта другого органа или
     * должностного лица. Поле обязательное для заполнения в соответствие со ст.13 ФЗ-229 | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $AktDate;
    /**
     * The DebtorType
     * Meta informations extracted from the WSDL
     * - documentation: Тип должника | Указывается тип должника по справочнику типов должников/взыскателей ФССП России
     * @var string
     */
    public $DebtorType;
    /**
     * The DebtorName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование должника | Указывается наименование или ФИО должника. Поле обязательное для заполнения в соответствие со статьей
     * 13 ФЗ-229 | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DebtorName;
    /**
     * The DebtorFIO
     * Meta informations extracted from the WSDL
     * - documentation: ФИО должника | Указывается ФИО должника в виде сложного элемента. Поле обязательное для заполнения в соответствие со статьей 13
     * ФЗ-229
     * - minOccurs: 0
     * @var \AisFssp\StructType\FioType
     */
    public $DebtorFIO;
    /**
     * The DebtorAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес должника | Указывается адрес должника (места жительства или пребывания). Поле обязательное для заполнения в соответствие
     * со статьей 13 ФЗ-229. Адрес должника в формате «Код страны» + «запятая» + «Адрес в формате 9 запятых по КЛАДР» или (в случае отсутствия кода
     * страны) в произвольном формате | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorAdr;
    /**
     * The DebtorWorkPl
     * Meta informations extracted from the WSDL
     * - documentation: Место работы | Указывается место работы должника если оно известно | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $DebtorWorkPl;
    /**
     * The DebtorBirthDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата рождения | Указывается дата рождения должника за исключением постановления судебного пристава-исполнителя, судебного
     * приказа, исполнительной надписи нотариуса и нотариально удостоверенного соглашения об уплате алиментов. Поле является
     * условно-обязательным для заполнения, если значение поля «Тип должника» входит в группу «Физические лица» | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DebtorBirthDate;
    /**
     * The DebtorBirthYear
     * Meta informations extracted from the WSDL
     * - documentation: Год рождения ФЛ | Указывается год рождения должника. Поле обязательное для заполнения в соответствие со статьей 13 ФЗ-229, если
     * значение поля «Тип должника» входит в группу «Физические лица» | Год (выпуска, рождения и т. п.)
     * - minOccurs: 0
     * - maxInclusive: 2099
     * - minInclusive: 1900
     * @var string
     */
    public $DebtorBirthYear;
    /**
     * The DebtorBirthPlace
     * Meta informations extracted from the WSDL
     * - documentation: Место рождения | Указывается место рождения должника. Поле обязательное для заполнения в соответствие со статьей 13 ФЗ-229, если
     * значение поля «Тип должника» входит в группу «Физические лица» или равно «Индивидуальный предприниматель» Поле не подлежит
     * обязательному заполнению в судебном приказе (за исключением судебного приказа о взыскании алиментов), исполнительной надписи
     * нотариуса и нотариально удостоверенном соглашении об уплате алиментов. | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $DebtorBirthPlace;
    /**
     * The DebtorINN
     * Meta informations extracted from the WSDL
     * - documentation: ИНН должника | Указывается ИНН должника. Поле обязательное для заполнения в соответствие со ст.13 ФЗ-229, если значение поля «Тип
     * должника» входит в группу «Юридические лица» или равно «ИП» | ИНН
     * - minOccurs: 0
     * - maxLength: 12
     * - minLength: 10
     * - pattern: (([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})
     * @var string
     */
    public $DebtorINN;
    /**
     * The DebtorKPP
     * Meta informations extracted from the WSDL
     * - documentation: КПП | Указывается КПП должника. Поле заполняется, если значение поля «Тип должника» входит в группу «Юридические лица». | КПП
     * - minOccurs: 0
     * - length: 9
     * - pattern: ([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}
     * @var string
     */
    public $DebtorKPP;
    /**
     * The DebtorRegDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации должника ЮЛ | Указывается дата регистрации должника. Поле обязательное для заполнения в соответствие со ст.13
     * ФЗ-229, если значение поля «Тип должника» входит в группу «Юридические лица» или равно «ИП» | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DebtorRegDate;
    /**
     * The DebtorOGRN
     * Meta informations extracted from the WSDL
     * - documentation: ОГРН/ОГРНИП | Указывается ОГРН/ОГРНИП должника. Поле заполняется, если значение поля «Тип должника» входит в группу
     * «Юридические лица». Может заполняться ОГРН/ОГРНИП ЮЛ/ИП. | Основной государственный регистрационный номер (ОГРН)/Основной
     * государственный регистрационный номер индивидуального предпринимателя (ОГРНИП)
     * - minOccurs: 0
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $DebtorOGRN;
    /**
     * The ClaimerType
     * Meta informations extracted from the WSDL
     * - documentation: Тип взыскателя | Указывается тип взыскателя по справочнику типов должников/взыскателей ФССП России
     * @var string
     */
    public $ClaimerType;
    /**
     * The ClaimerName
     * Meta informations extracted from the WSDL
     * - documentation: Взыскатель | Указывается наименование или ФИО взыскателя. Поле обязательное для заполнения в соответствие со статьей 13 ФЗ-229 |
     * Строка длиной от 1 до 1000 символов
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $ClaimerName;
    /**
     * The ClaimerAdr
     * Meta informations extracted from the WSDL
     * - documentation: Адрес взыскателя | Указывается адрес взыскателя. Поле обязательное для заполнения в соответствие со статьей 13 ФЗ-229. Адрес
     * взыскателя в формате «Код страны» + «запятая» + «Адрес в формате 9 запятых по КЛАДР» или (в случае отсутствия кода страны) в произвольном
     * формате | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $ClaimerAdr;
    /**
     * The IDSubj
     * Meta informations extracted from the WSDL
     * - documentation: Тип предмета | Указывается наименование типа предмета исполнения по справочнику «Типы предметов исполнения» в соответствии
     * со справочником НСИ ФССП России. Поле обязательное для исполнения | Код предмета исполнения | NSI_IDoc_Subj_Exec
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $IDSubj;
    /**
     * The IDSubjName
     * Meta informations extracted from the WSDL
     * - documentation: Предмет | Указывается краткая резолютивная часть судебного акта, акта другого органа или должностного лица, на основании
     * которого выдан ИД. Поле обязательное для заполнения в соответствие со ст.13 ФЗ-229. Пример формулировки ТО ПФР: «Произвести взыскание
     * страховых взносов, пеней и штрафов за счет имущества». Пример формулировки ГИБДД: Назначить собственнику (владельцу) транспортного
     * средства административное наказание в виде административного штрафа в размере 1000 рублей | Строка длиной от 1 до 300 символов
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $IDSubjName;
    /**
     * The IDSum
     * Meta informations extracted from the WSDL
     * - documentation: Сумма долга или начисления долга | Указывается общая сумма требований, подлежащих взысканию по ИД. Поле необязательное для
     * заполнения. Для ПФР: Расчетный показатель. Равен общей сумме задолженности по всем контейнерам «Реквизиты для перечисления» по одному
     * Постановлению (в руб.) | Сумма
     * - minOccurs: 0
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $IDSum;
    /**
     * The DebtorEstate
     * Meta informations extracted from the WSDL
     * - documentation: Установочная часть решения | Указывается установочная часть решения, на основании которого был выдан ИД. Поле обязательное для
     * заполнения по ИД, выданных на основании судебного акта, а также для протоколов об административных правонарушениях | Массив
     * произвольных данных (бинарный)
     * - minOccurs: 0
     * @var string
     */
    public $DebtorEstate;
    /**
     * The Period
     * Meta informations extracted from the WSDL
     * - documentation: Периодически | Указывается тип периодического начисления задолженности по ИД по справочнику «Типы периодического
     * начисления». Поле обязательное для заполнения, если значение поля «Сущность исполнения» содержит значение «Алименты» или
     * «Периодические платежи» | Тип периодического начисления долга | NSI_IDoc_Periodic
     * - minOccurs: 0
     * - length: 1
     * @var string
     */
    public $Period;
    /**
     * The PeriodSum
     * Meta informations extracted from the WSDL
     * - documentation: Периодический долг | Указывается сумма или доля начисления задолженности по ИД. Поле обязательное для заполнения, если
     * значение поля «Сущность исполнения» содержит значение «Алименты» или «Периодические платежи» | Строка длиной от 1 до 1000 символов
     * - minOccurs: 0
     * - maxLength: 1000
     * - minLength: 1
     * @var string
     */
    public $PeriodSum;
    /**
     * The Repeat
     * Meta informations extracted from the WSDL
     * - documentation: Признак повторности | Указывается поступил документ первично или повторно | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $Repeat;
    /**
     * The DebtorNo
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер должника | Указывается регистрационный номер должника, присвоенный органом, выдавшим ИД. Для ПФР:
     * Обязателен | Строка длиной от 1 до 20 символов
     * - minOccurs: 0
     * - maxLength: 20
     * - minLength: 1
     * @var string
     */
    public $DebtorNo;
    /**
     * The SrokDobrPFR
     * Meta informations extracted from the WSDL
     * - documentation: Срок добровольного исполнения требования | Указывается срок для добровольного исполнения ИД. Поле обязательное для
     * заполнения. Заполняется в соответствие со ст. 30 ФЗ-229. В соответствии с Требованием об уплате недоимки по страховым взносам, пеней и
     * штрафов (форма № 5-ПФР, утвержденная Приказом МЗСР РФ от 07.12.2009 № 957н) | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $SrokDobrPFR;
    /**
     * The KoAPArticle
     * Meta informations extracted from the WSDL
     * - documentation: Статья КоАП | Указывается статья КОАП или закона субъекта РФ, предусматривающая административную ответственность за
     * совершение административного правонарушения. Поле обязательное для заполнения, если значение поля входит в группу "Штрафы по КОАП" в
     * соответствие со ч.1 ст.29.10 КОАП РФ | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $KoAPArticle;
    /**
     * The KoAPPart
     * Meta informations extracted from the WSDL
     * - documentation: Часть КоАП | Указывается часть статьи КОАП или закона субъекта РФ | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $KoAPPart;
    /**
     * The KoAPPoint
     * Meta informations extracted from the WSDL
     * - documentation: Пункт статьи КоАП | Указывается пункт статьи КОАП или закона субъекта РФ | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $KoAPPoint;
    /**
     * The NoAccount
     * Meta informations extracted from the WSDL
     * - documentation: Признак отсутствия счетов | Указывается факт отсутствия счетов у должника. Поле заполняется, если значение поля «Код типа ИД»
     * равно «5» (Акт органа, осуществляющего контрольные функции) Признак отсутствия информации о счетах должника в ТО ПФР. В случае наличия
     * счетов у плательщика (true), Постановление, направляемое ТО ПФР, сопровождается файлом скана (образа) Справки об отсутствии средств на
     * счетах должника, представляемой банком | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $NoAccount;
    /**
     * The IsDuplicate
     * Meta informations extracted from the WSDL
     * - documentation: Дубликат | Указывается является ли ИД дубликатом. Поле заполняется, если ИД является дубликатом, выданным при утрате
     * подлинника. Если ИД является подлинником, то поле не заполняется (часть 2 ст. 12 ФЗ-229) | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $IsDuplicate;
    /**
     * The IDBase
     * Meta informations extracted from the WSDL
     * - documentation: Исполнительный документ | Оригинал исполнительного документа, вынесенного в соответствии с Постановлением Правительства РФ
     * от 20.10.2015 N 1121 "Об утверждении требований к форматам исполнительных документов, вынесенных и (или) направляемых для исполнения в форме
     * электронного документа" в кодировке Base64.
     * - minOccurs: 0
     * @var string
     */
    public $IDBase;
    /**
     * The SignatureBase
     * Meta informations extracted from the WSDL
     * - documentation: ЭП исполнительного документа | ЭП исполнительного документа вынесенного в электронном виде, элемента «IDBase» в формате pkcs#7
     * - minOccurs: 0
     * @var string
     */
    public $SignatureBase;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения | Уточняющие данные исполнительного документа
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $Data;
    /**
     * The PaymentProperties
     * Meta informations extracted from the WSDL
     * - documentation: Реквизиты для перечисления | Реквизиты для перечисления взысканных сумм взыскателю (для налоговых платежей может быть указано
     * больше одного набора реквизитов)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\PaymentProperties[]
     */
    public $PaymentProperties;
    /**
     * The Sequestration
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об аресте имущества и имеющихся ограничениях | Используется для передачи сведений об аресте имущества и имеющихся
     * ограничениях (постановлении о наложении ареста на имущество должника). Для ФНС России при вынесении постановления по статье 77 НК РФ:
     * Обязателен.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\SequestrationType[]
     */
    public $Sequestration;
    /**
     * The attachments
     * Meta informations extracted from the WSDL
     * - documentation: Прикрепленные файлы
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\AttachmentType[]
     */
    public $attachments;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ExtDoc
     * @uses ExtDoc::setExternalKey()
     * @uses ExtDoc::setDocDate()
     * @uses ExtDoc::setBarCode()
     * @uses ExtDoc::setIDType()
     * @uses ExtDoc::setIDNum()
     * @uses ExtDoc::setIDDate()
     * @uses ExtDoc::setIDCopy()
     * @uses ExtDoc::setDeloNum()
     * @uses ExtDoc::setDeloDate()
     * @uses ExtDoc::setOrganCode()
     * @uses ExtDoc::setOrgan()
     * @uses ExtDoc::setOrganAdr()
     * @uses ExtDoc::setOrganSignPost()
     * @uses ExtDoc::setOrganSignFIO()
     * @uses ExtDoc::setAktDate()
     * @uses ExtDoc::setDebtorType()
     * @uses ExtDoc::setDebtorName()
     * @uses ExtDoc::setDebtorFIO()
     * @uses ExtDoc::setDebtorAdr()
     * @uses ExtDoc::setDebtorWorkPl()
     * @uses ExtDoc::setDebtorBirthDate()
     * @uses ExtDoc::setDebtorBirthYear()
     * @uses ExtDoc::setDebtorBirthPlace()
     * @uses ExtDoc::setDebtorINN()
     * @uses ExtDoc::setDebtorKPP()
     * @uses ExtDoc::setDebtorRegDate()
     * @uses ExtDoc::setDebtorOGRN()
     * @uses ExtDoc::setClaimerType()
     * @uses ExtDoc::setClaimerName()
     * @uses ExtDoc::setClaimerAdr()
     * @uses ExtDoc::setIDSubj()
     * @uses ExtDoc::setIDSubjName()
     * @uses ExtDoc::setIDSum()
     * @uses ExtDoc::setDebtorEstate()
     * @uses ExtDoc::setPeriod()
     * @uses ExtDoc::setPeriodSum()
     * @uses ExtDoc::setRepeat()
     * @uses ExtDoc::setDebtorNo()
     * @uses ExtDoc::setSrokDobrPFR()
     * @uses ExtDoc::setKoAPArticle()
     * @uses ExtDoc::setKoAPPart()
     * @uses ExtDoc::setKoAPPoint()
     * @uses ExtDoc::setNoAccount()
     * @uses ExtDoc::setIsDuplicate()
     * @uses ExtDoc::setIDBase()
     * @uses ExtDoc::setSignatureBase()
     * @uses ExtDoc::setData()
     * @uses ExtDoc::setPaymentProperties()
     * @uses ExtDoc::setSequestration()
     * @uses ExtDoc::setAttachments()
     * @uses ExtDoc::setSignDateTime()
     * @uses ExtDoc::setSignature()
     * @uses ExtDoc::setId()
     * @param string $externalKey
     * @param string $docDate
     * @param string $barCode
     * @param string $iDType
     * @param string $iDNum
     * @param string $iDDate
     * @param int $iDCopy
     * @param string $deloNum
     * @param string $deloDate
     * @param string $organCode
     * @param string $organ
     * @param string $organAdr
     * @param string $organSignPost
     * @param string $organSignFIO
     * @param string $aktDate
     * @param string $debtorType
     * @param string $debtorName
     * @param \AisFssp\StructType\FioType $debtorFIO
     * @param string $debtorAdr
     * @param string $debtorWorkPl
     * @param string $debtorBirthDate
     * @param string $debtorBirthYear
     * @param string $debtorBirthPlace
     * @param string $debtorINN
     * @param string $debtorKPP
     * @param string $debtorRegDate
     * @param string $debtorOGRN
     * @param string $claimerType
     * @param string $claimerName
     * @param string $claimerAdr
     * @param string $iDSubj
     * @param string $iDSubjName
     * @param float $iDSum
     * @param string $debtorEstate
     * @param string $period
     * @param string $periodSum
     * @param bool $repeat
     * @param string $debtorNo
     * @param string $srokDobrPFR
     * @param string $koAPArticle
     * @param string $koAPPart
     * @param string $koAPPoint
     * @param bool $noAccount
     * @param bool $isDuplicate
     * @param string $iDBase
     * @param string $signatureBase
     * @param \AisFssp\StructType\Data[] $data
     * @param \AisFssp\StructType\PaymentProperties[] $paymentProperties
     * @param \AisFssp\StructType\SequestrationType[] $sequestration
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($externalKey = null, $docDate = null, $barCode = null, $iDType = null, $iDNum = null, $iDDate = null, $iDCopy = null, $deloNum = null, $deloDate = null, $organCode = null, $organ = null, $organAdr = null, $organSignPost = null, $organSignFIO = null, $aktDate = null, $debtorType = null, $debtorName = null, \AisFssp\StructType\FioType $debtorFIO = null, $debtorAdr = null, $debtorWorkPl = null, $debtorBirthDate = null, $debtorBirthYear = null, $debtorBirthPlace = null, $debtorINN = null, $debtorKPP = null, $debtorRegDate = null, $debtorOGRN = null, $claimerType = null, $claimerName = null, $claimerAdr = null, $iDSubj = null, $iDSubjName = null, $iDSum = null, $debtorEstate = null, $period = null, $periodSum = null, $repeat = null, $debtorNo = null, $srokDobrPFR = null, $koAPArticle = null, $koAPPart = null, $koAPPoint = null, $noAccount = null, $isDuplicate = null, $iDBase = null, $signatureBase = null, array $data = array(), array $paymentProperties = array(), array $sequestration = array(), array $attachments = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setDocDate($docDate)
            ->setBarCode($barCode)
            ->setIDType($iDType)
            ->setIDNum($iDNum)
            ->setIDDate($iDDate)
            ->setIDCopy($iDCopy)
            ->setDeloNum($deloNum)
            ->setDeloDate($deloDate)
            ->setOrganCode($organCode)
            ->setOrgan($organ)
            ->setOrganAdr($organAdr)
            ->setOrganSignPost($organSignPost)
            ->setOrganSignFIO($organSignFIO)
            ->setAktDate($aktDate)
            ->setDebtorType($debtorType)
            ->setDebtorName($debtorName)
            ->setDebtorFIO($debtorFIO)
            ->setDebtorAdr($debtorAdr)
            ->setDebtorWorkPl($debtorWorkPl)
            ->setDebtorBirthDate($debtorBirthDate)
            ->setDebtorBirthYear($debtorBirthYear)
            ->setDebtorBirthPlace($debtorBirthPlace)
            ->setDebtorINN($debtorINN)
            ->setDebtorKPP($debtorKPP)
            ->setDebtorRegDate($debtorRegDate)
            ->setDebtorOGRN($debtorOGRN)
            ->setClaimerType($claimerType)
            ->setClaimerName($claimerName)
            ->setClaimerAdr($claimerAdr)
            ->setIDSubj($iDSubj)
            ->setIDSubjName($iDSubjName)
            ->setIDSum($iDSum)
            ->setDebtorEstate($debtorEstate)
            ->setPeriod($period)
            ->setPeriodSum($periodSum)
            ->setRepeat($repeat)
            ->setDebtorNo($debtorNo)
            ->setSrokDobrPFR($srokDobrPFR)
            ->setKoAPArticle($koAPArticle)
            ->setKoAPPart($koAPPart)
            ->setKoAPPoint($koAPPoint)
            ->setNoAccount($noAccount)
            ->setIsDuplicate($isDuplicate)
            ->setIDBase($iDBase)
            ->setSignatureBase($signatureBase)
            ->setData($data)
            ->setPaymentProperties($paymentProperties)
            ->setSequestration($sequestration)
            ->setAttachments($attachments)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get BarCode value
     * @return string|null
     */
    public function getBarCode()
    {
        return $this->BarCode;
    }
    /**
     * Set BarCode value
     * @param string $barCode
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setBarCode($barCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($barCode) && strlen($barCode) > 50) || (is_array($barCode) && count($barCode) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($barCode) ? strlen($barCode) : count($barCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($barCode) && strlen($barCode) < 1) || (is_array($barCode) && count($barCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($barCode) && !is_string($barCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($barCode)), __LINE__);
        }
        $this->BarCode = $barCode;
        return $this;
    }
    /**
     * Get IDType value
     * @return string|null
     */
    public function getIDType()
    {
        return $this->IDType;
    }
    /**
     * Set IDType value
     * @uses \AisFssp\EnumType\IdType::valueIsValid()
     * @uses \AisFssp\EnumType\IdType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iDType
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setIDType($iDType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\IdType::valueIsValid($iDType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $iDType, implode(', ', \AisFssp\EnumType\IdType::getValidValues())), __LINE__);
        }
        $this->IDType = $iDType;
        return $this;
    }
    /**
     * Get IDNum value
     * @return string|null
     */
    public function getIDNum()
    {
        return $this->IDNum;
    }
    /**
     * Set IDNum value
     * @param string $iDNum
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setIDNum($iDNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDNum) && strlen($iDNum) > 25) || (is_array($iDNum) && count($iDNum) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($iDNum) ? strlen($iDNum) : count($iDNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDNum) && strlen($iDNum) < 1) || (is_array($iDNum) && count($iDNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDNum) && !is_string($iDNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDNum)), __LINE__);
        }
        $this->IDNum = $iDNum;
        return $this;
    }
    /**
     * Get IDDate value
     * @return string|null
     */
    public function getIDDate()
    {
        return $this->IDDate;
    }
    /**
     * Set IDDate value
     * @param string $iDDate
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setIDDate($iDDate = null)
    {
        // validation for constraint: maxExclusive
        if ($iDDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($iDDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $iDDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDDate) && !is_string($iDDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDDate)), __LINE__);
        }
        $this->IDDate = $iDDate;
        return $this;
    }
    /**
     * Get IDCopy value
     * @return int|null
     */
    public function getIDCopy()
    {
        return $this->IDCopy;
    }
    /**
     * Set IDCopy value
     * @param int $iDCopy
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setIDCopy($iDCopy = null)
    {
        // validation for constraint: maxInclusive
        if ($iDCopy > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $iDCopy), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($iDCopy) && !is_numeric($iDCopy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iDCopy)), __LINE__);
        }
        $this->IDCopy = $iDCopy;
        return $this;
    }
    /**
     * Get DeloNum value
     * @return string|null
     */
    public function getDeloNum()
    {
        return $this->DeloNum;
    }
    /**
     * Set DeloNum value
     * @param string $deloNum
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDeloNum($deloNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($deloNum) && strlen($deloNum) > 50) || (is_array($deloNum) && count($deloNum) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($deloNum) ? strlen($deloNum) : count($deloNum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($deloNum) && strlen($deloNum) < 1) || (is_array($deloNum) && count($deloNum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deloNum) && !is_string($deloNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deloNum)), __LINE__);
        }
        $this->DeloNum = $deloNum;
        return $this;
    }
    /**
     * Get DeloDate value
     * @return string|null
     */
    public function getDeloDate()
    {
        return $this->DeloDate;
    }
    /**
     * Set DeloDate value
     * @param string $deloDate
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDeloDate($deloDate = null)
    {
        // validation for constraint: maxExclusive
        if ($deloDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $deloDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($deloDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $deloDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($deloDate) && !is_string($deloDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deloDate)), __LINE__);
        }
        $this->DeloDate = $deloDate;
        return $this;
    }
    /**
     * Get OrganCode value
     * @return string|null
     */
    public function getOrganCode()
    {
        return $this->OrganCode;
    }
    /**
     * Set OrganCode value
     * @param string $organCode
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setOrganCode($organCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organCode) && strlen($organCode) > 20) || (is_array($organCode) && count($organCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($organCode) ? strlen($organCode) : count($organCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organCode) && strlen($organCode) < 1) || (is_array($organCode) && count($organCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organCode) && !is_string($organCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organCode)), __LINE__);
        }
        $this->OrganCode = $organCode;
        return $this;
    }
    /**
     * Get Organ value
     * @return string|null
     */
    public function getOrgan()
    {
        return $this->Organ;
    }
    /**
     * Set Organ value
     * @param string $organ
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setOrgan($organ = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organ) && strlen($organ) > 300) || (is_array($organ) && count($organ) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($organ) ? strlen($organ) : count($organ)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organ) && strlen($organ) < 1) || (is_array($organ) && count($organ) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organ) && !is_string($organ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organ)), __LINE__);
        }
        $this->Organ = $organ;
        return $this;
    }
    /**
     * Get OrganAdr value
     * @return string|null
     */
    public function getOrganAdr()
    {
        return $this->OrganAdr;
    }
    /**
     * Set OrganAdr value
     * @param string $organAdr
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setOrganAdr($organAdr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organAdr) && strlen($organAdr) > 300) || (is_array($organAdr) && count($organAdr) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($organAdr) ? strlen($organAdr) : count($organAdr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organAdr) && strlen($organAdr) < 1) || (is_array($organAdr) && count($organAdr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organAdr) && !is_string($organAdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organAdr)), __LINE__);
        }
        $this->OrganAdr = $organAdr;
        return $this;
    }
    /**
     * Get OrganSignPost value
     * @return string|null
     */
    public function getOrganSignPost()
    {
        return $this->OrganSignPost;
    }
    /**
     * Set OrganSignPost value
     * @param string $organSignPost
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setOrganSignPost($organSignPost = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organSignPost) && strlen($organSignPost) > 300) || (is_array($organSignPost) && count($organSignPost) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($organSignPost) ? strlen($organSignPost) : count($organSignPost)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organSignPost) && strlen($organSignPost) < 1) || (is_array($organSignPost) && count($organSignPost) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organSignPost) && !is_string($organSignPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organSignPost)), __LINE__);
        }
        $this->OrganSignPost = $organSignPost;
        return $this;
    }
    /**
     * Get OrganSignFIO value
     * @return string|null
     */
    public function getOrganSignFIO()
    {
        return $this->OrganSignFIO;
    }
    /**
     * Set OrganSignFIO value
     * @param string $organSignFIO
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setOrganSignFIO($organSignFIO = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($organSignFIO) && strlen($organSignFIO) > 100) || (is_array($organSignFIO) && count($organSignFIO) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($organSignFIO) ? strlen($organSignFIO) : count($organSignFIO)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($organSignFIO) && strlen($organSignFIO) < 1) || (is_array($organSignFIO) && count($organSignFIO) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($organSignFIO) && !is_string($organSignFIO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organSignFIO)), __LINE__);
        }
        $this->OrganSignFIO = $organSignFIO;
        return $this;
    }
    /**
     * Get AktDate value
     * @return string|null
     */
    public function getAktDate()
    {
        return $this->AktDate;
    }
    /**
     * Set AktDate value
     * @param string $aktDate
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setAktDate($aktDate = null)
    {
        // validation for constraint: maxExclusive
        if ($aktDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $aktDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($aktDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $aktDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($aktDate) && !is_string($aktDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aktDate)), __LINE__);
        }
        $this->AktDate = $aktDate;
        return $this;
    }
    /**
     * Get DebtorType value
     * @return string|null
     */
    public function getDebtorType()
    {
        return $this->DebtorType;
    }
    /**
     * Set DebtorType value
     * @uses \AisFssp\EnumType\ContragentType::valueIsValid()
     * @uses \AisFssp\EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $debtorType
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorType($debtorType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ContragentType::valueIsValid($debtorType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $debtorType, implode(', ', \AisFssp\EnumType\ContragentType::getValidValues())), __LINE__);
        }
        $this->DebtorType = $debtorType;
        return $this;
    }
    /**
     * Get DebtorName value
     * @return string|null
     */
    public function getDebtorName()
    {
        return $this->DebtorName;
    }
    /**
     * Set DebtorName value
     * @param string $debtorName
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorName($debtorName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorName) && strlen($debtorName) > 1000) || (is_array($debtorName) && count($debtorName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($debtorName) ? strlen($debtorName) : count($debtorName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorName) && strlen($debtorName) < 1) || (is_array($debtorName) && count($debtorName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorName) && !is_string($debtorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorName)), __LINE__);
        }
        $this->DebtorName = $debtorName;
        return $this;
    }
    /**
     * Get DebtorFIO value
     * @return \AisFssp\StructType\FioType|null
     */
    public function getDebtorFIO()
    {
        return $this->DebtorFIO;
    }
    /**
     * Set DebtorFIO value
     * @param \AisFssp\StructType\FioType $debtorFIO
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorFIO(\AisFssp\StructType\FioType $debtorFIO = null)
    {
        $this->DebtorFIO = $debtorFIO;
        return $this;
    }
    /**
     * Get DebtorAdr value
     * @return string|null
     */
    public function getDebtorAdr()
    {
        return $this->DebtorAdr;
    }
    /**
     * Set DebtorAdr value
     * @param string $debtorAdr
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorAdr($debtorAdr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorAdr) && strlen($debtorAdr) > 300) || (is_array($debtorAdr) && count($debtorAdr) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($debtorAdr) ? strlen($debtorAdr) : count($debtorAdr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorAdr) && strlen($debtorAdr) < 1) || (is_array($debtorAdr) && count($debtorAdr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorAdr) && !is_string($debtorAdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorAdr)), __LINE__);
        }
        $this->DebtorAdr = $debtorAdr;
        return $this;
    }
    /**
     * Get DebtorWorkPl value
     * @return string|null
     */
    public function getDebtorWorkPl()
    {
        return $this->DebtorWorkPl;
    }
    /**
     * Set DebtorWorkPl value
     * @param string $debtorWorkPl
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorWorkPl($debtorWorkPl = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorWorkPl) && strlen($debtorWorkPl) > 1000) || (is_array($debtorWorkPl) && count($debtorWorkPl) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($debtorWorkPl) ? strlen($debtorWorkPl) : count($debtorWorkPl)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorWorkPl) && strlen($debtorWorkPl) < 1) || (is_array($debtorWorkPl) && count($debtorWorkPl) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorWorkPl) && !is_string($debtorWorkPl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorWorkPl)), __LINE__);
        }
        $this->DebtorWorkPl = $debtorWorkPl;
        return $this;
    }
    /**
     * Get DebtorBirthDate value
     * @return string|null
     */
    public function getDebtorBirthDate()
    {
        return $this->DebtorBirthDate;
    }
    /**
     * Set DebtorBirthDate value
     * @param string $debtorBirthDate
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorBirthDate($debtorBirthDate = null)
    {
        // validation for constraint: maxExclusive
        if ($debtorBirthDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $debtorBirthDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorBirthDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorBirthDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthDate) && !is_string($debtorBirthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthDate)), __LINE__);
        }
        $this->DebtorBirthDate = $debtorBirthDate;
        return $this;
    }
    /**
     * Get DebtorBirthYear value
     * @return string|null
     */
    public function getDebtorBirthYear()
    {
        return $this->DebtorBirthYear;
    }
    /**
     * Set DebtorBirthYear value
     * @param string $debtorBirthYear
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorBirthYear($debtorBirthYear = null)
    {
        // validation for constraint: maxInclusive
        if ($debtorBirthYear > 2099) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2099, "%s" given', $debtorBirthYear), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorBirthYear < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorBirthYear), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthYear) && !is_string($debtorBirthYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthYear)), __LINE__);
        }
        $this->DebtorBirthYear = $debtorBirthYear;
        return $this;
    }
    /**
     * Get DebtorBirthPlace value
     * @return string|null
     */
    public function getDebtorBirthPlace()
    {
        return $this->DebtorBirthPlace;
    }
    /**
     * Set DebtorBirthPlace value
     * @param string $debtorBirthPlace
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorBirthPlace($debtorBirthPlace = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorBirthPlace) && strlen($debtorBirthPlace) > 300) || (is_array($debtorBirthPlace) && count($debtorBirthPlace) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($debtorBirthPlace) ? strlen($debtorBirthPlace) : count($debtorBirthPlace)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorBirthPlace) && strlen($debtorBirthPlace) < 1) || (is_array($debtorBirthPlace) && count($debtorBirthPlace) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorBirthPlace) && !is_string($debtorBirthPlace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorBirthPlace)), __LINE__);
        }
        $this->DebtorBirthPlace = $debtorBirthPlace;
        return $this;
    }
    /**
     * Get DebtorINN value
     * @return string|null
     */
    public function getDebtorINN()
    {
        return $this->DebtorINN;
    }
    /**
     * Set DebtorINN value
     * @param string $debtorINN
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorINN($debtorINN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorINN) && strlen($debtorINN) > 12) || (is_array($debtorINN) && count($debtorINN) > 12)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 12 element(s) or a scalar of 12 character(s) at most, "%d" length given', is_scalar($debtorINN) ? strlen($debtorINN) : count($debtorINN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorINN) && strlen($debtorINN) < 10) || (is_array($debtorINN) && count($debtorINN) < 10)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorINN) && !preg_match('/(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})/', $debtorINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{8})|(([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{10})", "%s" given', var_export($debtorINN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorINN) && !is_string($debtorINN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorINN)), __LINE__);
        }
        $this->DebtorINN = $debtorINN;
        return $this;
    }
    /**
     * Get DebtorKPP value
     * @return string|null
     */
    public function getDebtorKPP()
    {
        return $this->DebtorKPP;
    }
    /**
     * Set DebtorKPP value
     * @param string $debtorKPP
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorKPP($debtorKPP = null)
    {
        // validation for constraint: length
        if ((is_scalar($debtorKPP) && strlen($debtorKPP) !== 9) || (is_array($debtorKPP) && count($debtorKPP) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorKPP) && !preg_match('/([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}/', $debtorKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{1}[1-9]{1}|[1-9]{1}[0-9]{1})[0-9]{7}", "%s" given', var_export($debtorKPP, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorKPP) && !is_string($debtorKPP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorKPP)), __LINE__);
        }
        $this->DebtorKPP = $debtorKPP;
        return $this;
    }
    /**
     * Get DebtorRegDate value
     * @return string|null
     */
    public function getDebtorRegDate()
    {
        return $this->DebtorRegDate;
    }
    /**
     * Set DebtorRegDate value
     * @param string $debtorRegDate
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorRegDate($debtorRegDate = null)
    {
        // validation for constraint: maxExclusive
        if ($debtorRegDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $debtorRegDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($debtorRegDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $debtorRegDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorRegDate) && !is_string($debtorRegDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorRegDate)), __LINE__);
        }
        $this->DebtorRegDate = $debtorRegDate;
        return $this;
    }
    /**
     * Get DebtorOGRN value
     * @return string|null
     */
    public function getDebtorOGRN()
    {
        return $this->DebtorOGRN;
    }
    /**
     * Set DebtorOGRN value
     * @param string $debtorOGRN
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorOGRN($debtorOGRN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorOGRN) && strlen($debtorOGRN) > 15) || (is_array($debtorOGRN) && count($debtorOGRN) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($debtorOGRN) ? strlen($debtorOGRN) : count($debtorOGRN)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorOGRN) && strlen($debtorOGRN) < 13) || (is_array($debtorOGRN) && count($debtorOGRN) < 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($debtorOGRN) && !preg_match('/([0-9]{13})|([0-9]{15})/', $debtorOGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{13})|([0-9]{15})", "%s" given', var_export($debtorOGRN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorOGRN) && !is_string($debtorOGRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorOGRN)), __LINE__);
        }
        $this->DebtorOGRN = $debtorOGRN;
        return $this;
    }
    /**
     * Get ClaimerType value
     * @return string|null
     */
    public function getClaimerType()
    {
        return $this->ClaimerType;
    }
    /**
     * Set ClaimerType value
     * @uses \AisFssp\EnumType\ContragentType::valueIsValid()
     * @uses \AisFssp\EnumType\ContragentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claimerType
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setClaimerType($claimerType = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\ContragentType::valueIsValid($claimerType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $claimerType, implode(', ', \AisFssp\EnumType\ContragentType::getValidValues())), __LINE__);
        }
        $this->ClaimerType = $claimerType;
        return $this;
    }
    /**
     * Get ClaimerName value
     * @return string|null
     */
    public function getClaimerName()
    {
        return $this->ClaimerName;
    }
    /**
     * Set ClaimerName value
     * @param string $claimerName
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setClaimerName($claimerName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($claimerName) && strlen($claimerName) > 1000) || (is_array($claimerName) && count($claimerName) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($claimerName) ? strlen($claimerName) : count($claimerName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($claimerName) && strlen($claimerName) < 1) || (is_array($claimerName) && count($claimerName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($claimerName) && !is_string($claimerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($claimerName)), __LINE__);
        }
        $this->ClaimerName = $claimerName;
        return $this;
    }
    /**
     * Get ClaimerAdr value
     * @return string|null
     */
    public function getClaimerAdr()
    {
        return $this->ClaimerAdr;
    }
    /**
     * Set ClaimerAdr value
     * @param string $claimerAdr
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setClaimerAdr($claimerAdr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($claimerAdr) && strlen($claimerAdr) > 300) || (is_array($claimerAdr) && count($claimerAdr) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($claimerAdr) ? strlen($claimerAdr) : count($claimerAdr)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($claimerAdr) && strlen($claimerAdr) < 1) || (is_array($claimerAdr) && count($claimerAdr) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($claimerAdr) && !is_string($claimerAdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($claimerAdr)), __LINE__);
        }
        $this->ClaimerAdr = $claimerAdr;
        return $this;
    }
    /**
     * Get IDSubj value
     * @return string|null
     */
    public function getIDSubj()
    {
        return $this->IDSubj;
    }
    /**
     * Set IDSubj value
     * @param string $iDSubj
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setIDSubj($iDSubj = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDSubj) && strlen($iDSubj) > 8) || (is_array($iDSubj) && count($iDSubj) > 8)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 8 element(s) or a scalar of 8 character(s) at most, "%d" length given', is_scalar($iDSubj) ? strlen($iDSubj) : count($iDSubj)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDSubj) && strlen($iDSubj) < 1) || (is_array($iDSubj) && count($iDSubj) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDSubj) && !is_string($iDSubj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDSubj)), __LINE__);
        }
        $this->IDSubj = $iDSubj;
        return $this;
    }
    /**
     * Get IDSubjName value
     * @return string|null
     */
    public function getIDSubjName()
    {
        return $this->IDSubjName;
    }
    /**
     * Set IDSubjName value
     * @param string $iDSubjName
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setIDSubjName($iDSubjName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iDSubjName) && strlen($iDSubjName) > 300) || (is_array($iDSubjName) && count($iDSubjName) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($iDSubjName) ? strlen($iDSubjName) : count($iDSubjName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($iDSubjName) && strlen($iDSubjName) < 1) || (is_array($iDSubjName) && count($iDSubjName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDSubjName) && !is_string($iDSubjName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDSubjName)), __LINE__);
        }
        $this->IDSubjName = $iDSubjName;
        return $this;
    }
    /**
     * Get IDSum value
     * @return float|null
     */
    public function getIDSum()
    {
        return $this->IDSum;
    }
    /**
     * Set IDSum value
     * @param float $iDSum
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setIDSum($iDSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($iDSum) && strlen(substr($iDSum, strpos($iDSum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($iDSum, strpos($iDSum, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits
        if (is_float($iDSum) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $iDSum)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($iDSum, strpos($iDSum, '.')))), __LINE__);
        }
        $this->IDSum = $iDSum;
        return $this;
    }
    /**
     * Get DebtorEstate value
     * @return string|null
     */
    public function getDebtorEstate()
    {
        return $this->DebtorEstate;
    }
    /**
     * Set DebtorEstate value
     * @param string $debtorEstate
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorEstate($debtorEstate = null)
    {
        // validation for constraint: string
        if (!is_null($debtorEstate) && !is_string($debtorEstate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorEstate)), __LINE__);
        }
        $this->DebtorEstate = $debtorEstate;
        return $this;
    }
    /**
     * Get Period value
     * @return string|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param string $period
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setPeriod($period = null)
    {
        // validation for constraint: length
        if ((is_scalar($period) && strlen($period) !== 1) || (is_array($period) && count($period) !== 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($period) && !is_string($period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($period)), __LINE__);
        }
        $this->Period = $period;
        return $this;
    }
    /**
     * Get PeriodSum value
     * @return string|null
     */
    public function getPeriodSum()
    {
        return $this->PeriodSum;
    }
    /**
     * Set PeriodSum value
     * @param string $periodSum
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setPeriodSum($periodSum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($periodSum) && strlen($periodSum) > 1000) || (is_array($periodSum) && count($periodSum) > 1000)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1000 element(s) or a scalar of 1000 character(s) at most, "%d" length given', is_scalar($periodSum) ? strlen($periodSum) : count($periodSum)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($periodSum) && strlen($periodSum) < 1) || (is_array($periodSum) && count($periodSum) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($periodSum) && !is_string($periodSum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodSum)), __LINE__);
        }
        $this->PeriodSum = $periodSum;
        return $this;
    }
    /**
     * Get Repeat value
     * @return bool|null
     */
    public function getRepeat()
    {
        return $this->Repeat;
    }
    /**
     * Set Repeat value
     * @param bool $repeat
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setRepeat($repeat = null)
    {
        // validation for constraint: boolean
        if (!is_null($repeat) && !is_bool($repeat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($repeat)), __LINE__);
        }
        $this->Repeat = $repeat;
        return $this;
    }
    /**
     * Get DebtorNo value
     * @return string|null
     */
    public function getDebtorNo()
    {
        return $this->DebtorNo;
    }
    /**
     * Set DebtorNo value
     * @param string $debtorNo
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setDebtorNo($debtorNo = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($debtorNo) && strlen($debtorNo) > 20) || (is_array($debtorNo) && count($debtorNo) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($debtorNo) ? strlen($debtorNo) : count($debtorNo)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($debtorNo) && strlen($debtorNo) < 1) || (is_array($debtorNo) && count($debtorNo) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($debtorNo) && !is_string($debtorNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($debtorNo)), __LINE__);
        }
        $this->DebtorNo = $debtorNo;
        return $this;
    }
    /**
     * Get SrokDobrPFR value
     * @return string|null
     */
    public function getSrokDobrPFR()
    {
        return $this->SrokDobrPFR;
    }
    /**
     * Set SrokDobrPFR value
     * @param string $srokDobrPFR
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setSrokDobrPFR($srokDobrPFR = null)
    {
        // validation for constraint: maxExclusive
        if ($srokDobrPFR >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $srokDobrPFR), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($srokDobrPFR < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $srokDobrPFR), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($srokDobrPFR) && !is_string($srokDobrPFR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($srokDobrPFR)), __LINE__);
        }
        $this->SrokDobrPFR = $srokDobrPFR;
        return $this;
    }
    /**
     * Get KoAPArticle value
     * @return string|null
     */
    public function getKoAPArticle()
    {
        return $this->KoAPArticle;
    }
    /**
     * Set KoAPArticle value
     * @param string $koAPArticle
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setKoAPArticle($koAPArticle = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($koAPArticle) && strlen($koAPArticle) > 10) || (is_array($koAPArticle) && count($koAPArticle) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($koAPArticle) ? strlen($koAPArticle) : count($koAPArticle)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($koAPArticle) && strlen($koAPArticle) < 1) || (is_array($koAPArticle) && count($koAPArticle) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($koAPArticle) && !is_string($koAPArticle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($koAPArticle)), __LINE__);
        }
        $this->KoAPArticle = $koAPArticle;
        return $this;
    }
    /**
     * Get KoAPPart value
     * @return string|null
     */
    public function getKoAPPart()
    {
        return $this->KoAPPart;
    }
    /**
     * Set KoAPPart value
     * @param string $koAPPart
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setKoAPPart($koAPPart = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($koAPPart) && strlen($koAPPart) > 10) || (is_array($koAPPart) && count($koAPPart) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($koAPPart) ? strlen($koAPPart) : count($koAPPart)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($koAPPart) && strlen($koAPPart) < 1) || (is_array($koAPPart) && count($koAPPart) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($koAPPart) && !is_string($koAPPart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($koAPPart)), __LINE__);
        }
        $this->KoAPPart = $koAPPart;
        return $this;
    }
    /**
     * Get KoAPPoint value
     * @return string|null
     */
    public function getKoAPPoint()
    {
        return $this->KoAPPoint;
    }
    /**
     * Set KoAPPoint value
     * @param string $koAPPoint
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setKoAPPoint($koAPPoint = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($koAPPoint) && strlen($koAPPoint) > 10) || (is_array($koAPPoint) && count($koAPPoint) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($koAPPoint) ? strlen($koAPPoint) : count($koAPPoint)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($koAPPoint) && strlen($koAPPoint) < 1) || (is_array($koAPPoint) && count($koAPPoint) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($koAPPoint) && !is_string($koAPPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($koAPPoint)), __LINE__);
        }
        $this->KoAPPoint = $koAPPoint;
        return $this;
    }
    /**
     * Get NoAccount value
     * @return bool|null
     */
    public function getNoAccount()
    {
        return $this->NoAccount;
    }
    /**
     * Set NoAccount value
     * @param bool $noAccount
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setNoAccount($noAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($noAccount) && !is_bool($noAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($noAccount)), __LINE__);
        }
        $this->NoAccount = $noAccount;
        return $this;
    }
    /**
     * Get IsDuplicate value
     * @return bool|null
     */
    public function getIsDuplicate()
    {
        return $this->IsDuplicate;
    }
    /**
     * Set IsDuplicate value
     * @param bool $isDuplicate
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setIsDuplicate($isDuplicate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDuplicate) && !is_bool($isDuplicate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDuplicate)), __LINE__);
        }
        $this->IsDuplicate = $isDuplicate;
        return $this;
    }
    /**
     * Get IDBase value
     * @return string|null
     */
    public function getIDBase()
    {
        return $this->IDBase;
    }
    /**
     * Set IDBase value
     * @param string $iDBase
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setIDBase($iDBase = null)
    {
        // validation for constraint: string
        if (!is_null($iDBase) && !is_string($iDBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDBase)), __LINE__);
        }
        $this->IDBase = $iDBase;
        return $this;
    }
    /**
     * Get SignatureBase value
     * @return string|null
     */
    public function getSignatureBase()
    {
        return $this->SignatureBase;
    }
    /**
     * Set SignatureBase value
     * @param string $signatureBase
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setSignatureBase($signatureBase = null)
    {
        // validation for constraint: string
        if (!is_null($signatureBase) && !is_string($signatureBase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signatureBase)), __LINE__);
        }
        $this->SignatureBase = $signatureBase;
        return $this;
    }
    /**
     * Get Data value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $data
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setData(array $data = array())
    {
        foreach ($data as $extDocDataItem) {
            // validation for constraint: itemType
            if (!$extDocDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($extDocDataItem) ? get_class($extDocDataItem) : gettype($extDocDataItem)), __LINE__);
            }
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Add item to Data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\ExtDoc
     */
    public function addToData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The Data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Data[] = $item;
        return $this;
    }
    /**
     * Get PaymentProperties value
     * @return \AisFssp\StructType\PaymentProperties[]|null
     */
    public function getPaymentProperties()
    {
        return $this->PaymentProperties;
    }
    /**
     * Set PaymentProperties value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\PaymentProperties[] $paymentProperties
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setPaymentProperties(array $paymentProperties = array())
    {
        foreach ($paymentProperties as $extDocPaymentPropertiesItem) {
            // validation for constraint: itemType
            if (!$extDocPaymentPropertiesItem instanceof \AisFssp\StructType\PaymentProperties) {
                throw new \InvalidArgumentException(sprintf('The PaymentProperties property can only contain items of \AisFssp\StructType\PaymentProperties, "%s" given', is_object($extDocPaymentPropertiesItem) ? get_class($extDocPaymentPropertiesItem) : gettype($extDocPaymentPropertiesItem)), __LINE__);
            }
        }
        $this->PaymentProperties = $paymentProperties;
        return $this;
    }
    /**
     * Add item to PaymentProperties value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\PaymentProperties $item
     * @return \AisFssp\StructType\ExtDoc
     */
    public function addToPaymentProperties(\AisFssp\StructType\PaymentProperties $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\PaymentProperties) {
            throw new \InvalidArgumentException(sprintf('The PaymentProperties property can only contain items of \AisFssp\StructType\PaymentProperties, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentProperties[] = $item;
        return $this;
    }
    /**
     * Get Sequestration value
     * @return \AisFssp\StructType\SequestrationType[]|null
     */
    public function getSequestration()
    {
        return $this->Sequestration;
    }
    /**
     * Set Sequestration value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SequestrationType[] $sequestration
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setSequestration(array $sequestration = array())
    {
        foreach ($sequestration as $extDocSequestrationItem) {
            // validation for constraint: itemType
            if (!$extDocSequestrationItem instanceof \AisFssp\StructType\SequestrationType) {
                throw new \InvalidArgumentException(sprintf('The Sequestration property can only contain items of \AisFssp\StructType\SequestrationType, "%s" given', is_object($extDocSequestrationItem) ? get_class($extDocSequestrationItem) : gettype($extDocSequestrationItem)), __LINE__);
            }
        }
        $this->Sequestration = $sequestration;
        return $this;
    }
    /**
     * Add item to Sequestration value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SequestrationType $item
     * @return \AisFssp\StructType\ExtDoc
     */
    public function addToSequestration(\AisFssp\StructType\SequestrationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SequestrationType) {
            throw new \InvalidArgumentException(sprintf('The Sequestration property can only contain items of \AisFssp\StructType\SequestrationType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Sequestration[] = $item;
        return $this;
    }
    /**
     * Get attachments value
     * @return \AisFssp\StructType\AttachmentType[]|null
     */
    public function getAttachments()
    {
        return $this->attachments;
    }
    /**
     * Set attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType[] $attachments
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setAttachments(array $attachments = array())
    {
        foreach ($attachments as $extDocAttachmentsItem) {
            // validation for constraint: itemType
            if (!$extDocAttachmentsItem instanceof \AisFssp\StructType\AttachmentType) {
                throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($extDocAttachmentsItem) ? get_class($extDocAttachmentsItem) : gettype($extDocAttachmentsItem)), __LINE__);
            }
        }
        $this->attachments = $attachments;
        return $this;
    }
    /**
     * Add item to attachments value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\AttachmentType $item
     * @return \AisFssp\StructType\ExtDoc
     */
    public function addToAttachments(\AisFssp\StructType\AttachmentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\AttachmentType) {
            throw new \InvalidArgumentException(sprintf('The attachments property can only contain items of \AisFssp\StructType\AttachmentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attachments[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $extDocSignatureItem) {
            // validation for constraint: itemType
            if (!$extDocSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($extDocSignatureItem) ? get_class($extDocSignatureItem) : gettype($extDocSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\ExtDoc
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\ExtDoc
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ExtDoc
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
