<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExitRestrictionActInfo StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о наличии постановления об ограничении выезда | ЭП
 * - type: tns:ExitRestrictionActInfo
 * @subpackage Structs
 */
class ExitRestrictionActInfo extends AbstractStructBase
{
    /**
     * The internalKey
     * Meta informations extracted from the WSDL
     * - documentation: Ключ ФССП России | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $internalKey;
    /**
     * The requestKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор запроса АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $requestKey;
    /**
     * The isActExists
     * Meta informations extracted from the WSDL
     * - documentation: Признак наличия постановления | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $isActExists;
    /**
     * The docDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата постановления | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $docDate;
    /**
     * The docNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер постановления | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $docNumber;
    /**
     * The term
     * Meta informations extracted from the WSDL
     * - documentation: Срок действия | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $term;
    /**
     * The spiKey
     * Meta informations extracted from the WSDL
     * - documentation: Код СПИ | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении объекта от
     * контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $spiKey;
    /**
     * The spiName
     * Meta informations extracted from the WSDL
     * - documentation: ФИО СПИ | Полное имя физического лица (фамилия, имя, отчество)
     * - minOccurs: 0
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $spiName;
    /**
     * The spiPostCode
     * Meta informations extracted from the WSDL
     * - documentation: Код должности СПИ | Код должности СПИ
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * - pattern: [0-9\-\.\s]+
     * @var string
     */
    public $spiPostCode;
    /**
     * The spiPostName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование должности СПИ | Строка длиной от 1 до 50 символов
     * - minOccurs: 0
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $spiPostName;
    /**
     * The docCode
     * Meta informations extracted from the WSDL
     * - documentation: Код документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного документооборота | NSI_Document |
     * Наименование объекта NCORE
     * - minOccurs: 0
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $docCode;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - documentation: Основание решения СПИ | Строка длиной от 1 до 300 символов
     * - minOccurs: 0
     * - maxLength: 300
     * - minLength: 1
     * @var string
     */
    public $reason;
    /**
     * The article
     * Meta informations extracted from the WSDL
     * - documentation: Статья | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $article;
    /**
     * The point
     * Meta informations extracted from the WSDL
     * - documentation: Пункт статьи | Пункт статьи основания | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $point;
    /**
     * The part
     * Meta informations extracted from the WSDL
     * - documentation: Подпункт | Строка длиной от 1 до 10 символов
     * - minOccurs: 0
     * - maxLength: 10
     * - minLength: 1
     * @var string
     */
    public $part;
    /**
     * The ip
     * Meta informations extracted from the WSDL
     * - documentation: ИП
     * - minOccurs: 0
     * @var \AisFssp\StructType\IP
     */
    public $ip;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - documentation: Сведения
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\Data[]
     */
    public $data;
    /**
     * The SignDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время формирования подписи | Дата и время | Дата и время
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $SignDateTime;
    /**
     * The Signature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: ds:Signature
     * @var \AisFssp\StructType\SignatureType[]
     */
    public $Signature;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: Атрибут документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $Id;
    /**
     * Constructor method for ExitRestrictionActInfo
     * @uses ExitRestrictionActInfo::setInternalKey()
     * @uses ExitRestrictionActInfo::setRequestKey()
     * @uses ExitRestrictionActInfo::setIsActExists()
     * @uses ExitRestrictionActInfo::setDocDate()
     * @uses ExitRestrictionActInfo::setDocNumber()
     * @uses ExitRestrictionActInfo::setTerm()
     * @uses ExitRestrictionActInfo::setSpiKey()
     * @uses ExitRestrictionActInfo::setSpiName()
     * @uses ExitRestrictionActInfo::setSpiPostCode()
     * @uses ExitRestrictionActInfo::setSpiPostName()
     * @uses ExitRestrictionActInfo::setDocCode()
     * @uses ExitRestrictionActInfo::setReason()
     * @uses ExitRestrictionActInfo::setArticle()
     * @uses ExitRestrictionActInfo::setPoint()
     * @uses ExitRestrictionActInfo::setPart()
     * @uses ExitRestrictionActInfo::setIp()
     * @uses ExitRestrictionActInfo::setData()
     * @uses ExitRestrictionActInfo::setSignDateTime()
     * @uses ExitRestrictionActInfo::setSignature()
     * @uses ExitRestrictionActInfo::setId()
     * @param int $internalKey
     * @param string $requestKey
     * @param bool $isActExists
     * @param string $docDate
     * @param string $docNumber
     * @param string $term
     * @param int $spiKey
     * @param string $spiName
     * @param string $spiPostCode
     * @param string $spiPostName
     * @param string $docCode
     * @param string $reason
     * @param string $article
     * @param string $point
     * @param string $part
     * @param \AisFssp\StructType\IP $ip
     * @param \AisFssp\StructType\Data[] $data
     * @param string $signDateTime
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @param string $id
     */
    public function __construct($internalKey = null, $requestKey = null, $isActExists = null, $docDate = null, $docNumber = null, $term = null, $spiKey = null, $spiName = null, $spiPostCode = null, $spiPostName = null, $docCode = null, $reason = null, $article = null, $point = null, $part = null, \AisFssp\StructType\IP $ip = null, array $data = array(), $signDateTime = null, array $signature = array(), $id = null)
    {
        $this
            ->setInternalKey($internalKey)
            ->setRequestKey($requestKey)
            ->setIsActExists($isActExists)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setTerm($term)
            ->setSpiKey($spiKey)
            ->setSpiName($spiName)
            ->setSpiPostCode($spiPostCode)
            ->setSpiPostName($spiPostName)
            ->setDocCode($docCode)
            ->setReason($reason)
            ->setArticle($article)
            ->setPoint($point)
            ->setPart($part)
            ->setIp($ip)
            ->setData($data)
            ->setSignDateTime($signDateTime)
            ->setSignature($signature)
            ->setId($id);
    }
    /**
     * Get internalKey value
     * @return int|null
     */
    public function getInternalKey()
    {
        return $this->internalKey;
    }
    /**
     * Set internalKey value
     * @param int $internalKey
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setInternalKey($internalKey = null)
    {
        // validation for constraint: maxInclusive
        if ($internalKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($internalKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $internalKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($internalKey) && !is_numeric($internalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalKey)), __LINE__);
        }
        $this->internalKey = $internalKey;
        return $this;
    }
    /**
     * Get requestKey value
     * @return string|null
     */
    public function getRequestKey()
    {
        return $this->requestKey;
    }
    /**
     * Set requestKey value
     * @param string $requestKey
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setRequestKey($requestKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($requestKey) && strlen($requestKey) > 60) || (is_array($requestKey) && count($requestKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($requestKey) ? strlen($requestKey) : count($requestKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($requestKey) && strlen($requestKey) < 1) || (is_array($requestKey) && count($requestKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($requestKey) && !is_string($requestKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($requestKey)), __LINE__);
        }
        $this->requestKey = $requestKey;
        return $this;
    }
    /**
     * Get isActExists value
     * @return bool|null
     */
    public function getIsActExists()
    {
        return $this->isActExists;
    }
    /**
     * Set isActExists value
     * @param bool $isActExists
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setIsActExists($isActExists = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActExists) && !is_bool($isActExists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActExists)), __LINE__);
        }
        $this->isActExists = $isActExists;
        return $this;
    }
    /**
     * Get docDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->docDate;
    }
    /**
     * Set docDate value
     * @param string $docDate
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->docDate = $docDate;
        return $this;
    }
    /**
     * Get docNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->docNumber;
    }
    /**
     * Set docNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->docNumber = $docNumber;
        return $this;
    }
    /**
     * Get term value
     * @return string|null
     */
    public function getTerm()
    {
        return $this->term;
    }
    /**
     * Set term value
     * @param string $term
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setTerm($term = null)
    {
        // validation for constraint: maxExclusive
        if ($term >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $term), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($term < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $term), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($term) && !is_string($term)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($term)), __LINE__);
        }
        $this->term = $term;
        return $this;
    }
    /**
     * Get spiKey value
     * @return int|null
     */
    public function getSpiKey()
    {
        return $this->spiKey;
    }
    /**
     * Set spiKey value
     * @param int $spiKey
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setSpiKey($spiKey = null)
    {
        // validation for constraint: maxInclusive
        if ($spiKey > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $spiKey), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($spiKey < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $spiKey), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($spiKey) && !is_numeric($spiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($spiKey)), __LINE__);
        }
        $this->spiKey = $spiKey;
        return $this;
    }
    /**
     * Get spiName value
     * @return string|null
     */
    public function getSpiName()
    {
        return $this->spiName;
    }
    /**
     * Set spiName value
     * @param string $spiName
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setSpiName($spiName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($spiName) && strlen($spiName) > 100) || (is_array($spiName) && count($spiName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($spiName) ? strlen($spiName) : count($spiName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($spiName) && strlen($spiName) < 1) || (is_array($spiName) && count($spiName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($spiName) && !is_string($spiName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($spiName)), __LINE__);
        }
        $this->spiName = $spiName;
        return $this;
    }
    /**
     * Get spiPostCode value
     * @return string|null
     */
    public function getSpiPostCode()
    {
        return $this->spiPostCode;
    }
    /**
     * Set spiPostCode value
     * @param string $spiPostCode
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setSpiPostCode($spiPostCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($spiPostCode) && strlen($spiPostCode) > 25) || (is_array($spiPostCode) && count($spiPostCode) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($spiPostCode) ? strlen($spiPostCode) : count($spiPostCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($spiPostCode) && strlen($spiPostCode) < 1) || (is_array($spiPostCode) && count($spiPostCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($spiPostCode) && !preg_match('/[0-9\\-\\.\\s]+/', $spiPostCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9\-\.\s]+", "%s" given', var_export($spiPostCode, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($spiPostCode) && !is_string($spiPostCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($spiPostCode)), __LINE__);
        }
        $this->spiPostCode = $spiPostCode;
        return $this;
    }
    /**
     * Get spiPostName value
     * @return string|null
     */
    public function getSpiPostName()
    {
        return $this->spiPostName;
    }
    /**
     * Set spiPostName value
     * @param string $spiPostName
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setSpiPostName($spiPostName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($spiPostName) && strlen($spiPostName) > 50) || (is_array($spiPostName) && count($spiPostName) > 50)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 50 element(s) or a scalar of 50 character(s) at most, "%d" length given', is_scalar($spiPostName) ? strlen($spiPostName) : count($spiPostName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($spiPostName) && strlen($spiPostName) < 1) || (is_array($spiPostName) && count($spiPostName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($spiPostName) && !is_string($spiPostName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($spiPostName)), __LINE__);
        }
        $this->spiPostName = $spiPostName;
        return $this;
    }
    /**
     * Get docCode value
     * @return string|null
     */
    public function getDocCode()
    {
        return $this->docCode;
    }
    /**
     * Set docCode value
     * @param string $docCode
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setDocCode($docCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docCode) && strlen($docCode) > 1) || (is_array($docCode) && count($docCode) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($docCode) ? strlen($docCode) : count($docCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docCode) && strlen($docCode) < 1) || (is_array($docCode) && count($docCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docCode) && !is_string($docCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docCode)), __LINE__);
        }
        $this->docCode = $docCode;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setReason($reason = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($reason) && strlen($reason) > 300) || (is_array($reason) && count($reason) > 300)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 300 element(s) or a scalar of 300 character(s) at most, "%d" length given', is_scalar($reason) ? strlen($reason) : count($reason)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($reason) && strlen($reason) < 1) || (is_array($reason) && count($reason) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get article value
     * @return string|null
     */
    public function getArticle()
    {
        return $this->article;
    }
    /**
     * Set article value
     * @param string $article
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setArticle($article = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($article) && strlen($article) > 10) || (is_array($article) && count($article) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($article) ? strlen($article) : count($article)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($article) && strlen($article) < 1) || (is_array($article) && count($article) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($article) && !is_string($article)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($article)), __LINE__);
        }
        $this->article = $article;
        return $this;
    }
    /**
     * Get point value
     * @return string|null
     */
    public function getPoint()
    {
        return $this->point;
    }
    /**
     * Set point value
     * @param string $point
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setPoint($point = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($point) && strlen($point) > 10) || (is_array($point) && count($point) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($point) ? strlen($point) : count($point)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($point) && strlen($point) < 1) || (is_array($point) && count($point) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($point) && !is_string($point)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($point)), __LINE__);
        }
        $this->point = $point;
        return $this;
    }
    /**
     * Get part value
     * @return string|null
     */
    public function getPart()
    {
        return $this->part;
    }
    /**
     * Set part value
     * @param string $part
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setPart($part = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($part) && strlen($part) > 10) || (is_array($part) && count($part) > 10)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 10 element(s) or a scalar of 10 character(s) at most, "%d" length given', is_scalar($part) ? strlen($part) : count($part)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($part) && strlen($part) < 1) || (is_array($part) && count($part) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($part) && !is_string($part)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($part)), __LINE__);
        }
        $this->part = $part;
        return $this;
    }
    /**
     * Get ip value
     * @return \AisFssp\StructType\IP|null
     */
    public function getIp()
    {
        return $this->ip;
    }
    /**
     * Set ip value
     * @param \AisFssp\StructType\IP $ip
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setIp(\AisFssp\StructType\IP $ip = null)
    {
        $this->ip = $ip;
        return $this;
    }
    /**
     * Get data value
     * @return \AisFssp\StructType\Data[]|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data[] $data
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setData(array $data = array())
    {
        foreach ($data as $exitRestrictionActInfoDataItem) {
            // validation for constraint: itemType
            if (!$exitRestrictionActInfoDataItem instanceof \AisFssp\StructType\Data) {
                throw new \InvalidArgumentException(sprintf('The data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($exitRestrictionActInfoDataItem) ? get_class($exitRestrictionActInfoDataItem) : gettype($exitRestrictionActInfoDataItem)), __LINE__);
            }
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Add item to data value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\Data $item
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function addToData(\AisFssp\StructType\Data $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\Data) {
            throw new \InvalidArgumentException(sprintf('The data property can only contain items of \AisFssp\StructType\Data, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->data[] = $item;
        return $this;
    }
    /**
     * Get SignDateTime value
     * @return string|null
     */
    public function getSignDateTime()
    {
        return $this->SignDateTime;
    }
    /**
     * Set SignDateTime value
     * @param string $signDateTime
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setSignDateTime($signDateTime = null)
    {
        // validation for constraint: maxExclusive
        if ($signDateTime >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($signDateTime < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $signDateTime), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($signDateTime) && !is_string($signDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($signDateTime)), __LINE__);
        }
        $this->SignDateTime = $signDateTime;
        return $this;
    }
    /**
     * Get Signature value
     * @return \AisFssp\StructType\SignatureType[]|null
     */
    public function getSignature()
    {
        return $this->Signature;
    }
    /**
     * Set Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType[] $signature
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setSignature(array $signature = array())
    {
        foreach ($signature as $exitRestrictionActInfoSignatureItem) {
            // validation for constraint: itemType
            if (!$exitRestrictionActInfoSignatureItem instanceof \AisFssp\StructType\SignatureType) {
                throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($exitRestrictionActInfoSignatureItem) ? get_class($exitRestrictionActInfoSignatureItem) : gettype($exitRestrictionActInfoSignatureItem)), __LINE__);
            }
        }
        $this->Signature = $signature;
        return $this;
    }
    /**
     * Add item to Signature value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\SignatureType $item
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function addToSignature(\AisFssp\StructType\SignatureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\SignatureType) {
            throw new \InvalidArgumentException(sprintf('The Signature property can only contain items of \AisFssp\StructType\SignatureType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Signature[] = $item;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\ExitRestrictionActInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
