<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Envelope StructType
 * Meta informations extracted from the WSDL
 * - documentation: Конверт | Дополнительные атрибуты документов
 * @subpackage Structs
 */
class Envelope extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор конверта | Идентификатор объекта | Атрибут документа
     * - use: required
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $id;
    /**
     * The Direction
     * Meta informations extracted from the WSDL
     * - documentation: Адреса отправителя и получателя документа | Обязательно, если адреса не соответствуют адресу пакета. Поле не заполняется при
     * пакетном обмене.
     * - minOccurs: 0
     * @var \AisFssp\StructType\Direction
     */
    public $Direction;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocBarCode
     * Meta informations extracted from the WSDL
     * - documentation: Штрих-код документа | Штрих-код документа
     * - minOccurs: 0
     * - maxLength: 44
     * - minLength: 1
     * @var string
     */
    public $DocBarCode;
    /**
     * The DocumentAttrs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:DocumentAttrs
     * @var \AisFssp\StructType\DocumentAttrs
     */
    public $DocumentAttrs;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - documentation: Данные документа
     * - minOccurs: 0
     * @var \AisFssp\StructType\DocumentContainer
     */
    public $Document;
    /**
     * The AttachmentsFileInfo
     * Meta informations extracted from the WSDL
     * - documentation: Информация о вложении в виде файла
     * @var \AisFssp\StructType\EnvelopeFileInfo
     */
    public $AttachmentsFileInfo;
    /**
     * The attachmentTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: Тип вложения
     * - maxLength: 31
     * - minLength: 1
     * @var string
     */
    public $attachmentTypeCode;
    /**
     * The doc_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор документа отправителя документа | Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $doc_id;
    /**
     * The doc_type
     * Meta informations extracted from the WSDL
     * - documentation: Код типа документа отправителя документа | Тип документа АИС ФССП России (тип документа ПКОСП) | Тип документа электронного
     * документооборота | NSI_Document | Наименование объекта NCORE
     * - maxLength: 31 | 31
     * - minLength: 1 | 1
     * @var string
     */
    public $doc_type;
    /**
     * The event
     * Meta informations extracted from the WSDL
     * - documentation: Наименование события в документообороте | Наименование события документооборота
     * - maxLength: 80
     * - minLength: 1
     * @var string
     */
    public $event;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Имя файла
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The content_type
     * Meta informations extracted from the WSDL
     * - documentation: MIME-тип данных | MIME-тип данных
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $content_type;
    /**
     * The attachment_id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор объекта | Атрибут документа
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $attachment_id;
    /**
     * Constructor method for Envelope
     * @uses Envelope::setId()
     * @uses Envelope::setDirection()
     * @uses Envelope::setDocNumber()
     * @uses Envelope::setDocDate()
     * @uses Envelope::setDocBarCode()
     * @uses Envelope::setDocumentAttrs()
     * @uses Envelope::setDocument()
     * @uses Envelope::setAttachmentsFileInfo()
     * @uses Envelope::setAttachmentTypeCode()
     * @uses Envelope::setDoc_id()
     * @uses Envelope::setDoc_type()
     * @uses Envelope::setEvent()
     * @uses Envelope::setName()
     * @uses Envelope::setContent_type()
     * @uses Envelope::setAttachment_id()
     * @param string $id
     * @param \AisFssp\StructType\Direction $direction
     * @param string $docNumber
     * @param string $docDate
     * @param string $docBarCode
     * @param \AisFssp\StructType\DocumentAttrs $documentAttrs
     * @param \AisFssp\StructType\DocumentContainer $document
     * @param \AisFssp\StructType\EnvelopeFileInfo $attachmentsFileInfo
     * @param string $attachmentTypeCode
     * @param string $doc_id
     * @param string $doc_type
     * @param string $event
     * @param string $name
     * @param string $content_type
     * @param string $attachment_id
     */
    public function __construct($id = null, \AisFssp\StructType\Direction $direction = null, $docNumber = null, $docDate = null, $docBarCode = null, \AisFssp\StructType\DocumentAttrs $documentAttrs = null, \AisFssp\StructType\DocumentContainer $document = null, \AisFssp\StructType\EnvelopeFileInfo $attachmentsFileInfo = null, $attachmentTypeCode = null, $doc_id = null, $doc_type = null, $event = null, $name = null, $content_type = null, $attachment_id = null)
    {
        $this
            ->setId($id)
            ->setDirection($direction)
            ->setDocNumber($docNumber)
            ->setDocDate($docDate)
            ->setDocBarCode($docBarCode)
            ->setDocumentAttrs($documentAttrs)
            ->setDocument($document)
            ->setAttachmentsFileInfo($attachmentsFileInfo)
            ->setAttachmentTypeCode($attachmentTypeCode)
            ->setDoc_id($doc_id)
            ->setDoc_type($doc_type)
            ->setEvent($event)
            ->setName($name)
            ->setContent_type($content_type)
            ->setAttachment_id($attachment_id);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \AisFssp\StructType\Envelope
     */
    public function setId($id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($id) && strlen($id) > 60) || (is_array($id) && count($id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($id) ? strlen($id) : count($id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($id) && strlen($id) < 1) || (is_array($id) && count($id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get Direction value
     * @return \AisFssp\StructType\Direction|null
     */
    public function getDirection()
    {
        return $this->Direction;
    }
    /**
     * Set Direction value
     * @param \AisFssp\StructType\Direction $direction
     * @return \AisFssp\StructType\Envelope
     */
    public function setDirection(\AisFssp\StructType\Direction $direction = null)
    {
        $this->Direction = $direction;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\Envelope
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\Envelope
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocBarCode value
     * @return string|null
     */
    public function getDocBarCode()
    {
        return $this->DocBarCode;
    }
    /**
     * Set DocBarCode value
     * @param string $docBarCode
     * @return \AisFssp\StructType\Envelope
     */
    public function setDocBarCode($docBarCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docBarCode) && strlen($docBarCode) > 44) || (is_array($docBarCode) && count($docBarCode) > 44)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 44 element(s) or a scalar of 44 character(s) at most, "%d" length given', is_scalar($docBarCode) ? strlen($docBarCode) : count($docBarCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docBarCode) && strlen($docBarCode) < 1) || (is_array($docBarCode) && count($docBarCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docBarCode) && !is_string($docBarCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docBarCode)), __LINE__);
        }
        $this->DocBarCode = $docBarCode;
        return $this;
    }
    /**
     * Get DocumentAttrs value
     * @return \AisFssp\StructType\DocumentAttrs|null
     */
    public function getDocumentAttrs()
    {
        return $this->DocumentAttrs;
    }
    /**
     * Set DocumentAttrs value
     * @param \AisFssp\StructType\DocumentAttrs $documentAttrs
     * @return \AisFssp\StructType\Envelope
     */
    public function setDocumentAttrs(\AisFssp\StructType\DocumentAttrs $documentAttrs = null)
    {
        $this->DocumentAttrs = $documentAttrs;
        return $this;
    }
    /**
     * Get Document value
     * @return \AisFssp\StructType\DocumentContainer|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \AisFssp\StructType\DocumentContainer $document
     * @return \AisFssp\StructType\Envelope
     */
    public function setDocument(\AisFssp\StructType\DocumentContainer $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Get AttachmentsFileInfo value
     * @return \AisFssp\StructType\EnvelopeFileInfo|null
     */
    public function getAttachmentsFileInfo()
    {
        return $this->AttachmentsFileInfo;
    }
    /**
     * Set AttachmentsFileInfo value
     * @param \AisFssp\StructType\EnvelopeFileInfo $attachmentsFileInfo
     * @return \AisFssp\StructType\Envelope
     */
    public function setAttachmentsFileInfo(\AisFssp\StructType\EnvelopeFileInfo $attachmentsFileInfo = null)
    {
        $this->AttachmentsFileInfo = $attachmentsFileInfo;
        return $this;
    }
    /**
     * Get attachmentTypeCode value
     * @return string|null
     */
    public function getAttachmentTypeCode()
    {
        return $this->attachmentTypeCode;
    }
    /**
     * Set attachmentTypeCode value
     * @param string $attachmentTypeCode
     * @return \AisFssp\StructType\Envelope
     */
    public function setAttachmentTypeCode($attachmentTypeCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($attachmentTypeCode) && strlen($attachmentTypeCode) > 31) || (is_array($attachmentTypeCode) && count($attachmentTypeCode) > 31)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 31 element(s) or a scalar of 31 character(s) at most, "%d" length given', is_scalar($attachmentTypeCode) ? strlen($attachmentTypeCode) : count($attachmentTypeCode)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($attachmentTypeCode) && strlen($attachmentTypeCode) < 1) || (is_array($attachmentTypeCode) && count($attachmentTypeCode) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attachmentTypeCode) && !is_string($attachmentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachmentTypeCode)), __LINE__);
        }
        $this->attachmentTypeCode = $attachmentTypeCode;
        return $this;
    }
    /**
     * Get doc_id value
     * @return string|null
     */
    public function getDoc_id()
    {
        return $this->doc_id;
    }
    /**
     * Set doc_id value
     * @param string $doc_id
     * @return \AisFssp\StructType\Envelope
     */
    public function setDoc_id($doc_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($doc_id) && strlen($doc_id) > 60) || (is_array($doc_id) && count($doc_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($doc_id) ? strlen($doc_id) : count($doc_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($doc_id) && strlen($doc_id) < 1) || (is_array($doc_id) && count($doc_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($doc_id) && !is_string($doc_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doc_id)), __LINE__);
        }
        $this->doc_id = $doc_id;
        return $this;
    }
    /**
     * Get doc_type value
     * @return string|null
     */
    public function getDoc_type()
    {
        return $this->doc_type;
    }
    /**
     * Set doc_type value
     * @param string $doc_type
     * @return \AisFssp\StructType\Envelope
     */
    public function setDoc_type($doc_type = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($doc_type) && strlen($doc_type) > 1) || (is_array($doc_type) && count($doc_type) > 1)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at most, "%d" length given', is_scalar($doc_type) ? strlen($doc_type) : count($doc_type)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($doc_type) && strlen($doc_type) < 1) || (is_array($doc_type) && count($doc_type) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($doc_type) && !is_string($doc_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($doc_type)), __LINE__);
        }
        $this->doc_type = $doc_type;
        return $this;
    }
    /**
     * Get event value
     * @return string|null
     */
    public function getEvent()
    {
        return $this->event;
    }
    /**
     * Set event value
     * @param string $event
     * @return \AisFssp\StructType\Envelope
     */
    public function setEvent($event = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($event) && strlen($event) > 80) || (is_array($event) && count($event) > 80)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 80 element(s) or a scalar of 80 character(s) at most, "%d" length given', is_scalar($event) ? strlen($event) : count($event)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($event) && strlen($event) < 1) || (is_array($event) && count($event) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($event) && !is_string($event)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($event)), __LINE__);
        }
        $this->event = $event;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \AisFssp\StructType\Envelope
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($name) && strlen($name) < 1) || (is_array($name) && count($name) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get content_type value
     * @return string|null
     */
    public function getContent_type()
    {
        return $this->content_type;
    }
    /**
     * Set content_type value
     * @param string $content_type
     * @return \AisFssp\StructType\Envelope
     */
    public function setContent_type($content_type = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($content_type) && strlen($content_type) > 255) || (is_array($content_type) && count($content_type) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($content_type) ? strlen($content_type) : count($content_type)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($content_type) && strlen($content_type) < 1) || (is_array($content_type) && count($content_type) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($content_type) && !is_string($content_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content_type)), __LINE__);
        }
        $this->content_type = $content_type;
        return $this;
    }
    /**
     * Get attachment_id value
     * @return string|null
     */
    public function getAttachment_id()
    {
        return $this->attachment_id;
    }
    /**
     * Set attachment_id value
     * @param string $attachment_id
     * @return \AisFssp\StructType\Envelope
     */
    public function setAttachment_id($attachment_id = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($attachment_id) && strlen($attachment_id) > 60) || (is_array($attachment_id) && count($attachment_id) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($attachment_id) ? strlen($attachment_id) : count($attachment_id)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($attachment_id) && strlen($attachment_id) < 1) || (is_array($attachment_id) && count($attachment_id) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attachment_id) && !is_string($attachment_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachment_id)), __LINE__);
        }
        $this->attachment_id = $attachment_id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\Envelope
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
