<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EgrulEgripDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о записи в ЕГРЮЛ или ЕГРИП
 * @subpackage Structs
 */
class EgrulEgripDatumType extends InformationType
{
    /**
     * The regId
     * Meta informations extracted from the WSDL
     * - documentation: Регистрационный номер в базе данных | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $regId;
    /**
     * The regNumber
     * Meta informations extracted from the WSDL
     * - documentation: Государственный регистрационный номер записи | Основной государственный регистрационный номер (ОГРН)/Основной
     * государственный регистрационный номер индивидуального предпринимателя (ОГРНИП)
     * - maxLength: 15
     * - minLength: 13
     * - pattern: ([0-9]{13})|([0-9]{15})
     * @var string
     */
    public $regNumber;
    /**
     * The regDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата регистрации | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $regDate;
    /**
     * The regKindId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор вида регистрации | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $regKindId;
    /**
     * The regKindName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида регистрации | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $regKindName;
    /**
     * The certSeries
     * Meta informations extracted from the WSDL
     * - documentation: Серия свидетельства | Строка длиной 2 символа
     * - minOccurs: 0
     * - length: 2
     * @var string
     */
    public $certSeries;
    /**
     * The certNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер свидетельства | Строка длиной 9 символов
     * - minOccurs: 0
     * - length: 9
     * @var string
     */
    public $certNumber;
    /**
     * The stateId
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор состояния записи | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $stateId;
    /**
     * The stateName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование состояния записи | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $stateName;
    /**
     * Constructor method for EgrulEgripDatumType
     * @uses EgrulEgripDatumType::setRegId()
     * @uses EgrulEgripDatumType::setRegNumber()
     * @uses EgrulEgripDatumType::setRegDate()
     * @uses EgrulEgripDatumType::setRegKindId()
     * @uses EgrulEgripDatumType::setRegKindName()
     * @uses EgrulEgripDatumType::setCertSeries()
     * @uses EgrulEgripDatumType::setCertNumber()
     * @uses EgrulEgripDatumType::setStateId()
     * @uses EgrulEgripDatumType::setStateName()
     * @param int $regId
     * @param string $regNumber
     * @param string $regDate
     * @param int $regKindId
     * @param string $regKindName
     * @param string $certSeries
     * @param string $certNumber
     * @param int $stateId
     * @param string $stateName
     */
    public function __construct($regId = null, $regNumber = null, $regDate = null, $regKindId = null, $regKindName = null, $certSeries = null, $certNumber = null, $stateId = null, $stateName = null)
    {
        $this
            ->setRegId($regId)
            ->setRegNumber($regNumber)
            ->setRegDate($regDate)
            ->setRegKindId($regKindId)
            ->setRegKindName($regKindName)
            ->setCertSeries($certSeries)
            ->setCertNumber($certNumber)
            ->setStateId($stateId)
            ->setStateName($stateName);
    }
    /**
     * Get regId value
     * @return int|null
     */
    public function getRegId()
    {
        return $this->regId;
    }
    /**
     * Set regId value
     * @param int $regId
     * @return \AisFssp\StructType\EgrulEgripDatumType
     */
    public function setRegId($regId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($regId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $regId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($regId, strpos($regId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($regId) && !is_numeric($regId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($regId)), __LINE__);
        }
        $this->regId = $regId;
        return $this;
    }
    /**
     * Get regNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \AisFssp\StructType\EgrulEgripDatumType
     */
    public function setRegNumber($regNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regNumber) && strlen($regNumber) > 15) || (is_array($regNumber) && count($regNumber) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($regNumber) ? strlen($regNumber) : count($regNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($regNumber) && strlen($regNumber) < 13) || (is_array($regNumber) && count($regNumber) < 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s) at least', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($regNumber) && !preg_match('/([0-9]{13})|([0-9]{15})/', $regNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9]{13})|([0-9]{15})", "%s" given', var_export($regNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regNumber) && !is_string($regNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regNumber)), __LINE__);
        }
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Get regDate value
     * @return string|null
     */
    public function getRegDate()
    {
        return $this->regDate;
    }
    /**
     * Set regDate value
     * @param string $regDate
     * @return \AisFssp\StructType\EgrulEgripDatumType
     */
    public function setRegDate($regDate = null)
    {
        // validation for constraint: maxExclusive
        if ($regDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($regDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $regDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regDate) && !is_string($regDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regDate)), __LINE__);
        }
        $this->regDate = $regDate;
        return $this;
    }
    /**
     * Get regKindId value
     * @return int|null
     */
    public function getRegKindId()
    {
        return $this->regKindId;
    }
    /**
     * Set regKindId value
     * @param int $regKindId
     * @return \AisFssp\StructType\EgrulEgripDatumType
     */
    public function setRegKindId($regKindId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($regKindId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $regKindId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($regKindId, strpos($regKindId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($regKindId) && !is_numeric($regKindId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($regKindId)), __LINE__);
        }
        $this->regKindId = $regKindId;
        return $this;
    }
    /**
     * Get regKindName value
     * @return string|null
     */
    public function getRegKindName()
    {
        return $this->regKindName;
    }
    /**
     * Set regKindName value
     * @param string $regKindName
     * @return \AisFssp\StructType\EgrulEgripDatumType
     */
    public function setRegKindName($regKindName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regKindName) && strlen($regKindName) > 255) || (is_array($regKindName) && count($regKindName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($regKindName) ? strlen($regKindName) : count($regKindName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($regKindName) && strlen($regKindName) < 1) || (is_array($regKindName) && count($regKindName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regKindName) && !is_string($regKindName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regKindName)), __LINE__);
        }
        $this->regKindName = $regKindName;
        return $this;
    }
    /**
     * Get certSeries value
     * @return string|null
     */
    public function getCertSeries()
    {
        return $this->certSeries;
    }
    /**
     * Set certSeries value
     * @param string $certSeries
     * @return \AisFssp\StructType\EgrulEgripDatumType
     */
    public function setCertSeries($certSeries = null)
    {
        // validation for constraint: length
        if ((is_scalar($certSeries) && strlen($certSeries) !== 2) || (is_array($certSeries) && count($certSeries) !== 2)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 2 element(s) or a scalar of 2 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($certSeries) && !is_string($certSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certSeries)), __LINE__);
        }
        $this->certSeries = $certSeries;
        return $this;
    }
    /**
     * Get certNumber value
     * @return string|null
     */
    public function getCertNumber()
    {
        return $this->certNumber;
    }
    /**
     * Set certNumber value
     * @param string $certNumber
     * @return \AisFssp\StructType\EgrulEgripDatumType
     */
    public function setCertNumber($certNumber = null)
    {
        // validation for constraint: length
        if ((is_scalar($certNumber) && strlen($certNumber) !== 9) || (is_array($certNumber) && count($certNumber) !== 9)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 9 element(s) or a scalar of 9 character(s)', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($certNumber) && !is_string($certNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($certNumber)), __LINE__);
        }
        $this->certNumber = $certNumber;
        return $this;
    }
    /**
     * Get stateId value
     * @return int|null
     */
    public function getStateId()
    {
        return $this->stateId;
    }
    /**
     * Set stateId value
     * @param int $stateId
     * @return \AisFssp\StructType\EgrulEgripDatumType
     */
    public function setStateId($stateId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($stateId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $stateId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($stateId, strpos($stateId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($stateId) && !is_numeric($stateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stateId)), __LINE__);
        }
        $this->stateId = $stateId;
        return $this;
    }
    /**
     * Get stateName value
     * @return string|null
     */
    public function getStateName()
    {
        return $this->stateName;
    }
    /**
     * Set stateName value
     * @param string $stateName
     * @return \AisFssp\StructType\EgrulEgripDatumType
     */
    public function setStateName($stateName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($stateName) && strlen($stateName) > 255) || (is_array($stateName) && count($stateName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($stateName) ? strlen($stateName) : count($stateName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($stateName) && strlen($stateName) < 1) || (is_array($stateName) && count($stateName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($stateName) && !is_string($stateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateName)), __LINE__);
        }
        $this->stateName = $stateName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\EgrulEgripDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
