<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EQSyncRegistryRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос справочников и реестров для сервиса личного приёма
 * - type: tns:EQSyncRegistryRequest
 * @subpackage Structs
 */
class EQSyncRegistryRequest extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DateFrom
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время запроса | Дата и время | Дата и время
     * - maxExclusive: 2100-01-01T00:00:00
     * - minInclusive: 1900-01-01T00:00:00
     * @var string
     */
    public $DateFrom;
    /**
     * The TypeDoc
     * Meta informations extracted from the WSDL
     * - documentation: Тип справочника
     * @var string
     */
    public $TypeDoc;
    /**
     * Constructor method for EQSyncRegistryRequest
     * @uses EQSyncRegistryRequest::setExternalKey()
     * @uses EQSyncRegistryRequest::setDateFrom()
     * @uses EQSyncRegistryRequest::setTypeDoc()
     * @param string $externalKey
     * @param string $dateFrom
     * @param string $typeDoc
     */
    public function __construct($externalKey = null, $dateFrom = null, $typeDoc = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setDateFrom($dateFrom)
            ->setTypeDoc($typeDoc);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\EQSyncRegistryRequest
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DateFrom value
     * @return string|null
     */
    public function getDateFrom()
    {
        return $this->DateFrom;
    }
    /**
     * Set DateFrom value
     * @param string $dateFrom
     * @return \AisFssp\StructType\EQSyncRegistryRequest
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: maxExclusive
        if ($dateFrom >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $dateFrom), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($dateFrom < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $dateFrom), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateFrom)), __LINE__);
        }
        $this->DateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get TypeDoc value
     * @return string|null
     */
    public function getTypeDoc()
    {
        return $this->TypeDoc;
    }
    /**
     * Set TypeDoc value
     * @uses \AisFssp\EnumType\RegistryDocType::valueIsValid()
     * @uses \AisFssp\EnumType\RegistryDocType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeDoc
     * @return \AisFssp\StructType\EQSyncRegistryRequest
     */
    public function setTypeDoc($typeDoc = null)
    {
        // validation for constraint: enumeration
        if (!\AisFssp\EnumType\RegistryDocType::valueIsValid($typeDoc)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $typeDoc, implode(', ', \AisFssp\EnumType\RegistryDocType::getValidValues())), __LINE__);
        }
        $this->TypeDoc = $typeDoc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\EQSyncRegistryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
