<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EQAppointmentDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Документ-заявка записи на приём
 * - type: tns:EQAppointmentDocument
 * @subpackage Structs
 */
class EQAppointmentDocument extends AbstractStructBase
{
    /**
     * The ExternalKey
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор АИС ВК | Идентификатор объекта, присвоенный объекту АИС внешнего контрагентом (ФНС, ПФР и прочие). Данный
     * идентификатор должен быть уникальным для типа идентифицируемого документа в пространстве обмена данными с конкретным внешним
     * контрагентом.
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $ExternalKey;
    /**
     * The DocDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $DocDate;
    /**
     * The DocNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $DocNumber;
    /**
     * The Applicant
     * Meta informations extracted from the WSDL
     * - documentation: Заявитель
     * @var \AisFssp\StructType\EQApplicant
     */
    public $Applicant;
    /**
     * The IsCA
     * Meta informations extracted from the WSDL
     * - documentation: Cотрудник ЦА или аппарата управления ТО | Обертка стандартного xs:boolean | Логический
     * @var bool
     */
    public $IsCA;
    /**
     * The Official
     * Meta informations extracted from the WSDL
     * - documentation: Код сотрудника | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $Official;
    /**
     * The Post
     * Meta informations extracted from the WSDL
     * - documentation: Код должности | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $Post;
    /**
     * The Theme
     * Meta informations extracted from the WSDL
     * - documentation: Код внешней темы обращения | Целое | Целое
     * - maxInclusive: 2147483647
     * @var int
     */
    public $Theme;
    /**
     * The Vksp
     * Meta informations extracted from the WSDL
     * - documentation: Код ВКСП | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $Vksp;
    /**
     * The TimeSlot
     * Meta informations extracted from the WSDL
     * - documentation: Код промежутка времени приёма | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $TimeSlot;
    /**
     * The UseFirstAvailableTime
     * Meta informations extracted from the WSDL
     * - documentation: Использовать первое свободное время | Обертка стандартного xs:boolean | Логический
     * - minOccurs: 0
     * @var bool
     */
    public $UseFirstAvailableTime;
    /**
     * The ReceptionDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата приёма | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $ReceptionDate;
    /**
     * The IpNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер ИП | Номер документа
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $IpNumber;
    /**
     * The PreviousId
     * Meta informations extracted from the WSDL
     * - documentation: Код предыдущего обращения | Ключ объекта, присвоенний информационной системой ФССП РФ при создании объекта или при получении
     * объекта от контрагента
     * - minOccurs: 0
     * - maxInclusive: 9223372036854775807
     * - minInclusive: -9223372036854775808
     * @var int
     */
    public $PreviousId;
    /**
     * The PreviousPost
     * Meta informations extracted from the WSDL
     * - documentation: Код должности из предыдущего обращения | Целое | Целое
     * - minOccurs: 0
     * - maxInclusive: 2147483647
     * @var int
     */
    public $PreviousPost;
    /**
     * The PreviousDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата предыдущего приёма | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $PreviousDate;
    /**
     * The PreviousVksp
     * Meta informations extracted from the WSDL
     * - documentation: ВКСП предыдущего приема | Ведомственный классификатор отделов судебных приставов | NSI_Departments
     * - minOccurs: 0
     * - length: 5
     * - pattern: [0-9]{5}
     * @var string
     */
    public $PreviousVksp;
    /**
     * The AppText
     * Meta informations extracted from the WSDL
     * - documentation: Текст обращения | Массив произвольных данных (текстовый)
     * - minOccurs: 0
     * @var string
     */
    public $AppText;
    /**
     * Constructor method for EQAppointmentDocument
     * @uses EQAppointmentDocument::setExternalKey()
     * @uses EQAppointmentDocument::setDocDate()
     * @uses EQAppointmentDocument::setDocNumber()
     * @uses EQAppointmentDocument::setApplicant()
     * @uses EQAppointmentDocument::setIsCA()
     * @uses EQAppointmentDocument::setOfficial()
     * @uses EQAppointmentDocument::setPost()
     * @uses EQAppointmentDocument::setTheme()
     * @uses EQAppointmentDocument::setVksp()
     * @uses EQAppointmentDocument::setTimeSlot()
     * @uses EQAppointmentDocument::setUseFirstAvailableTime()
     * @uses EQAppointmentDocument::setReceptionDate()
     * @uses EQAppointmentDocument::setIpNumber()
     * @uses EQAppointmentDocument::setPreviousId()
     * @uses EQAppointmentDocument::setPreviousPost()
     * @uses EQAppointmentDocument::setPreviousDate()
     * @uses EQAppointmentDocument::setPreviousVksp()
     * @uses EQAppointmentDocument::setAppText()
     * @param string $externalKey
     * @param string $docDate
     * @param string $docNumber
     * @param \AisFssp\StructType\EQApplicant $applicant
     * @param bool $isCA
     * @param int $official
     * @param int $post
     * @param int $theme
     * @param string $vksp
     * @param int $timeSlot
     * @param bool $useFirstAvailableTime
     * @param string $receptionDate
     * @param string $ipNumber
     * @param int $previousId
     * @param int $previousPost
     * @param string $previousDate
     * @param string $previousVksp
     * @param string $appText
     */
    public function __construct($externalKey = null, $docDate = null, $docNumber = null, \AisFssp\StructType\EQApplicant $applicant = null, $isCA = null, $official = null, $post = null, $theme = null, $vksp = null, $timeSlot = null, $useFirstAvailableTime = null, $receptionDate = null, $ipNumber = null, $previousId = null, $previousPost = null, $previousDate = null, $previousVksp = null, $appText = null)
    {
        $this
            ->setExternalKey($externalKey)
            ->setDocDate($docDate)
            ->setDocNumber($docNumber)
            ->setApplicant($applicant)
            ->setIsCA($isCA)
            ->setOfficial($official)
            ->setPost($post)
            ->setTheme($theme)
            ->setVksp($vksp)
            ->setTimeSlot($timeSlot)
            ->setUseFirstAvailableTime($useFirstAvailableTime)
            ->setReceptionDate($receptionDate)
            ->setIpNumber($ipNumber)
            ->setPreviousId($previousId)
            ->setPreviousPost($previousPost)
            ->setPreviousDate($previousDate)
            ->setPreviousVksp($previousVksp)
            ->setAppText($appText);
    }
    /**
     * Get ExternalKey value
     * @return string|null
     */
    public function getExternalKey()
    {
        return $this->ExternalKey;
    }
    /**
     * Set ExternalKey value
     * @param string $externalKey
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setExternalKey($externalKey = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($externalKey) && strlen($externalKey) > 60) || (is_array($externalKey) && count($externalKey) > 60)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 60 element(s) or a scalar of 60 character(s) at most, "%d" length given', is_scalar($externalKey) ? strlen($externalKey) : count($externalKey)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($externalKey) && strlen($externalKey) < 1) || (is_array($externalKey) && count($externalKey) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($externalKey) && !is_string($externalKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalKey)), __LINE__);
        }
        $this->ExternalKey = $externalKey;
        return $this;
    }
    /**
     * Get DocDate value
     * @return string|null
     */
    public function getDocDate()
    {
        return $this->DocDate;
    }
    /**
     * Set DocDate value
     * @param string $docDate
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setDocDate($docDate = null)
    {
        // validation for constraint: maxExclusive
        if ($docDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($docDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $docDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docDate) && !is_string($docDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docDate)), __LINE__);
        }
        $this->DocDate = $docDate;
        return $this;
    }
    /**
     * Get DocNumber value
     * @return string|null
     */
    public function getDocNumber()
    {
        return $this->DocNumber;
    }
    /**
     * Set DocNumber value
     * @param string $docNumber
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setDocNumber($docNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($docNumber) && strlen($docNumber) > 25) || (is_array($docNumber) && count($docNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($docNumber) ? strlen($docNumber) : count($docNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($docNumber) && strlen($docNumber) < 1) || (is_array($docNumber) && count($docNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($docNumber) && !is_string($docNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($docNumber)), __LINE__);
        }
        $this->DocNumber = $docNumber;
        return $this;
    }
    /**
     * Get Applicant value
     * @return \AisFssp\StructType\EQApplicant|null
     */
    public function getApplicant()
    {
        return $this->Applicant;
    }
    /**
     * Set Applicant value
     * @param \AisFssp\StructType\EQApplicant $applicant
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setApplicant(\AisFssp\StructType\EQApplicant $applicant = null)
    {
        $this->Applicant = $applicant;
        return $this;
    }
    /**
     * Get IsCA value
     * @return bool|null
     */
    public function getIsCA()
    {
        return $this->IsCA;
    }
    /**
     * Set IsCA value
     * @param bool $isCA
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setIsCA($isCA = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCA) && !is_bool($isCA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCA)), __LINE__);
        }
        $this->IsCA = $isCA;
        return $this;
    }
    /**
     * Get Official value
     * @return int|null
     */
    public function getOfficial()
    {
        return $this->Official;
    }
    /**
     * Set Official value
     * @param int $official
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setOfficial($official = null)
    {
        // validation for constraint: maxInclusive
        if ($official > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $official), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($official) && !is_numeric($official)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($official)), __LINE__);
        }
        $this->Official = $official;
        return $this;
    }
    /**
     * Get Post value
     * @return int|null
     */
    public function getPost()
    {
        return $this->Post;
    }
    /**
     * Set Post value
     * @param int $post
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setPost($post = null)
    {
        // validation for constraint: maxInclusive
        if ($post > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $post), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($post) && !is_numeric($post)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($post)), __LINE__);
        }
        $this->Post = $post;
        return $this;
    }
    /**
     * Get Theme value
     * @return int|null
     */
    public function getTheme()
    {
        return $this->Theme;
    }
    /**
     * Set Theme value
     * @param int $theme
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setTheme($theme = null)
    {
        // validation for constraint: maxInclusive
        if ($theme > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $theme), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($theme) && !is_numeric($theme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($theme)), __LINE__);
        }
        $this->Theme = $theme;
        return $this;
    }
    /**
     * Get Vksp value
     * @return string|null
     */
    public function getVksp()
    {
        return $this->Vksp;
    }
    /**
     * Set Vksp value
     * @param string $vksp
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setVksp($vksp = null)
    {
        // validation for constraint: length
        if ((is_scalar($vksp) && strlen($vksp) !== 5) || (is_array($vksp) && count($vksp) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($vksp) && !preg_match('/[0-9]{5}/', $vksp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($vksp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vksp) && !is_string($vksp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vksp)), __LINE__);
        }
        $this->Vksp = $vksp;
        return $this;
    }
    /**
     * Get TimeSlot value
     * @return int|null
     */
    public function getTimeSlot()
    {
        return $this->TimeSlot;
    }
    /**
     * Set TimeSlot value
     * @param int $timeSlot
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setTimeSlot($timeSlot = null)
    {
        // validation for constraint: maxInclusive
        if ($timeSlot > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $timeSlot), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($timeSlot) && !is_numeric($timeSlot)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timeSlot)), __LINE__);
        }
        $this->TimeSlot = $timeSlot;
        return $this;
    }
    /**
     * Get UseFirstAvailableTime value
     * @return bool|null
     */
    public function getUseFirstAvailableTime()
    {
        return $this->UseFirstAvailableTime;
    }
    /**
     * Set UseFirstAvailableTime value
     * @param bool $useFirstAvailableTime
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setUseFirstAvailableTime($useFirstAvailableTime = null)
    {
        // validation for constraint: boolean
        if (!is_null($useFirstAvailableTime) && !is_bool($useFirstAvailableTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useFirstAvailableTime)), __LINE__);
        }
        $this->UseFirstAvailableTime = $useFirstAvailableTime;
        return $this;
    }
    /**
     * Get ReceptionDate value
     * @return string|null
     */
    public function getReceptionDate()
    {
        return $this->ReceptionDate;
    }
    /**
     * Set ReceptionDate value
     * @param string $receptionDate
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setReceptionDate($receptionDate = null)
    {
        // validation for constraint: maxExclusive
        if ($receptionDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $receptionDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($receptionDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $receptionDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($receptionDate) && !is_string($receptionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receptionDate)), __LINE__);
        }
        $this->ReceptionDate = $receptionDate;
        return $this;
    }
    /**
     * Get IpNumber value
     * @return string|null
     */
    public function getIpNumber()
    {
        return $this->IpNumber;
    }
    /**
     * Set IpNumber value
     * @param string $ipNumber
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setIpNumber($ipNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($ipNumber) && strlen($ipNumber) > 25) || (is_array($ipNumber) && count($ipNumber) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($ipNumber) ? strlen($ipNumber) : count($ipNumber)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($ipNumber) && strlen($ipNumber) < 1) || (is_array($ipNumber) && count($ipNumber) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($ipNumber) && !is_string($ipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ipNumber)), __LINE__);
        }
        $this->IpNumber = $ipNumber;
        return $this;
    }
    /**
     * Get PreviousId value
     * @return int|null
     */
    public function getPreviousId()
    {
        return $this->PreviousId;
    }
    /**
     * Set PreviousId value
     * @param int $previousId
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setPreviousId($previousId = null)
    {
        // validation for constraint: maxInclusive
        if ($previousId > 9223372036854775807) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 9223372036854775807, "%s" given', $previousId), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($previousId < -9223372036854775808) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to -9223372036854775808, "%s" given', $previousId), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($previousId) && !is_numeric($previousId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($previousId)), __LINE__);
        }
        $this->PreviousId = $previousId;
        return $this;
    }
    /**
     * Get PreviousPost value
     * @return int|null
     */
    public function getPreviousPost()
    {
        return $this->PreviousPost;
    }
    /**
     * Set PreviousPost value
     * @param int $previousPost
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setPreviousPost($previousPost = null)
    {
        // validation for constraint: maxInclusive
        if ($previousPost > 2147483647) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 2147483647, "%s" given', $previousPost), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($previousPost) && !is_numeric($previousPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($previousPost)), __LINE__);
        }
        $this->PreviousPost = $previousPost;
        return $this;
    }
    /**
     * Get PreviousDate value
     * @return string|null
     */
    public function getPreviousDate()
    {
        return $this->PreviousDate;
    }
    /**
     * Set PreviousDate value
     * @param string $previousDate
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setPreviousDate($previousDate = null)
    {
        // validation for constraint: maxExclusive
        if ($previousDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $previousDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($previousDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $previousDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($previousDate) && !is_string($previousDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($previousDate)), __LINE__);
        }
        $this->PreviousDate = $previousDate;
        return $this;
    }
    /**
     * Get PreviousVksp value
     * @return string|null
     */
    public function getPreviousVksp()
    {
        return $this->PreviousVksp;
    }
    /**
     * Set PreviousVksp value
     * @param string $previousVksp
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setPreviousVksp($previousVksp = null)
    {
        // validation for constraint: length
        if ((is_scalar($previousVksp) && strlen($previousVksp) !== 5) || (is_array($previousVksp) && count($previousVksp) !== 5)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 5 element(s) or a scalar of 5 character(s)', __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($previousVksp) && !preg_match('/[0-9]{5}/', $previousVksp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[0-9]{5}", "%s" given', var_export($previousVksp, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($previousVksp) && !is_string($previousVksp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($previousVksp)), __LINE__);
        }
        $this->PreviousVksp = $previousVksp;
        return $this;
    }
    /**
     * Get AppText value
     * @return string|null
     */
    public function getAppText()
    {
        return $this->AppText;
    }
    /**
     * Set AppText value
     * @param string $appText
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public function setAppText($appText = null)
    {
        // validation for constraint: string
        if (!is_null($appText) && !is_string($appText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appText)), __LINE__);
        }
        $this->AppText = $appText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\EQAppointmentDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
