<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EMailAttachmentType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Прикрепленный файл сообщения электронной почты
 * @subpackage Structs
 */
class EMailAttachmentType extends AttachmentType
{
    /**
     * The AttachmentId
     * Meta informations extracted from the WSDL
     * - documentation: Имя файла | Идентификатор сообщения электронной почты
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $AttachmentId;
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - documentation: MIME-Заголовки
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AisFssp\StructType\EMailHeaderType[]
     */
    public $Header;
    /**
     * Constructor method for EMailAttachmentType
     * @uses EMailAttachmentType::setAttachmentId()
     * @uses EMailAttachmentType::setHeader()
     * @param string $attachmentId
     * @param \AisFssp\StructType\EMailHeaderType[] $header
     */
    public function __construct($attachmentId = null, array $header = array())
    {
        $this
            ->setAttachmentId($attachmentId)
            ->setHeader($header);
    }
    /**
     * Get AttachmentId value
     * @return string|null
     */
    public function getAttachmentId()
    {
        return $this->AttachmentId;
    }
    /**
     * Set AttachmentId value
     * @param string $attachmentId
     * @return \AisFssp\StructType\EMailAttachmentType
     */
    public function setAttachmentId($attachmentId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($attachmentId) && strlen($attachmentId) > 255) || (is_array($attachmentId) && count($attachmentId) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($attachmentId) ? strlen($attachmentId) : count($attachmentId)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($attachmentId) && strlen($attachmentId) < 1) || (is_array($attachmentId) && count($attachmentId) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($attachmentId) && !is_string($attachmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attachmentId)), __LINE__);
        }
        $this->AttachmentId = $attachmentId;
        return $this;
    }
    /**
     * Get Header value
     * @return \AisFssp\StructType\EMailHeaderType[]|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\EMailHeaderType[] $header
     * @return \AisFssp\StructType\EMailAttachmentType
     */
    public function setHeader(array $header = array())
    {
        foreach ($header as $eMailAttachmentTypeHeaderItem) {
            // validation for constraint: itemType
            if (!$eMailAttachmentTypeHeaderItem instanceof \AisFssp\StructType\EMailHeaderType) {
                throw new \InvalidArgumentException(sprintf('The Header property can only contain items of \AisFssp\StructType\EMailHeaderType, "%s" given', is_object($eMailAttachmentTypeHeaderItem) ? get_class($eMailAttachmentTypeHeaderItem) : gettype($eMailAttachmentTypeHeaderItem)), __LINE__);
            }
        }
        $this->Header = $header;
        return $this;
    }
    /**
     * Add item to Header value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\EMailHeaderType $item
     * @return \AisFssp\StructType\EMailAttachmentType
     */
    public function addToHeader(\AisFssp\StructType\EMailHeaderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\EMailHeaderType) {
            throw new \InvalidArgumentException(sprintf('The Header property can only contain items of \AisFssp\StructType\EMailHeaderType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Header[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\EMailAttachmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
