<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentDatumType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о документе
 * @subpackage Structs
 */
class DocumentDatumType extends InformationType
{
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - documentation: Номер документа | Строка длиной от 1 до 25 символов
     * - minOccurs: 0
     * - maxLength: 25
     * - minLength: 1
     * @var string
     */
    public $number;
    /**
     * The documentDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата документа | Дата | Дата
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $documentDate;
    /**
     * The issuerName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование органа, выдавшего документ | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $issuerName;
    /**
     * The documentFinDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата окончания действия документа | Дата | Дата
     * - minOccurs: 0
     * - maxExclusive: 2100-01-01
     * - minInclusive: 1900-01-01
     * @var string
     */
    public $documentFinDate;
    /**
     * The documentTypeId
     * Meta informations extracted from the WSDL
     * - documentation: Код вида документа | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - totalDigits: 15
     * @var int
     */
    public $documentTypeId;
    /**
     * The documentTypeName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование вида документа | Строка длиной от 1 до 255 символов
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $documentTypeName;
    /**
     * The groundId
     * Meta informations extracted from the WSDL
     * - documentation: Код основания приобретения дееспособности | Идентификатор записи в БД ФНС (для ЕГРЮЛ/ЕГРИП)
     * - minOccurs: 0
     * - totalDigits: 15
     * @var int
     */
    public $groundId;
    /**
     * The groundName
     * Meta informations extracted from the WSDL
     * - documentation: Наименование основания приобретения дееспособности | Строка длиной от 1 до 255 символов
     * - minOccurs: 0
     * - maxLength: 255
     * - minLength: 1
     * @var string
     */
    public $groundName;
    /**
     * Constructor method for DocumentDatumType
     * @uses DocumentDatumType::setNumber()
     * @uses DocumentDatumType::setDocumentDate()
     * @uses DocumentDatumType::setIssuerName()
     * @uses DocumentDatumType::setDocumentFinDate()
     * @uses DocumentDatumType::setDocumentTypeId()
     * @uses DocumentDatumType::setDocumentTypeName()
     * @uses DocumentDatumType::setGroundId()
     * @uses DocumentDatumType::setGroundName()
     * @param string $number
     * @param string $documentDate
     * @param string $issuerName
     * @param string $documentFinDate
     * @param int $documentTypeId
     * @param string $documentTypeName
     * @param int $groundId
     * @param string $groundName
     */
    public function __construct($number = null, $documentDate = null, $issuerName = null, $documentFinDate = null, $documentTypeId = null, $documentTypeName = null, $groundId = null, $groundName = null)
    {
        $this
            ->setNumber($number)
            ->setDocumentDate($documentDate)
            ->setIssuerName($issuerName)
            ->setDocumentFinDate($documentFinDate)
            ->setDocumentTypeId($documentTypeId)
            ->setDocumentTypeName($documentTypeName)
            ->setGroundId($groundId)
            ->setGroundName($groundName);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \AisFssp\StructType\DocumentDatumType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($number) && strlen($number) > 25) || (is_array($number) && count($number) > 25)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 25 element(s) or a scalar of 25 character(s) at most, "%d" length given', is_scalar($number) ? strlen($number) : count($number)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($number) && strlen($number) < 1) || (is_array($number) && count($number) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get documentDate value
     * @return string|null
     */
    public function getDocumentDate()
    {
        return $this->documentDate;
    }
    /**
     * Set documentDate value
     * @param string $documentDate
     * @return \AisFssp\StructType\DocumentDatumType
     */
    public function setDocumentDate($documentDate = null)
    {
        // validation for constraint: maxExclusive
        if ($documentDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $documentDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($documentDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $documentDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentDate) && !is_string($documentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentDate)), __LINE__);
        }
        $this->documentDate = $documentDate;
        return $this;
    }
    /**
     * Get issuerName value
     * @return string|null
     */
    public function getIssuerName()
    {
        return $this->issuerName;
    }
    /**
     * Set issuerName value
     * @param string $issuerName
     * @return \AisFssp\StructType\DocumentDatumType
     */
    public function setIssuerName($issuerName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($issuerName) && strlen($issuerName) > 255) || (is_array($issuerName) && count($issuerName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($issuerName) ? strlen($issuerName) : count($issuerName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($issuerName) && strlen($issuerName) < 1) || (is_array($issuerName) && count($issuerName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issuerName) && !is_string($issuerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerName)), __LINE__);
        }
        $this->issuerName = $issuerName;
        return $this;
    }
    /**
     * Get documentFinDate value
     * @return string|null
     */
    public function getDocumentFinDate()
    {
        return $this->documentFinDate;
    }
    /**
     * Set documentFinDate value
     * @param string $documentFinDate
     * @return \AisFssp\StructType\DocumentDatumType
     */
    public function setDocumentFinDate($documentFinDate = null)
    {
        // validation for constraint: maxExclusive
        if ($documentFinDate >= 2100) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 2100, "%s" given', $documentFinDate), __LINE__);
        }
        // validation for constraint: minInclusive
        if ($documentFinDate < 1900) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be superior or equal to 1900, "%s" given', $documentFinDate), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentFinDate) && !is_string($documentFinDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentFinDate)), __LINE__);
        }
        $this->documentFinDate = $documentFinDate;
        return $this;
    }
    /**
     * Get documentTypeId value
     * @return int|null
     */
    public function getDocumentTypeId()
    {
        return $this->documentTypeId;
    }
    /**
     * Set documentTypeId value
     * @param int $documentTypeId
     * @return \AisFssp\StructType\DocumentDatumType
     */
    public function setDocumentTypeId($documentTypeId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($documentTypeId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $documentTypeId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($documentTypeId, strpos($documentTypeId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($documentTypeId) && !is_numeric($documentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($documentTypeId)), __LINE__);
        }
        $this->documentTypeId = $documentTypeId;
        return $this;
    }
    /**
     * Get documentTypeName value
     * @return string|null
     */
    public function getDocumentTypeName()
    {
        return $this->documentTypeName;
    }
    /**
     * Set documentTypeName value
     * @param string $documentTypeName
     * @return \AisFssp\StructType\DocumentDatumType
     */
    public function setDocumentTypeName($documentTypeName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($documentTypeName) && strlen($documentTypeName) > 255) || (is_array($documentTypeName) && count($documentTypeName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($documentTypeName) ? strlen($documentTypeName) : count($documentTypeName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($documentTypeName) && strlen($documentTypeName) < 1) || (is_array($documentTypeName) && count($documentTypeName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($documentTypeName) && !is_string($documentTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentTypeName)), __LINE__);
        }
        $this->documentTypeName = $documentTypeName;
        return $this;
    }
    /**
     * Get groundId value
     * @return int|null
     */
    public function getGroundId()
    {
        return $this->groundId;
    }
    /**
     * Set groundId value
     * @param int $groundId
     * @return \AisFssp\StructType\DocumentDatumType
     */
    public function setGroundId($groundId = null)
    {
        // validation for constraint: totalDigits
        if (is_float($groundId) && strlen(str_replace(array(' ', '.', ',', '-', '+'), '', $groundId)) !== 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 15 digits, "%d" given', strlen(substr($groundId, strpos($groundId, '.')))), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($groundId) && !is_numeric($groundId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($groundId)), __LINE__);
        }
        $this->groundId = $groundId;
        return $this;
    }
    /**
     * Get groundName value
     * @return string|null
     */
    public function getGroundName()
    {
        return $this->groundName;
    }
    /**
     * Set groundName value
     * @param string $groundName
     * @return \AisFssp\StructType\DocumentDatumType
     */
    public function setGroundName($groundName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($groundName) && strlen($groundName) > 255) || (is_array($groundName) && count($groundName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($groundName) ? strlen($groundName) : count($groundName)), __LINE__);
        }
        // validation for constraint: minLength
        if ((is_scalar($groundName) && strlen($groundName) < 1) || (is_array($groundName) && count($groundName) < 1)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 1 element(s) or a scalar of 1 character(s) at least', __LINE__);
        }
        // validation for constraint: string
        if (!is_null($groundName) && !is_string($groundName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($groundName)), __LINE__);
        }
        $this->groundName = $groundName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DocumentDatumType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
