<?php

namespace AisFssp\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocNoteCollection StructType
 * Meta informations extracted from the WSDL
 * - documentation: Коллекция квитанций на документы
 * @subpackage Structs
 */
class DocNoteCollection extends AbstractStructBase
{
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - documentation: Технологическое сообщение протокола обмена данными
     * - maxOccurs: unbounded
     * @var \AisFssp\StructType\DocNote[]
     */
    public $Note;
    /**
     * Constructor method for DocNoteCollection
     * @uses DocNoteCollection::setNote()
     * @param \AisFssp\StructType\DocNote[] $note
     */
    public function __construct(array $note = array())
    {
        $this
            ->setNote($note);
    }
    /**
     * Get Note value
     * @return \AisFssp\StructType\DocNote[]|null
     */
    public function getNote()
    {
        return $this->Note;
    }
    /**
     * Set Note value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DocNote[] $note
     * @return \AisFssp\StructType\DocNoteCollection
     */
    public function setNote(array $note = array())
    {
        foreach ($note as $docNoteCollectionNoteItem) {
            // validation for constraint: itemType
            if (!$docNoteCollectionNoteItem instanceof \AisFssp\StructType\DocNote) {
                throw new \InvalidArgumentException(sprintf('The Note property can only contain items of \AisFssp\StructType\DocNote, "%s" given', is_object($docNoteCollectionNoteItem) ? get_class($docNoteCollectionNoteItem) : gettype($docNoteCollectionNoteItem)), __LINE__);
            }
        }
        $this->Note = $note;
        return $this;
    }
    /**
     * Add item to Note value
     * @throws \InvalidArgumentException
     * @param \AisFssp\StructType\DocNote $item
     * @return \AisFssp\StructType\DocNoteCollection
     */
    public function addToNote(\AisFssp\StructType\DocNote $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AisFssp\StructType\DocNote) {
            throw new \InvalidArgumentException(sprintf('The Note property can only contain items of \AisFssp\StructType\DocNote, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Note[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AisFssp\StructType\DocNoteCollection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
